static char convdate_c_rcsid[]="convdate.c,v 1.1.1.1 1994/06/18 19:43:33 kerce Exp";

/*-----------------------------------------------------------------------------
 * Kingsley Kerce
 *
 * Copyright (c) 1994
 *
 * Supercomputer Computations Research Institute (SCRI)
 * Florida State University
 *
 * SCRI representatives make no claims about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * convdate.c,v
 * Revision 1.1.1.1  1994/06/18  19:43:33  kerce
 * DQS X Distribution
 *
 *---------------------------------------------------------------------------*/

#define MAINPROGRAM
#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include "error.h"
#include "strdup.h"
#include "stdstuff.h"
#include "cpyright.h"
#include "acctfile.h"
#include "statfile.h"
#include "util.h"

char *ProgramName = NULL;
void (*FatalErrorHook)();

int
main (argc, argv)
     int argc;
     char **argv;
{
  unsigned long int TimeOfDay;

  DENTER_MAIN ((DQS_EVENT, "convdate"));
  dqs_setup (QSUB, argv[0]);

  FatalErrorHook = NULL;
  ProgramName = argv[0];

  if (argc != 2)
    {
      fprintf (stderr, "Usage: %s timeofday\n", ProgramName);
      exit (EXIT_FAILURE);
    }

  if (sscanf (argv[1], "%lu", &TimeOfDay) != 1)
    {
      Error (NULL, 0, 0, "cannot parse `%s' as an unsigned long integer",
	     argv[1]);
      exit (EXIT_FAILURE);
    }
  
  puts (TimeC ((time_t *) TimeOfDay));

  exit (EXIT_SUCCESS);
}


/* Set Emacs C-mode style.
   Local Variables:
   c-style: GNU
   End:
 */
