static char about_c_rcsid[]="about.c,v 1.1.1.1 1994/06/18 19:43:28 kerce Exp";

/*-----------------------------------------------------------------------------
 * Kingsley Kerce
 *
 * Copyright (c) 1994
 *
 * Supercomputer Computations Research Institute (SCRI)
 * Florida State University
 *
 * SCRI representatives make no claims about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * about.c,v
 * Revision 1.1.1.1  1994/06/18  19:43:28  kerce
 * DQS X Distribution
 *
 *---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/AsciiText.h>
#include "h.h"
#include "def.h"
#include "struct.h"
#include "dqs.h"
#include "globals.h"
#include "stdstuff.h"
#include "about.h"

extern char *Title;
extern char *Version;
extern char *AboutTextString;

static void
DQSUsageAboutOK (W, ParentW, CallData)
     Widget W;
     Widget ParentW;
     caddr_t CallData;
{
  DENTER ((DQS_EVENT, "DQSUsageAboutOK"));

  XtPopdown (ParentW);

  DEXIT;
}

void
DQSUsageAbout (W, ClientData, CallData)
     Widget W;
     caddr_t ClientData;
     caddr_t CallData;
{
  static Widget DQSUsageAboutParentW;
  static Widget DQSUsageAboutFormW;
  static Widget DQSUsageAboutTitleLabelW;
  static Widget DQSUsageAboutTextW;
  static Widget DQSUsageAboutOKButtonW;
  static int DejaVu = 0;

  DENTER ((DQS_EVENT, "DQSUsageAbout"));

  if (DejaVu == 0)
    {
      DQSUsageAboutParentW =
	XtCreatePopupShell ("DQSUsageAboutParent", transientShellWidgetClass,
			    W, NULL, ZERO);
      
      DQSUsageAboutFormW =
	XtCreateManagedWidget ("DQSUsageAboutForm", formWidgetClass,
			       DQSUsageAboutParentW, NULL, ZERO);

      DQSUsageAboutTitleLabelW =
	XtCreateManagedWidget("DQSUsageAboutTitle", labelWidgetClass,
			      DQSUsageAboutFormW, NULL, ZERO);
      
      DQSUsageAboutTextW =
	XtCreateManagedWidget("DQSUsageAboutText", asciiTextWidgetClass,
			      DQSUsageAboutFormW, NULL, ZERO);
      {
	Arg wargs[1];

	XtSetArg (wargs[0], XtNstring,
		  BuildAboutTextString (Title, Version, AboutTextString));
	XtSetValues (DQSUsageAboutTextW, wargs, 1);
      }
      
      DQSUsageAboutOKButtonW =
	XtCreateManagedWidget ("DQSUsageAboutOK", commandWidgetClass,
			       DQSUsageAboutFormW, NULL, ZERO);
      XtAddCallback(DQSUsageAboutOKButtonW, XtNcallback,
		    (XtCallbackProc) DQSUsageAboutOK, DQSUsageAboutParentW);

      DejaVu = 1;
    }
  
  XtPopup (DQSUsageAboutParentW, XtGrabNone);

  DEXIT;
}


/* Set Emacs C-mode style.
   Local Variables:
   c-style: GNU
   End:
 */
