static char qstat_rcsid[]="qstat.c,v 1.2 1994/11/28 16:56:08 kerce Exp";
/***********************************************************
 *
 * Written By: Raju R. Lakhamraju 
 * Date: 7/2/94, 4/01/94, 6/17/94
 *
 * Based on Motif qmon by Jeff Snyder
 *
 * Major modifications: Removed motif calls and replaced
 *                     with athena widget set calls.
 *      Added several modules for new DQS commands.
 *
 * Copyright 1992, 1993, 1994
 *
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *  qstat.c,v
 * Revision 1.2  1994/11/28  16:56:08  kerce
 * *** empty log message ***
 *
 * Revision 1.4  1994/09/13  18:03:59  raju
 * *** empty log message ***
 *
 * Revision 1.3  1994/08/21  03:00:05  raju
 * *** empty log message ***
 *
 * Revision 1.2  1994/07/11  15:37:10  raju
 * updated option list of qstat
 *
 * Revision 1.1  1994/07/11  15:29:02  raju
 * Initial revision
 *
 *
 *
 **********************************************************/
#include "globals.h"

static Widget           qstat_popup;
static Widget           widget_qstatrc;
static Widget           widget_qstatlabel;
static Widget           widget_qstatframe;
static Widget           widget_qstatmenu;
static Widget           widget_qstatmain;
static Widget           widget_qstatexec;
static Widget           widget_qstatclear;
static Widget           widget_qstatclose;
static Widget           widget_qstatseparator;
static Widget           widget_qstatopt;

struct optionstruct qstatmenu[]={
  0,"Cell         ","-cell",MENUTYPE,NULL,NULL,
  0,"Long Listing    ","-ext",FLAGTYPE,"False",NULL,
  0,"Full Format     ","-f",FLAGTYPE,"False",NULL,
  0,"Help            ","-help",FLAGTYPE,"False",NULL,
  0,"Job identifier  ","-jid",INPUTTYPE,NULL,NULL,
  0,"User List    ","-u",MENUTYPE,NULL,NULL,
  0,"Resource List   ","-l",INPUTTYPE,NULL,NULL,
  0,"Destination  ","-q",MENUTYPE,NULL,NULL,
  0,NULL,NULL,(int)NULL,NULL,NULL
};


/***********************************************************
 * pb_qstatexec - Activate callback for exec
 */
XtCallbackProc pb_qstatexec(Widget w, caddr_t client_data, caddr_t call_data)
{
  buildcommand(QSTAT_BINARY,qstatmenu,0);
}


/***********************************************************
 * pb_qstatclear - Activate callback for clear
 */
XtCallbackProc pb_qstatclear(Widget w, caddr_t client_data, caddr_t call_data)
{
  clearsubmenu(qstatmenu);
  QmonTextSetString(qstatmenu[0].widgetid ,current_cell );
  QmonTextSetString(qstatmenu[5].widgetid ,current_user );
  QmonTextSetString(qstatmenu[6].widgetid ,current_resource );
  QmonTextSetString(qstatmenu[7].widgetid ,current_destination );
}


/***********************************************************
 * pb_qstatclose - Activate callback for close

 */
XtCallbackProc pb_qstatclose(Widget w, caddr_t client_data, caddr_t call_data)
{
  closemainmenuwin();
}


/***********************************************************
 * create_qstat_dialog - Create widgets used for the qstat menu
 */
int create_qstat_dialog(Widget w,XtPointer client_data, XtPointer call_data)
{
  int             ii;
  Arg             args[32];
  Widget 	qstat_form;
  Position    x, y;
  Dimension   width, height;
  Widget exec, clear, close;

  qstatmenu[0].list = cell_list;
  qstatmenu[5].list = user_list;
  qstatmenu[7].list = queue_list;

  ii = 0;
  XtSetArg(args[0], XtNwidth, &width); ii++;
  XtSetArg(args[1], XtNheight, &height); ii++;
  XtGetValues(w, args, ii);
  XtTranslateCoords(w, (Position) (width / 2), (Position) (height / 2),
                    &x, &y);

  ii = 0;
  XtSetArg(args[ii], XtNx, x);                         ii++;
  XtSetArg(args[ii], XtNy, y);                         ii++;

  qstat_popup = XtCreatePopupShell("popup", transientShellWidgetClass, w,
                             args, ii);

  ii = 0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  qstat_form = XtCreateManagedWidget("form", formWidgetClass, qstat_popup,args, ii);

  ii = 0;
  XtSetArg(args[ii], XtNborderWidth, (Dimension) 0); ii++;
  widget_qstatlabel=
	XtCreateManagedWidget("Qstat",labelWidgetClass,qstat_form,args,ii);

  ii=0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  XtSetArg(args[ii], XtNfromVert, widget_qstatlabel); ii++;
  widget_qstatmain=XtCreateManagedWidget("box",formWidgetClass,qstat_form,
                                        args,ii);

 exec=QmonAddButtonN(widget_qstatmain,NULL,"Exec",(XtCallbackProc)pb_qstatexec,NULL);
 clear=QmonAddButtonN(widget_qstatmain,exec,"Clear",(XtCallbackProc)pb_qstatclear,NULL);
 close=QmonAddButtonN(widget_qstatmain,clear,"Close",(XtCallbackProc)pb_qstatclose,NULL);

  widget_qstatopt=createmenuoptions(qstat_form,widget_qstatmain,qstatmenu,(XtCallbackProc)NULL);
 
  
}


/***********************************************************
 * openwidget_qstat - Open the qstat menu
 */
int openwidget_qstat()
{
  pb_qstatclear(NULL,NULL,NULL);
  XtPopup(qstat_popup,XtGrabNone);
}


/***********************************************************
 * closewidget_qstat - Close the qstat menu
 */
int closewidget_qstat()
{
  XtPopdown(qstat_popup);
}
