static char     preferences_rcsid[] = "preferences.c,v 1.1 1994/11/28 16:55:23 kerce Exp";
/***********************************************************
 *
 * Written By: Raju R. Lakhamraju 
 * Date: 7/2/94, 4/01/94, 6/17/94
 *
 * Based on Motif qmon by Jeff Snyder
 *
 * Major modifications: Removed motif calls and replaced
 *                     with athena widget set calls.
 *      Added several modules for new DQS commands.
 *
 * Copyright 1992, 1993, 1994
 *
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *  preferences.c,v
 * Revision 1.1  1994/11/28  16:55:23  kerce
 * Initial revision
 *
 * Revision 1.7  1994/09/13  18:03:59  raju
 * *** empty log message ***
 *
 * Revision 1.6  1994/08/21  02:58:34  raju
 * *** empty log message ***
 *
 * Revision 1.5  1994/08/11  21:04:51  raju
 * working on DefaultSettings
 *
 * Revision 1.4  1994/07/20  01:01:35  raju
 * working version of cell_list and current_cell
 *
 * Revision 1.3  1994/07/15  18:12:20  raju
 * indented and made it work
 *
 * Revision 1.2  1994/07/15  11:58:45  raju
 * Made the basic layout for this module
 *
 * Revision 1.1  1994/07/11  18:40:14  raju
 * Initial revision
 *
 *
 *
 *
 **********************************************************/
#include "globals.h"

extern queueiconstruct *queueicon;
extern char	*currentdirectory;


char     current_resource[MAX_STRING_SIZE];
char     current_destination[MAX_STRING_SIZE];
char     current_date[MAX_STRING_SIZE];
char     current_account[MAX_STRING_SIZE];
char     current_interval[MAX_STRING_SIZE];
char     current_errpath[MAX_STRING_SIZE];
char     current_mqueue[MAX_STRING_SIZE];
char     current_jobname[MAX_STRING_SIZE];
char     current_outpath[MAX_STRING_SIZE];
char     current_priority[MAX_STRING_SIZE];
char     current_passwdfile[MAX_STRING_SIZE];
char     current_shellpath[MAX_STRING_SIZE];
char     current_exportvars[MAX_STRING_SIZE];
char     current_user[MAX_STRING_SIZE];

Boolean  current_parallel;
Boolean  current_holduser;
Boolean  current_hard;
Boolean  current_soft;
Boolean  current_rerun;

static Widget   preferences_popup = NULL;
static Widget   widget_preferencesmain;
static Widget   widget_preferenceslabel;
static Widget   widget_rcpreferencesv;
static Widget   widget_rcpreferences;
static Widget   widget_showpreferencessframe;
static Widget   widget_label;
static Widget   widget_separator;
static Widget   widget_preferencesopt;


struct optionstruct preferencesmenu[] = {
0, "Cell           ", "-cell", MENUTYPE, NULL, NULL,
0, "Resource List     ", "-l", INPUTTYPE,NULL, NULL, 
0, "Destination    ", "-q", MENUTYPE,NULL, NULL,
0, "Date/Time         ", "-aq", INPUTTYPE, NULL, NULL,
0, "Account List   ", "-A", MENUTYPE,NULL, NULL,
0, "Interval          ", "-c", INPUTTYPE, NULL, NULL,
0, "Std. Error Path   ", "-e", INPUTTYPE, NULL, NULL,
0, "Parallel          ", "-par", FLAGTYPE, "False", NULL,
0, "User Hold         ", "-h u", FLAGTYPE, "False", NULL,
/*
0, "Hold System       ", "-h s", FLAGTYPE, "False", NULL,
0, "Hold Other        ", "-h o", FLAGTYPE, "False", NULL,
0, "No Hold           ", "-h n", FLAGTYPE, "False", NULL,
*/
0, "Hard              ", "-hard", FLAGTYPE, "False", NULL,
0, "Soft              ", "-soft", FLAGTYPE, "False", NULL,
0, "Master Queue   ", "-master", MENUTYPE,NULL, NULL, 
0, "Job Name          ", "-N", INPUTTYPE, NULL, NULL,
0, "Std. Output Path  ", "-o", INPUTTYPE, NULL, NULL,
0, "Priority          ", "-p", INPUTTYPE, NULL, NULL,
0, "Password File     ", "-Passwd", INPUTTYPE, NULL, NULL,
0, "Rerunable         ", "-r", FLAGTYPE, "False", NULL,
0, "Shell Path List   ", "-S", INPUTTYPE, NULL, NULL,
0, "Export Variables  ", "-v", INPUTTYPE, NULL, NULL,
0, "User           ", "-v", MENUTYPE, NULL, NULL,
0, NULL, NULL, (int) NULL, NULL, NULL
};


/***********************************************************
 * initprefs - Initialize the preferences module                
 */
void initprefs ()
{
	char 		*ptr=NULL;

/*
	ptr = malloc(sizeof(char *));	
	ptr = QmonTextGetString(preferencesmenu[0].widgetid);
	strcpy(current_cell,ptr);
	printf("current_cell -> %s\n",current_cell);
*/
}
/***********************************************************
 * pb_preferencesapply - apply the fields in preferences to qmon
 */
XtCallbackProc pb_preferencesapply(Widget w, caddr_t client_data, caddr_t call_data)
{
    char	*ptr=NULL;
    int 	n=0;

    ptr = malloc(sizeof(char *));
    ptr = QmonTextGetString(preferencesmenu[n].widgetid ); n++ ;
    if(!strcmp(ptr,current_cell)) {
	/* Do Nothing */
    }
    else {
        bzero(current_cell,MAX_STRING_SIZE);
        strncpy(current_cell,ptr,strlen(ptr));
        printf("new_current_cell -> %s\n",current_cell);
        UnMapIconWin ();
        refreshicons ();
        MapIconWin ();
    }

    ptr = QmonTextGetString(preferencesmenu[n].widgetid ); n++ ;
    bzero(current_resource,MAX_STRING_SIZE);
    strncpy(current_resource,ptr,strlen(ptr));
    ptr = QmonTextGetString(preferencesmenu[n].widgetid ); n++ ;
    bzero(current_destination,MAX_STRING_SIZE);
    strncpy(current_destination,ptr,strlen(ptr));
    ptr = QmonTextGetString(preferencesmenu[n].widgetid ); n++ ;
    bzero(current_date,MAX_STRING_SIZE);
    strncpy(current_date,ptr,strlen(ptr)); 
    ptr = QmonTextGetString(preferencesmenu[n].widgetid ); n++ ;
    bzero(current_account,MAX_STRING_SIZE);
    strncpy(current_account,ptr,strlen(ptr));
    ptr = QmonTextGetString(preferencesmenu[n].widgetid ); n++ ;
    bzero(current_interval,MAX_STRING_SIZE);
    strncpy(current_interval,ptr,strlen(ptr));
    ptr = QmonTextGetString(preferencesmenu[n].widgetid ); n++ ;
    bzero(current_errpath,MAX_STRING_SIZE);
    strncpy(current_errpath,ptr,strlen(ptr));
    current_parallel  =  
		QmonToggleGetState(preferencesmenu[n].widgetid ); n++ ;
    current_holduser  =  
		QmonToggleGetState(preferencesmenu[n].widgetid ); n++ ;
    current_hard      =  
		QmonToggleGetState(preferencesmenu[n].widgetid ); n++ ;
    current_soft      =  
		QmonToggleGetState(preferencesmenu[n].widgetid ); n++ ;
    ptr = QmonTextGetString(preferencesmenu[n].widgetid ); n++ ;
    bzero(current_mqueue,MAX_STRING_SIZE);
    strncpy(current_mqueue,ptr,strlen(ptr));
    ptr = QmonTextGetString(preferencesmenu[n].widgetid ); n++ ;
    bzero(current_jobname,MAX_STRING_SIZE);
    strncpy(current_jobname,ptr,strlen(ptr));
    ptr = QmonTextGetString(preferencesmenu[n].widgetid ); n++ ;
    bzero(current_outpath,MAX_STRING_SIZE);
    strncpy(current_outpath,ptr,strlen(ptr));
    ptr = QmonTextGetString(preferencesmenu[n].widgetid ); n++ ;
    bzero(current_priority,MAX_STRING_SIZE);
    strncpy(current_priority,ptr,strlen(ptr));
    ptr = QmonTextGetString(preferencesmenu[n].widgetid ); n++ ;
    bzero(current_passwdfile,MAX_STRING_SIZE);
    strncpy(current_passwdfile,ptr,strlen(ptr));
    current_rerun     =  
		QmonToggleGetState(preferencesmenu[n].widgetid ); n++ ;
    ptr = QmonTextGetString(preferencesmenu[n].widgetid ); n++ ;
    bzero(current_shellpath,MAX_STRING_SIZE);
    strncpy(current_shellpath,ptr,strlen(ptr));
    ptr = QmonTextGetString(preferencesmenu[n].widgetid ); n++ ;
    bzero(current_exportvars,MAX_STRING_SIZE);
    strncpy(current_exportvars,ptr,strlen(ptr));
    ptr = QmonTextGetString(preferencesmenu[n].widgetid ); n++ ;
    bzero(current_user,MAX_STRING_SIZE);
    strncpy(current_user,ptr,strlen(ptr));
}


/***********************************************************
 * pb_preferencesclose - Closes the preferences window
 */
XtCallbackProc pb_preferencesclose(Widget w, caddr_t client_data, caddr_t call_data)
{
	closemainmenuwin();
}

/***********************************************************
 * pb_preferencesclear - Reset the preferences window
 */
XtCallbackProc pb_preferencesclear(Widget w, int client_data, caddr_t call_data)
{
	int             n=0;
	int             len;
	char           *ptr1 = NULL;
	char           *pwd = NULL;
	char            buffer[MAX_STRING_SIZE];
	FILE           *pfp=NULL;

        if(client_data)
	   clearsubmenu(preferencesmenu);

	/*  cell_list */

	if(current_cell)
	   QmonTextSetString(preferencesmenu[n].widgetid ,current_cell );
	n++; /* resource list */
	n++;
	if(queue_list)
	   QmonTextSetString(preferencesmenu[n].widgetid ,queue_list->name );

	n++; /* date/time  */

	pfp = popen(DATE_BINARY,"r");
	fgets(buffer,100,pfp);
	len = strlen(buffer);
	ptr1=malloc(len);
	strncpy(ptr1,buffer,len-1);
	QmonTextSetString(preferencesmenu[n].widgetid ,ptr1);

	n++; /* account_list */
	if(account_list)
	   QmonTextSetString(preferencesmenu[n].widgetid ,account_list->name);
	n++ ; /* interval */

	n++ ; /* Std. Error Path */
	pfp = popen("pwd","r");
	fgets(buffer,100,pfp);
	len = strlen(buffer);
	pwd=malloc(len);
	strncpy(pwd,buffer,len-1);
	QmonTextSetString(preferencesmenu[n].widgetid ,pwd);

	n++ ; /* Parallel */
	n++ ; /* Hold User       */
	n++ ; /* Hard            */
	n++ ; /* Soft            */

	n++ ; /* Master Queue    */
	if(queue_list)
	   QmonTextSetString(preferencesmenu[n].widgetid ,queue_list->name);

	n++ ; /* Job Name        */

	n++ ; /* Std. Output Path*/
	QmonTextSetString(preferencesmenu[n].widgetid ,pwd);
	n++ ; /* Priority        */
	n++ ; /* Password File   */
	n++ ; /* Rerunable       */
	n++ ; /* Shell Path List */
	n++ ; /* Export Variables*/

	n++ ; /* User List       */
	if(user_list)
	   QmonTextSetString(preferencesmenu[n].widgetid ,user_list->name);

}

/***********************************************************
 * create_preferences_dialog - Create the widgets used for the
 *                       preferences menu
 */
int create_preferences_dialog(Widget w, XtPointer client_data, XtPointer call_data)
{
	char           *ptr = NULL;
	int             ii;
	int             jj;
	int             n;
	Arg             args[32];
	Widget          preferences_form;
	Position        x, y;
	Dimension       width, height;
	Widget          exec, clear, close;


        preferencesmenu[0].list = cell_list ;
        preferencesmenu[2].list = queue_list ;
        preferencesmenu[4].list = account_list ;
        preferencesmenu[11].list = queue_list ;
        preferencesmenu[19].list = user_list ;

	ii = 0;
	XtSetArg(args[0], XtNwidth, &width);
	ii++;
	XtSetArg(args[1], XtNheight, &height);
	ii++;
	XtGetValues(w, args, ii);
	XtTranslateCoords(w, (Position) (width / 2), (Position) (height / 2),
			  &x, &y);
	ii = 0;
	XtSetArg(args[ii], XtNx, x);
	ii++;
	XtSetArg(args[ii], XtNy, y);
	ii++;

	preferences_popup = XtCreatePopupShell("popup", transientShellWidgetClass, w,
					       args, ii);

	ii = 0;
	XtSetArg(args[ii], XtNresizable, True);
	ii++;
	preferences_form = XtCreateManagedWidget("form", formWidgetClass, preferences_popup, args,
						 ii);

	ii = 0;
	XtSetArg(args[ii], XtNborderWidth, (Dimension) 0);
	ii++;
	widget_preferenceslabel =
		XtCreateManagedWidget("Preferences", labelWidgetClass, preferences_form, args
				      ,ii);

	ii = 0;
	XtSetArg(args[ii], XtNresizable, True);
	ii++;
	XtSetArg(args[ii], XtNfromVert, widget_preferenceslabel);
	ii++;
	widget_preferencesmain = XtCreateManagedWidget("box", formWidgetClass, preferences_form,
						       args, ii);

	exec = QmonAddButtonN(widget_preferencesmain, NULL, "Apply",(XtCallbackProc) pb_preferencesapply, (XtPointer)1);
	clear = QmonAddButtonN(widget_preferencesmain, exec, "Reset",(XtCallbackProc) pb_preferencesclear, (XtPointer)1);
	close = QmonAddButtonN(widget_preferencesmain, clear, "Close",(XtCallbackProc) pb_preferencesclose, (XtPointer)NULL);

	widget_preferencesopt = createmenuoptions(preferences_form, widget_preferencesmain, preferencesmenu,(XtCallbackProc) NULL);	/* preferencesaction); */

	pb_preferencesclear((Widget)NULL,(int)NULL,(caddr_t)NULL);
        pb_preferencesapply((Widget)NULL,(caddr_t)NULL,(caddr_t)NULL);
}
/***********************************************************
 * openwidget_preferences - Open the main menu preferences window
 */
int openwidget_preferences()
{
	XtPopup(preferences_popup, XtGrabNone);
}


/***********************************************************
 * closewidget_preferences - Close the main menu preferences window
 */
int closewidget_preferences()
{
	XtPopdown(preferences_popup);
}
