static char qidle_c_rcsid[] = "qidle.c,v 1.2 1994/12/01 14:44:19 kerce Exp";

/**********************************************************
 * qidle.c - Monitors X-Window activity and suspends queue
 *           if a user is using the console.
 *
 * Version: 1.1
 * Written By: Jeff Snyder
 * Date: 11/7/91
 *
 * Copyright 1991
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 * qidle.c,v
 * Revision 1.2  1994/12/01  14:44:19  kerce
 * Solaris 2.x mods
 *
 * Revision 1.1.1.1  1994/06/18  19:44:37  kerce
 * DQS X Distribution
 *
 * Revision 1.1  1993/02/10  20:33:37  dan
 * Initial revision
 *
 **********************************************************/

#define MAINPROGRAM
#define XK_MISCELLANY
#include <stdio.h>
#if defined(SYSV) || defined(SVR4) || defined(__SVR4) || defined(SOLARIS24) || defined(SOLARIS23)
#include <string.h>
#else
#include <strings.h>
#endif
#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h" 

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysymdef.h>

#include <sys/types.h>
#include <signal.h>
#include <sys/wait.h>
#include "bitmap.h"
#include "prognames.h"

#define SLEEPTIME 300

Display *dpy;
char *default_dpy = "unix:0";
char *dpy_name;
char *envdpy;
char *getenv();
char *progname;
XEvent event;
unsigned long fg,bg;
int pid;
char cmdbuf[1024];
char *queuename=NULL;
int myhandler();
void dqs_quit();
static     dqs_list_type    *resp=(dqs_list_type *) NULL;
static     dqs_list_type    listel;


main(argc, argv, envp)
     int argc;
     char** argv;
     char** envp;
{
  int i;
  int DEBUG=0;
  char text[10];
  char *geometry=NULL;
  KeySym mykey;
  XWMHints *wmhi=XAllocWMHints();
  Window winid=0,oldwinid=0;
  int rtr,jobstopped=0;
  Window top,quitwin,sleepwin,inputwin;
  int scr;
  int delayvalue=SLEEPTIME;
  Pixmap dqspixenabled,dqspixdisabled;
  Pixmap quitpixfg,quitpixbg;
  Pixmap sleeppixfg,sleeppixbg;
  XSizeHints sihi;
  
  int              sfd;
  char             c;
  char             *tp;
  int              tpi;
  string           str;
  FILE             *fp;
  dqs_list_type    *argv_list=(dqs_list_type *) NULL;
  dqs_list_type    *head=(dqs_list_type *) NULL;
  dqs_list_type    *listel_ptr;
  dqs_list_type    *tmp_ptr=NULL;
  
  DENTER_MAIN((DQS_EVENT,"qidle"));              
  
  progname=argv[0];
  
  dqs_setup(QIDLE,argv[0]);
  dqs_setup_sig_handlers();
  
  bzero((char *)&listel,sizeof(listel));
  
  argv_list=dqs_args2list(++argv,argc);
  listel.job=dqs_parse_job(argv_list,envp);
  
  if (listel.job->verify)
    {
      dqs_show_job(listel.job);
      DEXIT;
      exit(0);
    }    
  
  if(listel.job->DQSX_STR13){
    geometry= dqs_string_insert(NULL, listel.job->DQSX_STR13);
    DPRINTF((DQS_EVENT,"geometry= %s", geometry));
  }
  if(listel.job->DQSX_STR15){
    i= atoi(listel.job->DQSX_STR15);
    if(i<0){
      fprintf(stderr,"sleep seconds bad using 300 seconds\n");
    }
  }
  
  if(listel.job->DQSX_STR14){
    dpy_name= dqs_string_insert(NULL, listel.job->DQSX_STR14);
  }
  else{
    dpy_name=default_dpy;
    envdpy = getenv("DISPLAY");
    if(envdpy) dpy_name=envdpy;
    else {
      fprintf(stderr,"DISPLAY environment variable absent using default\n");
    }
  }
  /********************** CONNECT TO SERVER **********************/
  if(pid=(int)fork()) {
    signal(SIGHUP,dqs_quit);
    signal(SIGINT,dqs_quit);
    signal(SIGQUIT,dqs_quit);
    signal(SIGTERM,dqs_quit);
    signal(SIGALRM,dqs_quit);
    while(pid!=(int)wait(0));
    
    listel.type=SIGNAL_QUEUE_REQUEST;
    listel.job->suspend_enable= RUNNING;
    listel.job->dqs_o_host=dqs_string_insert(NULL, me.qualified_hostname);
    
    
    if (dqs_send_receive_list(me.default_cell,conf.qmaster_service,&listel,&resp)<0)
      {
	DEXITE;
	exit(DQS_EAGAIN);
      }
    DEXIT;                            
    exit(0);
  }
  
  if ((dpy=XOpenDisplay(dpy_name)) == 0) {
    (void) fprintf (stderr, "%s: cannot connect to server \n",
                    argv[0], XDisplayName(dpy_name));
    DEXITE;                    
    exit(-1);
  }
  
  /*
   *  On the IBM RS/6000, using the mwm window manager, the
   *  exiting of the aixterm window causes the XSelectInput
   *  to fail since the window may not exist anymore.
   *  The following sets up my own error handler which does
   *  nothing but keep the qidle program from exiting.
   */
  XSetErrorHandler(myhandler);
  
  /********************** CREATE WINDOW *******************************/
  scr=DefaultScreen(dpy);
  bg=BlackPixel(dpy,scr);
  fg=WhitePixel(dpy,scr);
  sihi.x=getxpos(geometry);
  sihi.y=getypos(geometry);
  sihi.width=getwidth(geometry);
  sihi.height=getheight(geometry);
  top=XCreateSimpleWindow(dpy,DefaultRootWindow(dpy),
			  sihi.x,sihi.y,
			  sihi.width,sihi.height,
			  5,fg,bg);
  dqspixenabled=XCreatePixmapFromBitmapData(dpy,top,dqspix1_bits,64,64,
					    bg,fg,DefaultDepth(dpy,scr));
  dqspixdisabled=XCreatePixmapFromBitmapData(dpy,top,dqspix1_bits,64,64,
					     fg,bg,DefaultDepth(dpy,scr));
  XSetWindowBackgroundPixmap(dpy,top,dqspixenabled);
  sihi.flags=0;
  XSetStandardProperties(dpy,top,"qidle","qidle",
			 dqspixenabled,argv,argc,&sihi);
  XSelectInput(dpy,top,
	       ButtonPressMask|
	       KeyPressMask);
  XMapWindow(dpy,top);
  quitwin=XCreateSimpleWindow(dpy,top,
			      1,1,
			      quit_width, quit_height,
			      1,fg,bg);
  XSelectInput(dpy,quitwin,
	       ButtonPressMask|
	       EnterWindowMask|
	       LeaveWindowMask);
  quitpixfg=XCreatePixmapFromBitmapData(dpy,quitwin,quit_bits,
					quit_width,quit_height,
					bg,fg,DefaultDepth(dpy,scr));
  quitpixbg=XCreatePixmapFromBitmapData(dpy,quitwin,quit_bits,
					quit_width,quit_height,
					fg,bg,DefaultDepth(dpy,scr));
  XSetWindowBackgroundPixmap(dpy,quitwin,quitpixfg);
  XMapWindow(dpy,quitwin);
  
  sleepwin=XCreateSimpleWindow(dpy,top,
			       dqspix1_width+1,1,
			       sleep_width,sleep_height,
			       1,fg,bg);
  XSelectInput(dpy,sleepwin,
	       ButtonPressMask|
	       EnterWindowMask|
	       LeaveWindowMask);
  sleeppixfg=XCreatePixmapFromBitmapData(dpy,sleepwin,sleep_bits,
					 sleep_width,sleep_height,
					 bg,fg,DefaultDepth(dpy,scr));
  sleeppixbg=XCreatePixmapFromBitmapData(dpy,sleepwin,sleep_bits,
					 sleep_width,sleep_height,
					 fg,bg,DefaultDepth(dpy,scr));
  XSetWindowBackgroundPixmap(dpy,sleepwin,sleeppixfg);
  XMapWindow(dpy,sleepwin);
  
  inputwin=XCreateSimpleWindow(dpy,top,
			       0,0,
			       256,20,
			       1,fg,bg);
  wmhi->flags=InputHint;
  wmhi->input=True;
  XSetWMHints(dpy,inputwin,wmhi);
  XSelectInput(dpy,inputwin,
	       ButtonPressMask|
	       KeyPressMask|
	       ExposureMask);
  
  /********************** MONITOR WINDOW ******************************/
  while(1) {
    if(XPending(dpy)) {
      while(XPending(dpy)) {
	XNextEvent(dpy,&event);
	switch(event.type) {
	case ButtonPress:
	  if(event.xbutton.window==quitwin) {
	    XSetWindowBackgroundPixmap(dpy,quitwin,quitpixfg);
	    XClearWindow(dpy,quitwin);
	    XFlush(dpy);
	    
	    listel.type=SIGNAL_QUEUE_REQUEST;
	    listel.job->suspend_enable= RUNNING;
	    listel.job->dqs_o_host=dqs_string_insert(NULL, me.qualified_hostname);
	    
	    
	    if (dqs_send_receive_list(me.default_cell,conf.qmaster_service,&listel,&resp)<0)
	      {
		DEXITE;
		exit(DQS_EAGAIN);
	      }
	    DEXIT;                        
	    exit(0);
	  }
	  else if(event.xbutton.window==sleepwin) {
	    XSetWindowBackgroundPixmap(dpy,sleepwin,sleeppixfg);
	    XClearWindow(dpy,sleepwin);
	    XFlush(dpy);
	    usleep(100000);
	    XSetWindowBackgroundPixmap(dpy,sleepwin,sleeppixbg);
	    XClearWindow(dpy,sleepwin);
	    getnumarg(inputwin,&delayvalue);
            XSetWindowBackgroundPixmap(dpy,sleepwin,sleeppixfg);
	    XClearWindow(dpy,sleepwin);
	  }
	  break;
	case EnterNotify:
	  if(event.xcrossing.window==quitwin) {
	    XSetWindowBackgroundPixmap(dpy,quitwin,quitpixbg);
	    XClearWindow(dpy,quitwin);
	  }
	  else if(event.xcrossing.window==sleepwin) {
	    XSetWindowBackgroundPixmap(dpy,sleepwin,sleeppixbg);
            XClearWindow(dpy,sleepwin);
	  }
	  break;
	case LeaveNotify:
	  if(event.xcrossing.window==quitwin) {
	    XSetWindowBackgroundPixmap(dpy,quitwin,quitpixfg);
	    XClearWindow(dpy,quitwin);
	  }
	  else if(event.xcrossing.window==sleepwin) {
            XSetWindowBackgroundPixmap(dpy,sleepwin,sleeppixfg);
	    XClearWindow(dpy,sleepwin);
	  }
	  break;
	}
      }
      if(!jobstopped) {
	XSetWindowBackgroundPixmap(dpy,top,dqspixdisabled);
	XSetStandardProperties(dpy,top,"qidle","qidle",
			       dqspixdisabled,argv,argc,&sihi);
	XClearWindow(dpy,top);
	
	listel.type=SIGNAL_QUEUE_REQUEST;
	listel.job->suspend_enable= SUSPENDED;
	listel.job->dqs_o_host=dqs_string_insert(NULL, me.qualified_hostname);
	
	
	if (dqs_send_receive_list(me.default_cell,conf.qmaster_service,&listel,&resp)<0)
	  {
	    DEXITE;
	    exit(DQS_EAGAIN);
	  }                              
	
	
      }
      jobstopped=delayvalue*10;
    }
    else {
      usleep(100000);
      if(jobstopped) {
	jobstopped--;
	if(!jobstopped) {
	  XSetWindowBackgroundPixmap(dpy,top,dqspixenabled);
	  XSetStandardProperties(dpy,top,"qidle","qidle",
				 dqspixenabled,argv,argc,&sihi);
	  XClearWindow(dpy,top);
	  
	  
	  listel.type=SIGNAL_QUEUE_REQUEST;
	  listel.job->suspend_enable= RUNNING;
	  listel.job->dqs_o_host=dqs_string_insert(NULL, me.qualified_hostname);
	  
	  
	  if (dqs_send_receive_list(me.default_cell,conf.qmaster_service,&listel,&resp)<0)
	    {
	      DEXITE;
	      exit(DQS_EAGAIN);
	    }                              
	}
      }
      XGetInputFocus(dpy,&winid,&rtr);
      if(winid<2)
	winid=XDefaultRootWindow(dpy);
      if(oldwinid!=winid) {
	oldwinid=winid;
	XSelectInput(dpy,winid,
		     KeyReleaseMask|
		     PointerMotionMask);
      }
    }
  }
  /***************************************************************/
}

getxpos(geometry)
     char *geometry;
{ 
  char *ptr;
  int x;
  if(geometry) {
    for(ptr=geometry;*ptr && *ptr!='+' && *ptr!='-';ptr++);
    if(*ptr) {
      sscanf(ptr,"%d",&x);
      return x;
    }
  }
  return 20;
}

getypos(geometry)
     char *geometry;
{
  char *ptr;
  int y;
  if(geometry) {
    for(ptr=geometry;*ptr && *ptr!='+' && *ptr!='-';ptr++);
    if(*ptr)
      for(ptr++;*ptr && *ptr!='+' && *ptr!='-';ptr++);
    if(*ptr) {
      sscanf(ptr,"%d",&y);
      return y;
    }
  }
  return 20;
}

getwidth(geometry)  
     char *geometry;
{
  if(geometry) {
    if(index(geometry,'x') || index(geometry,'X'))
      return atoi(geometry);
  }
  return 128;
}

getheight(geometry)
     char *geometry;
{
  char *ptr;
  if(geometry) {
    if((ptr=strchr(geometry,'x')) || (ptr=strchr(geometry,'X')))
      return atoi(ptr+1);
  }
  return 58;
}

getnumarg(win,var)
     Window win;
     int *var;
{
  GC gc;
  XEvent event;
  KeySym key;
  int done=0,len;
  char buffer[128],text[10],*ptr,*cutbuf,inbuf[128];
  int ind,nbytes,j;
  int resendit=0;
  
  gc=XCreateGC(dpy,win,0,0);
  XSetBackground(dpy,gc,bg);
  XSetForeground(dpy,gc,fg);
  XMapWindow(dpy,win);
  XFlush(dpy);
  for(ind=0;ind<128;ind++)
    inbuf[ind]=buffer[ind]=0;
  ind=0;
  while(!done) {
    XNextEvent(dpy,&event);
    switch(event.type) {
    case Expose:
      if(!event.xexpose.count) {
	sprintf(buffer,"%ds => %ss ",*var,inbuf);
	XDrawImageString(dpy,win,gc,5,15,buffer,strlen(buffer));
      }
      break;
    case ButtonPress:
      if(event.xbutton.button==1)
	done=1;
      break;
    case KeyPress:
      len=XLookupString((XKeyEvent *)&event,
			text,10,&key,(XComposeStatus *)NULL);
      if(len) {
	if(ind && (key==XK_BackSpace || key==XK_Delete)) {
	  ind--;
	  inbuf[ind]=0;
	  sprintf(buffer,"%ds => %ss ",*var,inbuf);
	  XDrawImageString(dpy,win,gc,5,15,buffer,strlen(buffer));
	}
	else if(isdigit(text[0])) {
	  inbuf[ind]=text[0];
	  ind++;
	  sprintf(buffer,"%ds => %ss ",*var,inbuf);
	  XDrawImageString(dpy,win,gc,5,15,buffer,strlen(buffer));
	}
	else if(key==XK_Return) {
	  done=1;
	}
      }
      break;
    }
  }
  XFlush(dpy);
  XUnmapWindow(dpy,win);
  XFreeGC(dpy,gc);
  if(strlen(inbuf))
    *var=atoi(inbuf);
}

int myhandler(dpy,myerr)
     Display *dpy;
     XErrorEvent *myerr;
{
  /*  char msg[80];
      XGetErrorText(dpy,myerr->error_code,msg,80);
      fprintf(stderr,"Error code %s\n",msg);*/
}


void dqs_quit()
{
  DENTER((DQS_EVENT,"dqs_quit"));
  
  listel.type=SIGNAL_QUEUE_REQUEST;
  listel.job->suspend_enable= RUNNING;
  listel.job->dqs_o_host=dqs_string_insert(NULL, me.qualified_hostname);
  
  
  if (dqs_send_receive_list(me.default_cell,conf.qmaster_service,&listel,&resp)<0)
    {
      DEXITE;
      exit(DQS_EAGAIN);
    }
  kill(pid,SIGKILL);     
  DEXIT;
  exit(0);
}
