static char dqs_reauth_rcsid[]="$Id: dqs_reauth.c,v 1.3 1998/10/13 15:08:48 green Exp $";

/*----------------------------------------------------
 * dqs_reauth.c Tom Green Mon Jan 31 10:42:58 1994
 * dqs_do_reauth() based on code written by Eric Brunson
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: dqs_reauth.c,v $
 * Revision 1.3  1998/10/13 15:08:48  green
 * Solaris 2.6 support - hopefully, as I don't have access to one...
 *
 * Revision 1.2  1998/10/13 14:23:12  green
 * Patching Solaris defines - shooting in the dark here as I don't have access to
 * a Solaris 2.5 box
 *
 * Revision 1.1.1.1  1998/08/18 14:39:12  green
 * DQS 3.2.0.5 WIP Import
 *
 * Revision 1.1.1.1  1997/04/10 15:10:33  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.10  1996/11/20 23:04:07  nrl
 * Several fixes submitted by or as a result of investigations by
 * Ron Lee, Bodo Bechenback, Guntram Wolski and Frank Dwyyer.
 *
 * Revision 3.9  1996/06/27  01:55:57  nrl
 * changes to accomodate osf gcc
 *
 * Revision 3.8  1996/03/22  04:21:00  nrl
 * Added error cataloguing number to all routines
 *
 * Revision 3.7  1996/02/07  13:08:13  nrl
 * Added "process leader" and TMP_FILES link capability
 *
 * Revision 3.6  1995/06/21  17:14:40  nrl
 * fixed syntax error in endif statement
 *
 * Revision 3.5  1995/05/29  18:08:54  nrl
 * More solaris stuff GAGGHH had to differentiate more cases of
 * solaris2.3 and solaris2.4 stuff
 *
 * Revision 3.4  1995/05/28  16:44:40  nrl
 * Fixes for solaris2.3 and solaris 2.4 and mailer default recipients
 *
 * Revision 3.3  1994/06/23  20:32:23  green
 * more Solaris fun
 *
 * Revision 3.2  1994/05/31  01:38:51  green
 * disallowed "-passwd" and "-Passwd" if AFS support not compiled in
 *
 * Revision 3.1  1994/05/31  00:52:40  green
 * added dsh.c dshd.c to Makefile.proto
 *
 * added MAXNAMELEN and NCARGS to def.h
 *
 * type casting in dqs_reauth.c, dqs_sec.c, dqs_setup.c to hush gcc
 * warnings
 *
 * added jmp_buf to globals.h, changed Revision number in globals.h
 *
 * added dsh and dshd tp prognames.h
 *
 * Revision 3.0  1994/03/07  04:14:20  green
 * 3.0 freeze
 *
 * Revision 1.6  1994/02/24  01:10:05  green
 * added default compile flags in Makefile.proto
 *
 * modified GETPGRP() and SETPGRP() in def.h for IRIX 5.1.1.1 support
 *
 * changed "st_mtime" to "st_m_time" in dqs_reauth.cand dqs_sec.c
 * for IRIX 5.1.1.1 support
 *
 * Revision 1.5  1994/02/18  18:59:07  green
 * added a sanity check on fdopen() in dqs_do_reauth()
 *
 * Revision 1.4  1994/02/17  14:49:05  green
 * added MAX_KLOG_TIME to def.h
 *
 * added some strategic dqs_set_coresize_2_0() as CYAs
 *
 * nuked some dqs_set_coresize_back_normal()
 *
 * dinked with ALRM handlers for "robustness"
 *
 * NOTE: HPUX does not support core limit size --- sad...
 *
 * Revision 1.3  1994/02/17  14:15:01  green
 * yanked the sleep out of dqs_reauth_job() and placed in qmaster,
 * dqs_execd and dqs_exec_job() such that the sleep only occurs at
 * startup.  This minimizes "re-authing" overhead.
 *
 * The AFS reauthing will have to be rewritten anyway since AFS
 * behaves differently on different platforms.(eg: requires reauthing
 * process to be of the same pgroup on "non-AIX" platforms. (UGH! a
 * sheepherder process being required...)
 *
 * Revision 1.2  1994/02/10  20:58:44  green
 * moved "LOG_FILE" and "ERR_FILE" out of def.h to dqs.h
 *
 * fixed "-Passwd passwd_file" option
 *
 * Revision 1.1.1.1  1994/02/01  17:57:45  green
 * DQS 3.0 ALPHA
 *
 *--------------------------------------------------*/


#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"

/**********************************************************************/
int dqs_reauth(job)
     dqs_job_type *job;
     
{
  
  int             status;
  u_long32        now;
  static u_long32 last=0;
  dqs_list_type   *lp;
  
  DENTER((DQS_EVENT,"dqs_reauth"));
  
  if (!AFS)
    {
      DEXIT;
      return(0);
    }
  
  now=dqs_get_gmt();
  
  if (now<=job->reauth_gmt)
    {
      DEXIT;
      return(0);
    }
  
  if ((job->Passwd)||(job->passwd_list))
    {
      dqs_do_reauth(job);
      if (job->reauth_time)
	job->reauth_gmt=now+job->reauth_time;
      else
	job->reauth_gmt=now+conf.reauth_time;
      DEXIT;
      return(1);
    }
  
  DEXIT;
  return(0);
  
}

/***********************************************************************************************/
void dqs_do_reauth(job)
     dqs_job_type *job;
     
{
  
  int           pid;
  int           pid2;
  int           exit_status;
  int           fd;
  int           pipefds[2];
  string        key;
  string        exec_str;
  FILE          *fp;
  struct rusage rusage;
  dqs_list_type *lp;
  
#if (SVR3) /* DAMN this is irratating */
  union wait status;
#else
  int status;
#endif
  
  
  DENTER((DQS_EVENT,"dqs_do_reauth"));
  ERROR((DQS_EVENT,"DQS_ERROR_0389 =======REAUTHING %s===========",job->dqs_job_name));
  alarm(0);
  
  if (fork())
    {
      DEXIT;
      return;
    }
  
  alarm(0);
  SETPGRP;
  dqs_set_coresize_2_0();
  
  dqs_set_uid_gid(job);
  
  if (job->Passwd)
    {
      job->passwd_list=dqs_read_in_passwds(job->Passwd);
      if (!job->passwd_list)
	{
	  CRITICAL((DQS_EVENT,"DQS_ERROR_0390 error: unable to reauth - invalid Passwd file \"%s\" in job %s",
		    job->Passwd,job->dqs_job_name));
	  DEXITE;
	  exit(-1);
	}
    }
  
  dqs_close_fds();
  
  lp=job->passwd_list;
  while (lp)
    {
      if (pipe(pipefds) < 0) 
	{
	  CRITICAL((DQS_EVENT,"DQS_ERROR_0391 error: pipe() failed"));
	  DEXITE;
	  exit(-1);
	}
      
      if ((pid = fork()) < 0) 
	{
	  CRITICAL((DQS_EVENT,"DQS_ERROR_0392 error: fork() failed"));
	  DEXITE;
	  exit(-1);
	}
      
      dqs_set_coresize_2_0();
      
      if (!pid) 
	{
	  int duped;
	  
	  if ((duped = dup2(pipefds[0], 0)) < 0) 
	    {
	      CRITICAL((DQS_EVENT,"DQS_ERROR_0393 error: dup() failed"));
	      exit(-1);
	    }
	  
	  close(pipefds[1]);
	  
	  execl(conf.klog,"klog","-principal",lp->str1,"-cell",lp->str0, "-pipe", 0);
	  CRITICAL((DQS_EVENT,"DQS_ERROR_0394 error: JID %d \"%s klog -principal %s -cell %s -pipe\" execl() failed",
		    job->job_number,conf.klog,lp->str1,lp->str0));
	  DEXITE;
	  exit(-1);
	}
      
      close(pipefds[0]);
      fp = fdopen(pipefds[1], "w");
      if (!fp)
	{
	  CRITICAL((DQS_EVENT,"DQS_ERROR_0395 error: JID %d fdopen() in dqs_do_reauth() failed",
		    job->job_number));
	  DEXITE;
	  exit(-1);
	}
      dqs_decrypt_token(lp->buf);
      fprintf(fp,"%s\n",lp->buf);
      fclose(fp);
      dqs_encrypt_token(lp->buf);
      
      dqs_setup_sig_handlers();
      while (TRUE)
	{
	  alarm(MAX_KLOG_TIME); /* max time to allow for klog */
	  sigprocmask(SIG_SETMASK,&io_mask,&omask);
	  SFD=9999;
	  sigaction(SIGALRM,&sigalrm_vec,&sigalrm_ovec);
	  
#if (defined(_UNICOS) || defined(__hpux) || defined(solaris) || defined(SOLARIS23_UP) )
          pid2=waitpid(-1,&status,0);
#else
          pid2=wait3(&status,0,(struct rusage *) &rusage);
#endif          
	  
	  alarm(0);
	  if (pid2==0) 
	    { /* how could this happen? */
	      kill(pid,SIGKILL);
	      CRITICAL((DQS_EVENT,"DQS_ERROR_0396 error: JID %d \"%s klog -principal %s -cell %s -pipe\" failed?",
			job->job_number,conf.klog,lp->str1,lp->str0));
	      continue;
	    }
	  
	  if (pid2==-1) 
	    { /* alarm must have went off */
	      kill(pid,SIGKILL);
	      CRITICAL((DQS_EVENT,"DQS_ERROR_0397 error: JID %d \"%s klog -principal %s -cell %s -pipe\" timed out",
			job->job_number,conf.klog,lp->str1,lp->str0));
	      exit_status= -1;
	      continue;
	    }
	  
	  if (WIFSTOPPED(status)) 
	    { /* how could this happen? */
	      kill(pid,SIGKILL); 
	      CRITICAL((DQS_EVENT,"DQS_ERROR_0398 error: JID %d \"%s klog -principal %s -cell %s -pipe\" wifstopped",
			job->job_number,conf.klog,lp->str1,lp->str0));
	      continue;
	    }
#if (SVR3)
	  exit_status=status.w_retcode;
#else
	  exit_status=status;
#endif
	  if (exit_status)
	    {
	      CRITICAL((DQS_EVENT,"DQS_ERROR_0399 error: JID %d \"%s klog -principal %s -cell %s -pipe\" returned %d",
			job->job_number,conf.klog,lp->str1,lp->str0,exit_status));
	      break;
	    }
	  else
	    {
	      INFO((DQS_EVENT,"DQS_ERROR_0400 JID %d \"%s klog -principal %s -cell %s -pipe\" returned %d",
		    job->job_number,conf.klog,lp->str1,lp->str0,exit_status));
	      break;
	    }
	}
      
      lp=lp->next;
    }
  
  DEXIT;
  exit(0);
  
}

/***********************************************************************************************/
dqs_list_type *dqs_get_pass()
     
{
  
  int    i;
  long code;
  string str;
  string prompt_str;
  char *cp;
  int status;
  dqs_list_type *lp=NULL;
  dqs_list_type listel;
  
  DENTER((DQS_EVENT,"dqs_get_pass"));
  
  if (!AFS)
    {
      ERROR((DQS_EVENT,"DQS_ERROR_0401 AFS support not compiled in"));
      DEXITE;
      exit(-1);
    }
  
  dqs_set_coresize_2_0(); /* CYA! */
  code=TRUE;
  while (code)
    {
      bzero((char *)&listel,sizeof(listel));
      listel.str2=dqs_malloc(TOKEN_SIZE);
      listel.buf=dqs_malloc(TOKEN_SIZE);
      listel.bufsize=TOKEN_SIZE;
      
      bzero((char *)str,sizeof(str));
      printf("Enter Cell Name [%s] - ",conf.default_cell);
      cp=fgets(str,sizeof(str),stdin);
      if (!cp)
	break;
      if (str[0]=='\n')
	listel.str0=dqs_string_insert(NULL,conf.default_cell);
      else
	{
	  i=strlen(str);
	  str[--i]='\0';
	  listel.str0=dqs_string_insert(NULL,str);
	}
      sprintf(prompt_str,"Enter principle name for Cell \"%s\" [%s] - ",
	      listel.str0,me.user_name);
      
      printf("%s",prompt_str);
      cp=fgets(str,sizeof(str),stdin);
      if (!cp)
	break;
      if (str[0]=='\n')
	listel.str1=dqs_string_insert(NULL,me.user_name);
      else
	{
	  i=strlen(str);
	  str[--i]='\0';
	  listel.str1=dqs_string_insert(NULL,str);
	}
      sprintf(prompt_str,"Enter passwd for Principle \"%s\" Cell \"%s\" - ",
	      listel.str1,listel.str0);
      cp=(char *)getpass(prompt_str);
#ifdef AFSSYS          
      code=klogvalid(me.user_name,cp);
#else
      code= FALSE;
#endif          
      sprintf(listel.buf,"%s",cp);
      lp=dqs_insert(DQS_STR0,TAIL,lp,&listel);
      dqs_encrypt_token(listel.buf);
    }
  printf("\n");
  dqs_set_coresize_back_normal();
  DEXIT;
  return(lp);
  
}

/***********************************************************************************************/
void dqs_set_coresize_2_0()
     
{
  
  struct rlimit rlp;
  
  DENTER((DQS_EVENT,"dqs_set_coresize_2_0"));
  
#ifndef  __hpux
  /* HPUX - what an operating sysytem! */     
  rlp.rlim_cur = 0;
  rlp.rlim_max = 0;
  setrlimit(RLIMIT_CORE,&rlp);
#endif     
  
  DEXIT;
  return;
  
}

/***********************************************************************************************/
void dqs_set_coresize_back_normal()
{
  
  struct rlimit rlp;
  
  DENTER((DQS_EVENT,"dqs_set_coresize_back_normal"));
  
#ifndef  __hpux
  rlp.rlim_cur = 0x7fffffff;
  rlp.rlim_max = 0x7fffffff;
  setrlimit(RLIMIT_CORE,&rlp);
#endif
  
  DEXIT;
  return;
  
}

/***********************************************************************************************/
int dqs_get_key(key)
     char *key;
{
  
  FILE             *fp;
  
  DENTER((DQS_EVENT,"dqs_get_key"));
  
  if (!key)
    {
      CRITICAL((DQS_EVENT,"DQS_ERROR_0402 error: NULL key ptr passed in"));
      DEXITE;
      return(-1);
    }
  
  fp=fopen(KEY_FILE,"r");
  if (fp==NULL)
    {
      ERROR((DQS_EVENT,"DQS_ERROR_0403 error: opening \"%s\"",KEY_FILE));
      DEXITE;
      return(-1);
    }
  
  if (fscanf(fp,"%[^\n]",key)!=1)
    {
      fclose(fp);
      ERROR((DQS_EVENT,"DQS_ERROR_0404 error: reading \"%s\"",KEY_FILE));
      DEXITE;
      return(-1);
    }
  
  fclose(fp);
  
  DEXIT;
  return(0);
  
}


/***********************************************************************************************/
void dqs_encrypt_token(token)
     char *token;
     
{
  
  int      i;
  char     *cp;
  string   key;
  unsigned char kptr[MAX_KEY_SIZE];
  
  DENTER((DQS_EVENT,"dqs_encrypt_token"));
  
  dqs_set_coresize_2_0(); /* CYA! */
  bzero((char *)key,sizeof(key));
  bzero((char *)kptr,MAX_KEY_SIZE);
  
  if (dqs_get_key(key))
    {
      CRITICAL((DQS_EVENT,"DQS_ERROR_0405 error: unable to reauth - invalid key file \"%s\"",
		KEY_FILE));
      DEXITE;
      exit(-1);
    }
  makekey(key,kptr);
  deskey(kptr, 0);            /* load internal registers with kptr, encrypt */
  cp=token;
  for (i=0;i<TOKEN_SIZE/8;i++)
    {
      des( ((unsigned char*)cp), ((unsigned char*)cp) );
      cp+=8;
    }
  
  bzero((char *)key,MAX_KEY_SIZE);
  
  DEXIT;
}

/***********************************************************************************************/
void dqs_decrypt_token(token)
     char *token;
     
{
  
  int      i;
  char     *cp;
  string   key;
  unsigned char kptr[MAX_KEY_SIZE];
  
  DENTER((DQS_EVENT,"dqs_decrypt_token"));
  
  dqs_set_coresize_2_0(); /* CYA! */
  bzero((char *)key,sizeof(key));
  bzero((char *)kptr,100);
  
  if (dqs_get_key(key))
    {
      CRITICAL((DQS_EVENT,"DQS_ERROR_0406 error: unable to reauth - invalid key file \"%s\"",
		KEY_FILE));
      DEXITE;
      exit(-1);
    }
  makekey(key,kptr);
  deskey (kptr, 1);            /* load internal registers with kptr, decrypt */
  cp=token;
  for (i=0;i<TOKEN_SIZE/8;i++)
    {
      des( ((unsigned char*)cp), ((unsigned char*)cp) );
      cp+=8;
    }
  
  bzero((char *)key,MAX_KEY_SIZE);
  
  DEXIT;
  return;
  
}

/***********************************************************************************************/
dqs_list_type *dqs_read_in_passwds(fname)
     char *fname;
     
{
  
  int              i;
  int              line=0;
  char             *s0;
  FILE             *fp;
  string           str;
  dqs_list_type    *head=NULL;
  dqs_list_type    el;
  
  
  DENTER((DQS_EVENT,"dqs_read_in_passwds"));
  if (!fname)
    {
      CRITICAL((DQS_EVENT,"DQS_ERROR_0407 error: NULL file name passed in"));
      DEXITE;
      return(NULL);
    }
  
  fp=fopen(fname,"r");
  if (fp==NULL)
    {
      ERROR((DQS_EVENT,"DQS_ERROR_0408 error: opening %s",fname));
      DEXITE;
      return(NULL);
    }
  
  dqs_set_coresize_2_0(); /* CYA! */
  
  while (1)
    {
      line++;
      i=fscanf(fp,"%[^\n]",str);
      if ((i<1)||(i==EOF))
	break;
      
      bzero((char *)&el,sizeof(el));
      
      s0=dqs_strtok(str," ");
      if (!s0)
	{
	  ERROR((DQS_EVENT,"DQS_ERROR_0409 error: invalid entry at line %d in %s",
		 line,fname));
	  break;
	}
      el.str0=dqs_string_insert(NULL,s0);
      
      s0=dqs_strtok(NULL," ");
      if (!s0)
	{
	  ERROR((DQS_EVENT,"DQS_ERROR_0410 error: invalid entry at line %d in %s",
		 line,fname));
	  break;
	}
      el.str1=dqs_string_insert(NULL,s0);
      
      s0=dqs_strtok(NULL," ");
      if (!s0)
	{
	  ERROR((DQS_EVENT,"DQS_ERROR_0411 error: invalid entry at line %d in %s",
		 line,fname));
	  break;
	}
      el.buf=dqs_malloc(TOKEN_SIZE);
      el.bufsize=TOKEN_SIZE;
      sprintf(el.buf,"%s",s0);
      
      dqs_encrypt_token(el.buf);
      
      bzero((char *)s0,strlen(s0));
      
      head=dqs_insert(DQS_STR0,TAIL,head,&el);
      i=fscanf(fp,"\n",str);
      if ((i<0)||(i==EOF))
	break;
      
    }
  
  fclose(fp);
  
  DEXIT;
  return(head);
  
}

/***********************************************************************************************/
void dqs_get_passwd_info(job)
     dqs_job_type *job;
     
{
  
  DENTER((DQS_EVENT,"dqs_get_passwd_info"));
  
  if (!job->reauth_time)
    job->reauth_time=conf.reauth_time;
  if (!job->dqs_job_name)
    job->dqs_job_name=dqs_string_insert(NULL,me.dqs_formal_prog_name);
  if (AFS)
    if (job->passwd) 
      job->passwd_list=dqs_get_pass();
  
  DEXIT;
  return;
  
}
