static char dqs_log_rcsid[]="$Id: dqs_log.c,v 1.1.1.1 1998/08/18 14:39:12 green Exp $";

/*----------------------------------------------------
 * dqs_log.c Tom Green Mon Jan 31 10:42:49 1994
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: dqs_log.c,v $
 * Revision 1.1.1.1  1998/08/18 14:39:12  green
 * DQS 3.2.0.5 WIP Import
 *
 * Revision 1.1.1.1  1997/04/10 15:10:33  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.15  1997/03/25 18:13:46  nrl
 * removed redundant definitions and some typing garbage
 *
 * Revision 3.14  1997/03/19 21:14:07  nrl
 * Changed log_file permissions from 666 to S_IWUSR | S_IRUSR));
 *
 * Revision 3.13  1996/07/16  17:53:32  nrl
 * catastrophic bug left lying around wehen we removed file
 * i/o for debug output. a close(fd) wasa closing a non-exsitent
 * file descriptor and raising hell with the socket interface.
 *
 * Revision 3.12  1996/06/24  15:02:01  nrl
 * fixed DEBUG output
 *
 * Revision 3.10  1996/03/21  17:06:50  nrl
 * added fortran and "c" syntax to resource requests
 *
 * Revision 3.9  1996/03/12  17:12:14  nrl
 * removed aborts and replaced with an error messaging scheme
 * to send email to the dqs adminsitrator and wait for
 * actions by that administrator
 *
 * Revision 3.8  1996/03/11  17:23:38  nrl
 * changed debug output to a file instead of stderr, now we make
 * only one system call to write a line in order to clean up the
 * output when multiple processes are accessing the file.
 *
 * Revision 3.7  1996/01/19  20:58:48  nrl
 * merged SCRI code and new job and queue structure changes
 *
 * Revision 3.6  1996/01/10  13:52:38  nrl
 * Base for 3.1.3
 *
 * Revision 3.5  1996/01/02  12:53:26  nrl
 * Changed call to dqs_get_gmt to direct call for gettimeofday to
 * avoid infinite recursion if DEBUG_EXT is selected.
 *
 * Revision 3.4  1996/01/01  02:28:37  nrl
 * Added timestamp to all logging
 *
 * Revision 3.3  1995/05/26  19:07:38  nrl
 * Cleaned up signal handling and the notify option with the
 * help of Ron Lee.
 *
 * Revision 3.2  1994/06/23  20:01:40  green
 * Solaris porting mods...
 *
 * Revision 3.1  1994/06/15  15:29:23  green
 * support for using DQS trusted host list for dshd
 *
 * 	passing of Host_head -n dqs_c_dqs_execd.c
 * 	time stamp Host_head on deletion in dqs_c_qconf.c
 * 	ck trusted host list in dqs_dshd.c
 * 	grab Host_head at startup in dqs_execd.c
 * 	rebuild Host_head/Host_hash in dqs_execd_rebuild_host_hash.c
 * 	dqs_free_hash in dqs_hash.c
 * 	grab new Host_head in dqs_load_avg.c
 * 	error log/printing in dsh.c
 *
 * Bug in my syslog code(or certain vendors required nullifying use
 * of syslogd until I can track it down...
 *
 * Revision 3.0  1994/03/07  04:14:02  green
 * 3.0 freeze
 *
 * Revision 1.1.1.1  1994/02/01  17:57:43  green
 * DQS 3.0 ALPHA
 *
 *--------------------------------------------------*/


#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"

char dbuffer[4096];
int dbl;


/************************************************************************/
void dqs_indent()
     /*
       dqs_indent()
     */
     
{
  
  int i; 
  
  if (DEBUG_INDENT > 80)
    DEBUG_INDENT=80;
  
  for (i=0;i<DEBUG_INDENT;i++)
    strcat(dbuffer," ");
  return;
}

/************************************************************************/
void dqs_log(log_level,mesg,file__,func__,line__)
     int log_level;
     char *mesg;
     char *file__;
     char *func__;
     int  line__;
     /*
       DO NOT USE DQS_ASSERT OR LOGGING MACROS IN THIS ROUTINE!
       THIS MODULE MUST ACT STAND-ALONE!
     */
     
     
{
  struct stat buf;
  int fd;
  string str;
  u_long timenow;
  string timestr;
  string tempstr;
  string tempmsg;
  string temptype;
  struct timeval  now;
  struct timezone tzp;
  char *strp;
  
  gettimeofday(&now, &tzp);
  timenow=(u_long)now.tv_sec;
  
  sprintf(timestr,"time=%ld  ",timenow);
  
  bzero(str,sizeof(str));
  bzero(tempstr, sizeof(tempstr) );
  strcpy(temptype,"DQS_INFO");
  if(log_level==LOG_CRIT) strcpy(temptype,"DQS_CRITICAL");
  if(log_level==LOG_ERR) strcpy(temptype,"DQS_ERROR");
  if(log_level==LOG_WARNING) strcpy(temptype,"DQS_WARNING");
  if(log_level==LOG_NOTICE) strcpy(temptype,"DQS_NOTICE");
  
  
  if (!mesg)
    sprintf(tempstr,"%s    \t%s %d ",temptype,file__,line__);
  else
    strp= strstr(mesg,"DQS_ERROR");
  strcpy(tempmsg,temptype);
  if(strp){
    strp= strp+9;
    strcat(tempmsg,strp);
  }
  else{
    strcpy(tempmsg,mesg);
  }
  sprintf(tempstr,"%s   \t%s %d ",tempmsg,file__,line__);
  if (func__[0])
    {
      strcat(str,func__);
      strcat(str,"() ");
    }
  
  strcpy(str, tempstr);
  strcat(str,me.qualified_prog_name);
  strcat(str," ");
  strcat(str,me.qualified_hostname);
  
  strcpy(tempstr, timestr);
  strcat(tempstr, str);
  strcat(tempstr,"\n");
  strcat(str,"\n");
  
  if (!me.daemonized)
    {
      if ((log_level==LOG_EXTDEBUG)&&(DEBUG_LOGLEVEL==LOG_EXTDEBUG))
	{
	  sprintf(dbuffer,"%6d  %s ",DEBUG_TRACEID, timestr);
	  dqs_indent();
	  strcat(dbuffer,str);
	  fprintf(stderr,"%s",dbuffer);
	  DEBUG_TRACEID++;
	}
      else if ((log_level==LOG_DEBUG)&&(DEBUG_LOGLEVEL==LOG_DEBUG))
	{
	  sprintf(dbuffer,"%6d %s ",DEBUG_TRACEID, timestr);
	  dqs_indent();
	  strcat(dbuffer,str);
	  fprintf(stderr,"%s",dbuffer);
	  
	  DEBUG_TRACEID++;	       
	}
      else if (log_level<=conf.loglevel)
	{
	  fprintf(stderr,"%s",tempstr);
	  fflush(stderr);
	}
    }     
  dqs_do_log(log_level,tempstr);
  
  return;
  
}

/************************************************************************/
void dqs_do_log(log_level,err_str)
     int  log_level;
     char *err_str;
     
{
  
  int         fd;
  char        *log_file;
  struct stat buf;
  
  if (log_level>conf.loglevel)
    return;
  
  if (log_level==LOG_INFO)
    log_file=LOG_FILE;
  else
    log_file=ERR_FILE;
  
  /*LOG_CRIT LOG_ERR LOG_WARNING LOG_NOTICE LOG_INFO*/
  
  if ((conf.logfacility==LOG_VIA_SYSLOG)||(conf.logfacility==LOG_VIA_COMBO))
    {
      dqs_syslog(log_level,err_str);
    }
  
  if ((conf.logfacility==LOG_VIA_FILE)||(conf.logfacility==LOG_VIA_COMBO))
    {
      if (stat(log_file,&buf))
	close(creat(log_file,S_IWUSR | S_IRUSR));
      if ((fd=open(log_file,(O_WRONLY | O_APPEND))) >=0)
	{
	  (void) write(fd,err_str,strlen(err_str));
	  close(fd);
	}
    }
  
  return;
  
}


/************************************************************************/
void dqs_syslog(log_level,err_str)
     int  log_level;
     char *err_str;
     
{
  
  /*     syslog(log_level,"%s",err_str); */
  return;
  
}
