static char dqs_errno_rcsid[]="$Id: dqs_errno.h,v 1.1.1.1 1998/08/18 14:39:11 green Exp $";

/*----------------------------------------------------
 * dqs_errno.h Tom Green Mon Jan 31 10:44:28 1994
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: dqs_errno.h,v $
 * Revision 1.1.1.1  1998/08/18 14:39:11  green
 * DQS 3.2.0.5 WIP Import
 *
 * Revision 1.1.1.1  1997/04/10 15:10:32  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.1  1996/11/20 23:03:36  nrl
 * Several fixes submitted by or as a result of investigations by
 * Ron Lee, Bodo Bechenback, Guntram Wolski and Frank Dwyyer.
 *
 * Revision 3.0  1994/03/07  04:13:43  green
 * 3.0 freeze
 *
 * Revision 1.1.1.1  1994/02/01  17:57:40  green
 * DQS 3.0 ALPHA
 *
 *--------------------------------------------------*/

 
#define	DQS_EPERM		1	/* Operation not permitted		*/
#define	DQS_ENOENT		2	/* No such file or directory		*/
#define	DQS_ESRCH		3	/* No such process			*/
#define	DQS_EINTR		4	/* interrupted system call		*/
#define	DQS_EIO	        	5	/* I/O error				*/
#define	DQS_ENXIO		6	/* No such device or address		*/
#define	DQS_E2BIG		7	/* Arg list too long			*/
#define	DQS_ENOEXEC		8	/* Exec format error			*/
#define	DQS_EBADF		9	/* Bad file descriptor			*/
#define	DQS_ECHILD		10	/* No child processes			*/
#define	DQS_EAGAIN		11	/* Resource temporarily unavailable	*/
#define	DQS_ENOMEM		12	/* Not enough space			*/
#define	DQS_EACCES		13	/* Permission denied			*/
#define	DQS_EFAULT		14	/* Bad address				*/
#define	DQS_ENOTBLK		15	/* Block device required		*/
#define	DQS_EBUSY		16	/* Resource busy			*/
#define	DQS_EEXIST		17	/* File exists				*/
#define	DQS_EXDEV		18	/* Improper link			*/
#define	DQS_ENODEV		19	/* No such device			*/
#define	DQS_ENOTDIR		20	/* Not a directory			*/
#define	DQS_EISDIR		21	/* Is a directory			*/
#define	DQS_EINVAL		22	/* Invalid argument			*/
#define	DQS_ENFILE		23	/* Too many open files in system	*/
#define	DQS_EMFILE		24	/* Too many open files			*/
#define	DQS_ENOTTY		25	/* Inappropriate I/O control operation	*/
#define	DQS_ETXTBSY		26	/* Text file busy			*/
#define	DQS_EFBIG		27	/* File too large			*/
#define	DQS_ENOSPC		28	/* No space left on device		*/
#define	DQS_ESPIPE		29	/* Invalid seek				*/
#define	DQS_EROFS		30	/* Read only file system		*/
#define	DQS_EMLINK		31	/* Too many links			*/
#define	DQS_EPIPE		32	/* Broken pipe				*/
#define	DQS_EDOM		33	/* Domain error within math function	*/
#define	DQS_ERANGE		34	/* Result too large			*/
#define	DQS_ENOMSG		35	/* No message of desired type		*/
#define	DQS_EIDRM		36	/* Identifier removed			*/
#define	DQS_ECHRNG		37	/* Channel number out of range		*/
#define	DQS_EL2NSYNC    	38	/* Level 2 not synchronized		*/
#define	DQS_EL3HLT		39	/* Level 3 halted			*/
#define	DQS_EL3RST		40	/* Level 3 reset			*/
#define	DQS_ELNRNG		41	/* Link number out of range		*/
#define	DQS_EUNATCH     	42	/* Protocol driver not attached		*/
#define	DQS_ENOCSI		43	/* No CSI structure available		*/
#define	DQS_EL2HLT		44	/* Level 2 halted			*/
#define DQS_EDEADLK     	45	/* Resource deadlock avoided		*/
#define DQS_ENOTREADY		46	/* Device not ready			*/
#define DQS_EWRPROTECT		47	/* Write-protected media 		*/
#define DQS_EFORMAT		48	/* Unformatted media 			*/
#define DQS_ENOLCK		49	/* No locks available 			*/
#define DQS_ENOCONNECT  	50      /* no connection                	*/
#define DQS_ESTALE      	52      /* no filesystem                	*/
#define DQS_EWOULDBLOCK		54	/* Operation would block       		*/
#define DQS_EINPROGRESS 	55      /* Operation now in progress 		*/
#define DQS_EALREADY    	56      /* Operation already in progress 	*/
#define DQS_ENOTSOCK        	57      /* Socket operation on non-socket 	*/
#define DQS_EDESTADDRREQ    	58      /* Destination address required 	*/
#define DQS_EMSGSIZE        	59      /* Message too long 			*/
#define DQS_EPROTOTYPE      	60      /* Protocol wrong type for socket 	*/
#define DQS_ENOPROTOOPT     	61      /* Protocol not available 		*/
#define DQS_EPROTONOSUPPORT 	62      /* Protocol not supported 		*/
#define DQS_ESOCKTNOSUPPORT 	63      /* Socket type not supported 		*/
#define DQS_EOPNOTSUPP      	64      /* Operation not supported on socket 	*/
#define DQS_EPFNOSUPPORT    	65      /* Protocol family not supported 	*/
#define DQS_EAFNOSUPPORT    	66      /* Addr fam not supported by proto fam  */
#define DQS_EADDRINUSE      	67      /* Address already in use 		*/
#define DQS_EADDRNOTAVAIL   	68      /* Can't assign requested address 	*/
#define DQS_ENETDOWN        	69      /* Network is down 			*/
#define DQS_ENETUNREACH     	70      /* Network is unreachable 		*/
#define DQS_ENETRESET       	71      /* Network dropped connection on reset 	*/
#define DQS_ECONNABORTED    	72      /* Software caused connection abort 	*/
#define DQS_ECONNRESET      	73      /* Connection reset by peer 		*/
#define DQS_ENOBUFS         	74      /* No buffer space available 		*/
#define DQS_EISCONN         	75      /* Socket is already connected 		*/
#define DQS_ENOTCONN        	76      /* Socket is not connected 		*/
#define DQS_ESHUTDOWN       	77      /* Can't send after socket shutdown 	*/
#define DQS_ETIMEDOUT       	78      /* Connection timed out 		*/
#define DQS_ECONNREFUSED    	79      /* Connection refused 			*/
#define DQS_EHOSTDOWN       	80      /* Host is down 			*/
#define DQS_EHOSTUNREACH    	81      /* No route to host 			*/
#define DQS_ERESTART	    	82	/* restart the system call 		*/
#define DQS_EPROCLIM	    	83	/* Too many processes 			*/
#define	DQS_EUSERS	    	84	/* Too many users 			*/
#define	DQS_ELOOP           	85	/* Too many levels of symbolic links    */
#define	DQS_ENAMETOOLONG    	86	/* File name too long			*/
#define DQS_ENOTEMPTY	    	87      /* Directory not empty 			*/
#define DQS_EDQUOT          	88	/* Disc quota exceeded 			*/
#define DQS_EREMOTE	    	89	/* Item is not local to host 		*/
#define DQS_ESAD		90	/* security authentication denied 	*/
#define DQS_ENOTRUST		91	/* not a trusted program 		*/ 
#define DQS_ETOOMANYREFS        92	/* Too many references: can't splice 	*/
#define DQS_EILSEQ		93      /* Invalid wide character 		*/
#define DQS_ECANCELED 	        94      /* asynchronous i/o cancelled 		*/
#define	DQS_EBADMSG		95	/* wrong message type at stream head 	*/
#define	DQS_EPROTO		96	/* STREAMS protocol error 		*/
#define	DQS_ENODATA		97	/* no message ready at stream head 	*/
#define	DQS_ENOSTR		98	/* fd is not a stream 			*/


