/****************************************************************************
**
** Copyright (C) 2004-2006 Frank Hemer <frank@hemer.org>,
**                         Tilo Riemer <riemer@crossvc.com>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** CrossVC is available under two different licenses:
**
** If CrossVC is linked against the GPLed version of Qt 
** CrossVC is released under the terms of GPL also.
**
** If CrossVC is linked against a nonGPLed version of Qt 
** CrossVC is released under the terms of the 
** CrossVC License for non-Unix platforms (CLNU)
**
**
** CrossVC License for non-Unix platforms (CLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than CrossVC.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** CrossVC License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation, version 2 of the License.
** This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License version 2 for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#include "Status.h"

#include <qapplication.h>
#include <assert.h>

#include "globals.h"

Status * Status::statusFile(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench)
{
   return setup(whatsThisIconSet, parent, workBench, false);
}

Status * Status::statusDir(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench)
{
   return setup(whatsThisIconSet, parent, workBench, true);
}

Status * Status::statusAuto(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench, DirBase * dir, QObject * receiver)
{
   return setup(whatsThisIconSet, parent, workBench, dir, true, receiver);
}

Status * Status::setup(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench, bool isDir) {
   DirBase * dir = workBench->selectedItem();
   if (!dir) return NULL;
   else return setup(whatsThisIconSet, parent, workBench, dir, isDir);
}

Status * Status::setup(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench, DirBase * dir, bool isDir, QObject * receiver) {

   if (dir->getType() == DirBase::Cvs) {
      Status * p = new Status(whatsThisIconSet, parent, workBench, dir, isDir);
      if (receiver) connect(p, SIGNAL(done(bool)), receiver, SLOT(callDone(bool)));
      p->acceptCvs();
      return p;
   } else {
      qDebug("Status: Method not implemented");
   }
   return NULL;
}

Status::Status(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench, DirBase * dir, bool isDir)
   :  m_whatsThisIconSet(whatsThisIconSet),
      m_parent(parent),
      m_workBench(workBench),
      m_dir(dir),
      m_dlg(NULL),
      m_isDir(isDir)
{
   connect(this,SIGNAL(deleteObject(QObject *)),parent,SLOT(slot_deleteObject(QObject *)));
   connect(this,SIGNAL(checkTree(DirBase *)),parent,SLOT(slot_checkStatusOfTree(DirBase *)));
   connect(this,SIGNAL(checkInProgress(bool)),parent,SLOT(checkInProgress(bool)));
}

Status::~Status() {
   if (m_dlg) delete m_dlg;
   m_dlg = NULL;
}

void Status::acceptCvs() {

   assert(m_dir);

   int cmd = -1;
   QString files = "";
   QStringList filesList;
   QString command = "";
   if (!bRWPermission) command += "-r " + CvsOptions::cmprStr();
   command += " status";

   if (!m_isDir) {
      command += " -v";
      filesList = m_dir->getSelectedFiles();
      if (filesList.isEmpty()) {
         reject(false);
         return;
      }
      masqQuoteMarks(&filesList);
      files = masqWs(filesList.join("\" \""));
      cmd = CVS_STATUS_FILES_CMD;
   } else {
      cmd = CVS_STATUS_CMD;
   }

   QString dir = m_dir->fullName();
   QString topModule = m_dir->topControlledDir()->relativeName();

   callInteractive( topModule, dir, command,
	 files, cmd,
	 ExtApps::g_cvsRsh.path,  //additional options of cvsRsh not supported yet
	 NOROOT);
}

void Status::reject(bool result) {
   emit done(result);
   emit deleteObject(this);
}

void Status::cvsCallStarted() {
   QApplication::setOverrideCursor(Qt::waitCursor);
}

void Status::cvsCallFinished() {
   QApplication::restoreOverrideCursor();
}

void Status::afterCall(int cmd,CvsBuffer * buf,bool failed) {
   cvsCallFinished();
   if (failed) {
      reject(false);
      return;
   }
   assert(m_dir);
   switch( cmd) {
      case NOOP: {
	 break;
      }
      case CVS_STATUS_CMD: {
	 m_dir->parseCallResult( buf, cmd);
	 if (m_dir->isSelected()) {
	    emit checkInProgress(true);
	    m_dir->postCallCheck(DirBase::Controled);
	    emit checkInProgress(false);
	 }
	 break;
      }
      case CVS_STATUS_FILES_CMD: {
	 m_dir->parseCallResult( buf, cmd);
	 if (m_dir->isSelected()) {
	    emit checkInProgress(true);
	    m_dir->postCallCheck(DirBase::Controled);
	    emit checkInProgress(false);
	 }
	 break;
      }
      default: {
	 qDebug("Status::afterCall: Unknown cmd");
      }
   }
   reject(true);
}
