/****************************************************************************
**
** Copyright (C) 2001-2006 Frank Hemer <frank@hemer.org>,
**                         Tilo Riemer <riemer@crossvc.com>,
**                         Jose Hernandez <joseh@tesco.net>,
**                         Tom Mishima <tmishima@mail.at-m.or.jp>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** CrossVC is available under two different licenses:
**
** If CrossVC is linked against the GPLed version of Qt 
** CrossVC is released under the terms of GPL also.
**
** If CrossVC is linked against a nonGPLed version of Qt 
** CrossVC is released under the terms of the 
** CrossVC License for non-Unix platforms (CLNU)
**
**
** CrossVC License for non-Unix platforms (CLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than CrossVC.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** CrossVC License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation, version 2 of the License.
** This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License version 2 for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#ifndef LOGDIALOGIMPL_H_20010626
#define LOGDIALOGIMPL_H_20010626

#include "config.h"


#include <qlabel.h>
#include <qcombobox.h>
#include <qdir.h>
#include <qiconset.h>

#include "CvsBuffer.h"
#include "logtree.h"
#include "loglist.h"
#include "LogDialog.h"
#include "CommandInterface.h"
#include "GuardedDir.h"
#include "cvslistview.h"

class QTabWidget;


class TagInfo
{
 public:
   QString rev;
   QString tag;
   QString branch;
   QString branchpoint;
};


class LogDialogImpl : public LogDialog, CommandInterface
{ 
   Q_OBJECT

 signals:
   void editFile(QString);
   void checkInProgress(bool);
   void showWarning(const QString &,const QString &);

 public:
   LogDialogImpl(CvsDirListView *,
	 GuardedDir, const QIconSet &,
	 QWidget * = 0, const char* = 0,
	 WFlags = 0 );

   ~LogDialogImpl();


   void parseCvsLog(QString BaseDir, QString name, QString revision, CvsBuffer *pCvsBuffer);
   void afterCall(int, CvsBuffer*, bool);

 public slots:
   void enterWhatsThisMode();

 protected:
   bool eventFilter(QObject*,QEvent*);
   void cvsCallStarted();
   void cvsCallFinished();

 protected slots:
   void annotateClicked();
   void diffClicked();
   void mergeClicked();
   void diffConsoleClicked();
   void diffConsoleAClicked();
   void diffConsoleBClicked();
   void createPatchClicked();
   void displayFileRevision (LogTreeView::LogTreeItem *);
   void displayFileRevision (LogListView::LogListItem *);
   void revisionSelected(LogTreeView::LogTreeItem *,bool);
   void revisionSelected(LogListView::LogListItem *,bool);
   void diffAClicked();
   void diffBClicked();
   void keepSettingsToggled(bool);
   void showTagsToggled(bool);
   void showBranchesToggled(bool);

 private:
   /**
      Called from within constructors.
   */
   void init();

   void diff(QString,QString,QString,QString);
   void diffConsoleSandBox(const QString &rev, const QString &f);

   void setEnabled(bool state);
   void setButtonsAndSelectedPair(int,int);
   void runDisplayFileRevision(QString&,QString&);

   static bool s_keepSettings;
   static bool s_showTags;
   static bool s_showBranches;

   QString m_fileName;
   QString m_baseDir;
   QString m_fileRevision;
   QPtrList<TagInfo> tags;
   QString m_selectionA, m_selectionB, m_fileA, m_fileB, m_sandbox;
   CvsDirListView * m_workBench;
   GuardedDir m_workDir;
   int m_treeA, m_treeB;
   QString m_captionA, m_captionB;
   QString m_connectMethod;
   QString m_tmpDiffFileNameA;
   QString m_tmpDiffFileNameB;
   CvsBuffer *m_pCvsBuffer;
   bool m_showMergeInfo;
   
   QWidget* m_parent;
   QString m_topModule;
};

#endif // LOGDIALOGIMPL_H_20010626

