/****************************************************************************
**
** Copyright (C) 2002-2006 Frank Hemer <frank@hemer.org>,
**                         Tilo Riemer <riemer@crossvc.com>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** CrossVC is available under two different licenses:
**
** If CrossVC is linked against the GPLed version of Qt 
** CrossVC is released under the terms of GPL also.
**
** If CrossVC is linked against a nonGPLed version of Qt 
** CrossVC is released under the terms of the 
** CrossVC License for non-Unix platforms (CLNU)
**
**
** CrossVC License for non-Unix platforms (CLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than CrossVC.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** CrossVC License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation, version 2 of the License.
** This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License version 2 for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#ifndef IMPORTDIALOGIMPL_H_20010626
#define IMPORTDIALOGIMPL_H_20010626

#include "config.h"


#include <qlineedit.h>
#include <qtextedit.h>
#include <qdict.h>
#include <qiconset.h>

#include "globals.h"
#include "ImportDialog.h"
#include "CommandInterface.h"
#include "ModuleBrowserImpl.h"
#include "ImportPreview.h"
#include "ProgressDialog.h"

class ImportDialogImpl : public ImportDialog, CommandInterface
{ 
   Q_OBJECT

 signals:
   void showWarning(const QString&,const QString&);

 public:
   ImportDialogImpl( QString* defaultProfile,
	 QStringList* ProfileList,
	 QStringList* UserList,
	 QStringList* ServerList,
	 QStringList* RepositoryList,
	 QStringList* WorkdirList,
	 QStringList* vendor,
	 QStringList* release,
	 QString* comment,
	 const QIconSet &whatsThisIconSet,
	 QWidget* parent = 0,
	 const char* name = 0,
	 bool modal = FALSE,
	 WFlags fl = 0 );
   ~ImportDialogImpl();
   QSize sizeHint () const;
   void afterCall(int,CvsBuffer*,bool);
 
   QStringList getIgnoreWildcards();
   QStringList getBinaryWildcards();
   QString user();
   QString server();
   QString tagV();
   QString tagR();
   QString comment();
   QString localDir();
   QString module();
   QString repository();
   QString getCvsRsh();
   int getSshPreset();
   int mode();
   int rshMode();

 public slots:

   void profileActivated(const QString&);
   void extRshClicked();
   void intRshClicked();
   void accessActivated(const QString&);
   void browseDirClicked();
   void browseModulesClicked();
   void editIgnoreClicked();
   void editBinaryClicked();
   void previewClicked();
   void getAndSetModule();
   void insertModule(const QString &);
   void cancelPreviewScan();
   void reduceHeight();
   void enterWhatsThisMode();
   
   void accept();
   
 protected:
   void cvsCallStarted();
   void cvsCallFinished();
   
 private:
   
   int findlistIndex(QStringList *list, const QString item);
   void insertSortAndSelectFirst(QComboBox *,QStringList &);
   void setDefaultProfile(const QString&);
   void addToPreview( QString& path);
   void setEnabled(bool state);
   void resetSize();
   
   QWidget * m_parent;
   QString m_defBrowseModButtonName;
   QString m_defBrowseModButtonText;
   QString * m_defaultProfile;
   QStringList m_ProfileList;
   QStringList m_UserList;
   QStringList m_ServerList;
   QStringList m_RepositoryList;
   QDict<int> m_AccessDict;
   QStringList m_AccessList;
   QStringList m_SshPresetList;
   QStringList m_WorkdirList;
   QStringList m_Vendor;
   QStringList m_Release;
   QString m_Comment;

   QStringList m_ignoreList;
   QString m_ignoreString;
   QStringList m_binaryList;

   ModuleBrowserImpl* m_ModuleBrowser;
   QString m_TmpBrowseModulesRoot;

   ImportPreview* previewDlg;
   ProgressDialog* progressDlg;
   bool m_bScanInterrupted;

   bool m_running;
};

#endif // IMPORTDIALOGIMPL_H_20010626

