/*
 * @(#)$Id: tw.c,v 1.1 1994/04/21 14:57:45 shin Exp $
 */
#include	<stdio.h>
#include	"ccode.h"

/*
 * @(#)main: Turn the current TTY into an on-line code conversion mode
 *	among several Chinese coding schemes commonly used in Taiwan
 *	and the GB/HZ codes used in Mainland.
 */

main(argc, argv, envp)
int	argc;
char	**argv;
char	**envp;
{
	char sourcecode, targetcode;
	static char codeidx[] = CODE_STRING;
	int icode, ocode;

/* check command syntax */

	if (argc < 2 || argv[1][0] != '-' || strlen(argv[1]) < 3 ) {
		twtty_usage(argc, argv);
		exit(1);
	}

	sourcecode = argv[1][1];
	targetcode = argv[1][2];

/* determine type of source code */

	if ((icode = Index(codeidx,sourcecode)) < 0) {
		printf("unknown input code set: %c\n", sourcecode);
		twtty_usage(argc, argv);
		exit(1);
   	}

/* determine type of target code */

	if ((ocode = Index(codeidx,targetcode)) < 0) {
		printf("unknown output code set: %c\n", targetcode);
		twtty_usage(argc, argv);
		exit(1);
   	}

	twtty(icode, ocode, argc, argv, envp);
}

/*
 * @(#)twtty_usage: help messages
 */
twtty_usage(argc, argv)
int	argc;
char	**argv;
{
	printf("\nBeTTY ** Rev. 1.53 ** 1994/10\n");
	printf("\nUsage: %s -ST [ -c shell_command command_arguments]\n\n", argv[0]);
	printf("\t- 'S'/'T': 1-char source/target terminal/code type\n");
	printf("\t-        : read/send `T' codes from an `S'-type terminal\n");

	printf("\nSource/Target terminal/code: (Case Sensitive)\n\n");
	printf("\t- b: BIG5\n");
	printf("\t- i: IBM5550\n");
	printf("\t- n: NSC Internal (CNS-11643/86, Internal code)\n");
	printf("\t- e: EUC (Extended UNIX Code)\n");
	printf("\t- t: TCA (Taipei Computer Association code)\n");
	printf("\t- l: Telegram\n");
	printf("\t- H: IBM Host\n");
	printf("\t- p: NSC-P (CNS-11643/86, 7bit ISO-type protocol)\n");
	printf("\t- 7: B5E3/BIG5 7-bit ASCII exchange code (See *1 below)\n");
	printf("\t- g: GB code\n");
	printf("\t- h: HZ 7-bit ASCII exchange code for GB\n");
	printf("\t- o: optimal encoding to HZ+B5E3 (See *2 below)\n\n");
	printf("\t*1: Currently, BIG5/7-bit code includes encoding to\n");
	printf("\t    B5ENCODE/III (B5E3/.be3) format\n");
	printf("\t    and decoding from ASCII/DBCS & HZ & B5ENCODE3 mixture\n");
	printf("\t    DBCS: double byte char/code set, like Big5/CNS/5550/TCA\n");
	printf("\t    (also including EUC stuff)\n\n");

	printf("\t*2: -bo: Big5 (Taiwanese codes) => HZ if convertable\n");
	printf("\t         Big5 (Taiwanese codes) => B5E3 if otherwise\n");
	printf("\t    -go: GB => B5E3 if convertable\n");
	printf("\t         GB => HZ if otherwise\n\n");

	printf("Example: %s -be\n", argv[0]);
	printf("\tstdin  big5 codes -> EUC codes -> shell input\n");
	printf("\tstdout big5 codes <- EUC codes <- shell output\n\n");

	printf("Example: %s -b7\n", argv[0]);
	printf("\tFor reading Big5/HZ/B5E3 documents/newsgroups\n");
	printf("\t&   Editing B5E3 documents in a BIG5 terminal\n\n");

	printf("Example: %s -b7 -c rn (tin)\n", argv[0]);
	printf("\tFor reading Big5/HZ/B5E3 newsgroups with 'rn' (or 'tin')\n");
	printf("\t&   exit conversion mode when quit from 'rn' (or 'tin')\n\n");

	printf("Example: %s -eh (or '-bh')\n", argv[0]);
	printf("\tFor reading Big5/HZ/B5E3 documents/newsgroups\n");
	printf("\t&   Editing HZ documents in an EUC (or Big5) terminal\n");
	printf("\t    like (chinese) AIXterm and Sunview/HLE (resp. ETen)\n\n");

}

/*
 * History:
 *
 * $Log: tw.c,v $
 * Revision 1.1  1994/04/21  14:57:45  shin
 * Initial revision
 *
 *
 * ORG:
 * ccvt.c: Revision 1.4  1994/03/16  18:48:00  shin
 */
