<?php

/*
 * A generic table class.  Is is meant to be subclassed by particular
 * table classes.  A table is represented by a name, an array of
 * primary keys, and an array mapping field names to values.
 */
class zoph_table {

    var $table_name;
    var $primary_keys;
    var $fields;

    /*
     * This construnctor should be called from the constructor
     * of a subclass.
     */
    function zoph_table($table_name, $primary_keys) {
        $this->table_name = $table_name;
        $this->primary_keys = $primary_keys;
        $this->fields = array();
    }

    /*
     * Gets a field.
     */
    function get($name) {
        return $this->fields[$name];
    }

    /*
     * Sets a field.
     */
    function set($name, $value) {
        $this->fields[$name] = $value;
    }

    /*
     * Sets fields from the given array.  Can be used to set vars
     * directly from a GET or POST.
     */
    function set_fields($vars) {

        reset($vars);
        while (list($key, $val) = each($vars)) {

            //if (DEBUG) { echo "$key = $val<br>\n"; }

            // ignore empty keys or values
            if (empty($key) || $val == "") { continue; }

            // a leading uderscore signals a non-database field
            if ($key[0] == '_') { continue; }

            // something in ALL CAPS is probably PHP or HTML related
            if (strtoupper($key) == $key) { continue; }

            $this->fields[$key] = $val;

        }

    }

    /*
     * Checks to see if the given field is listed as a primary key.
     */
    function is_key($name, $keys = null) {
        if (!$keys) { $keys = $this->primary_keys; }
        return in_array($name, $keys);
    }

    /*
     * Looks up a record.
     */
    function lookup($sql = null) {

        if (!$this->table_name || !$this->primary_keys || !$this->fields) {
            if (DEBUG) { echo "Missing data<br>\n"; }
            return;
        }

        if (!$sql) {
            $constraint = $this->create_constraints($this->primary_keys);

            if (!$constraint) {
                if (DEBUG) { echo "No constraint found<br>\n"; }
                return;
            }

            $sql = "select * from $this->table_name where $constraint";
        }

        if (DEBUG) { echo "$sql<br>\n"; }

        $result = mysql_query($sql)
            or die_with_mysql_error("Lookup failed:", $sql);

        if (mysql_num_rows($result) == 1) {
            $row = mysql_fetch_assoc($result);

            $this->fields = array();

            //$this->set_fields($row);
            $this->fields = array_merge($this->fields, $row);

            return 1;
        }

        return 0;

    }

    /*
     * Inserts a record.  The default behavior is to ignore the
     * primary key field(s) with the assumption that these will
     * be generated by mysql (auto_increment).  Passing a non null
     * parameter causes these fields to be manually inserted.
     */
    function insert($keep_key = null) {

        if (!$this->table_name || !$this->fields) {
            if (DEBUG) { echo "Missing data<br>\n"; }
            return;
        }

        while (list($name, $value) = each($this->fields)) {

            if ($this->primary_keys && !$keep_key && $this->is_key($name)) {
                continue;
            }

            if ($names) {
                $names .= ", ";
                $values .= ", ";
            }

            $names .= $name;

            if ($name == "password") {
                $values .= "password('" . escape_string($value) . "')";
            }
            else if ($value != "null") {
                $values .= "'" . escape_string($value) . "'";
            }
            else {
                $values .= $value;
            }

        }

        $sql = "insert into $this->table_name ($names) values ($values)";

        if (DEBUG) { echo "$sql<br>\n"; }

        mysql_query($sql) or die_with_mysql_error("Insert failed:", $sql);

        $id = mysql_insert_id();

        if ($this->primary_keys && count($this->primary_keys) == 1) {
            $this->fields[$this->primary_keys[0]] = $id;
        }

        return $id;

    }

    /*
     * Deletes a record.  If extra tables are specified, entries from
     * those tables this match the keys are removed as well.
     */
    function delete($keys = null, $extra_tables = null) {
        if (!$keys) { $keys = $this->primary_keys; }

        if (!$this->table_name || !$keys || !$this->fields) {
            if (DEBUG) { echo "Missing data<br>\n"; }
            return;
        }

        $constraints = $this->create_constraints($keys);

        if (!$constraints) {
            if (DEBUG) { echo "No constraint found<br>\n"; }
            return;
        }

        $sql = "delete from $this->table_name where $constraints";

        if (DEBUG) { echo "$sql<br>\n"; }

        mysql_query($sql) or die_with_mysql_error("Delete failed:", $sql);

        if ($extra_tables) {
            foreach ($extra_tables as $table) {
                $sql = "delete from $table where $constraints";
                if (DEBUG) { echo "$sql<br>\n"; }
                mysql_query($sql) or
                    die_with_mysql_error("Delete from $table failed:", $sql);
            }
        }
    }

    /*
     * Updates a record.
     */
    function update($keys = null) {
        if (!$keys) { $keys = $this->primary_keys; }

        if (!$this->table_name || !$keys || !$this->fields) {
            if (DEBUG) { echo "Missing data<br>\n"; }
            return;
        }

        $constraints = $this->create_constraints($keys);

        if (!$constraints) {
            if (DEBUG) { echo "No constraint found<br>\n"; }
            return;
        }

        while (list($name, $value) = each($this->fields)) {

            if ($this->is_key($name, $keys)) { continue; }

            if ($values) { $values .= ", "; }

            if ($name == "password") {
                $values .= "$name = password('" . escape_string($value) . "')";
            }
            else if ($value != "null") {
                $values .= "$name = '" . escape_string($value) . "'";
            }
            else {
                $values .= "$name = $value";
            }
        }

        if (!$values) { return; }

        $sql = "update $this->table_name set $values where $constraints";

        if (DEBUG) { echo "$sql<br>\n"; }

        mysql_query($sql) or die_with_mysql_error("Update failed:", $sql);

    }

    /*
     * Creates a constraint clause based on the given keys
     */
    function create_constraints($keys) {

        foreach ($keys as $key) {
            $value = $this->fields[$key];
            if (!$value) { continue; }

            if ($constraints) { $constraints .= " and "; }
            $constraints .= "$key = '" . escape_string($value) . "'";
        }

        return $constraints;

    }

    /*
     * Creates an alphabetized array of field names and values.
     */
    function get_display_array() {
        if (!$this->fields) { return; }

        $keys = array_keys($this->fields);
        sort($keys);
        reset($keys);
        foreach ($keys as $k) {
            if ($this->is_key($k)) { continue; }
            $title = make_title($k);
            $da[$title] = $this->fields[$k];
        }

        return $da;
    }

    /*
     * Creates an alphabetized array of field names and text input blocks.
     */
    function get_edit_array() {
        if (!$this->fields) { return; }

        $field_lengths = get_field_lengths($this->table_name);

        $keys = array_keys($field_lengths);
        sort($keys);
        reset($keys);
        foreach ($keys as $k) {
            if ($this->is_key($k)) { continue; }
            $title = make_title($k);

            $len = $field_lengths[$k];
            $size = min($len, 20);

            $ea[$title] = create_text_input($k, $this->fields[$k], $size, $len);
        }

        return $ea;
    }

}

/*
 * Gets the total count of records in the table for the given class.
 */
function get_count($class) {
    $obj = new $class;
    $table = $obj->table_name;

    $sql = "select count(*) from $table";

    if (DEBUG > 1) { echo "$sql<br>\n"; }

    return get_count_from_query($sql);
}

/*
 * Executes the given query and returns the result.
 */
function get_count_from_query($sql) {
    if (DEBUG > 1) { echo "$sql<br>\n"; }

    $result = mysql_query($sql)
        or die_with_mysql_error("Unable to get count", $sql);

    return mysql_result($result, 0, 0);
}

/*
 * Gets an array of the records for a table by doing a * "select *"
 * and storing the results in classes of the given type.
 */
function get_records($class, $order = null, $constraints = null,
    $conj = "and", $ops = null) {

    $obj = new $class;
    $sql = "select * from $obj->table_name";

    if ($constraints) {
        while (list($name, $value) = each($constraints)) {
            if ($constraint_string) {
                $constraint_string .= " $conj ";
            }
            else {
                $constraint_string .=  " where ";
            }

            $op = "=";
            if ($ops && $ops["$name"]) {
                $op = $ops["$name"];
            }

            $n = strpos($name, "#");
            if ($n > 1) {
                $name = substr($name, 0, $n);
            }

            if ($value == "null" || $value == "''") {
                // ok
            }
            else {
                $value = "'" . escape_string($value) . "'";
            }

            $constraint_string .= "$name $op $value";
        }
        $sql .= $constraint_string;
    }

    if ($order) {
        $sql .= " order by $order";
    }

    return get_records_from_query($class, $sql);
}

/*
 * Stores the results the the given query in an array of objects of
 * this given type.
 */
function get_records_from_query($class, $sql, $min = 0, $num = 0) {

    if (DEBUG > 1) { echo "$sql<br>\n"; }

    $result = mysql_query($sql)
        or die_with_mysql_error("Unable to get records", $sql);

    if ($min) {
        mysql_data_seek($result, $min);
    }

    if ($num) {
        $limit = true;
    }

    $objs = array();
    if ($class != null) {
        while ((!$limit || $num-- > 0) && $row = mysql_fetch_assoc($result)) {
            $obj = new $class;
            $obj->set_fields($row);
            $objs[] = $obj;
        }
    }
    else {
        // use to grab ids, for example
        while ((!$limit || $num-- > 0) && $row = mysql_fetch_row($result)) {
            $objs[] = $row[0];
        }
    }

    mysql_free_result($result);
    return $objs;
}

/*
 * Executes a query and returns an array in which each record's
 * link is mapped to its count (dirived by a group by clause).
 */
function get_popular_results($class, $query) {
    $records = get_records_from_query($class, $query);
    foreach ($records as $rec) {
        $pop_array[$rec->get_link()] = $rec->get("count");
    }
    return $pop_array;
}

/*
 * Creates an array to be used in the create_pulldown methods.  The
 * values of the fields in the name_fields parameter are concatentated
 * together to construnct the titles of the selections.
 */
function create_select_array($records, $name_fields) {
    if (!$records || !$name_fields) { return; }

    foreach ($records as $rec) {
        // this only makes sense when there is one key
        $id = $rec->get($rec->primary_keys[0]);

        $name = "";
        foreach ($name_fields as $n) {
            if ($name) { $name .= " "; }
            $name .= $rec->get($n);
        }

        $sa[$id] = $name;
    }

    return $sa;
}

/*
 * Creates an object of the given class and returns the output of
 * its get_link() method.
 */
function get_link($class, $id) {
    if (!$class || !$id) { return ""; }

    $obj = new $class($id);
    $obj->lookup();
    return $obj->get_link();
}

/*
 * Creates a comma separated list of links from the given records.
 * The class of the records must implement the get_link function.
 */
function create_link_list($records) {
    $links = "";
    if ($records) {
        foreach ($records as $rec) {
            if ($links) { $links .= ", "; }
            $links .= $rec->get_link();
        }
    }

    return $links;
}

////////// some utility functions //////////

/*
 * Escapes various characters in the given string using the
 * mysql_escape_string function.
 */
function escape_string($str) {

    if (ini_get("magic_quotes_gpc")) {
        // unstrip quotes
        $str = stripslashes($str);
    }

    return mysql_escape_string($str);

}

/*
 * Simply executes the given query.  If silence is passed, any errors
 * are ignored.
 */
function execute_query($sql, $silent = 0) {
    if (DEBUG > 1) { echo "$sql<br>\n"; }
    if ($silent) {
        mysql_query($sql);
    }
    else {
        mysql_query($sql) or die_with_mysql_error("Something went wrong", $sql);
    }
}

function die_with_mysql_error($msg, $sql = "") {
    $msg =
        "<p><strong>$msg</strong><br>\n" .
        "<code>" . mysql_error() . "</code></p>\n";

    if ($sql) {
        $msg .= "<hr><p><code>$sql</code></p>\n";
    }

    die($msg);
}

function get_zoph_info_array() {
    $album= get_root_album();
    $category = get_root_category();

    $size = ceil(get_photo_sizes_sum() / 1048576);
    return array(
        translate("number of photos") => get_count("photo"),
        translate("size of photos") => "$size MB",
        translate("number of photos in an album") =>
            $album->get_total_photo_count(),
        translate("number of categorized photos") =>
            $category->get_total_photo_count(),
        translate("number of people") => get_count("person"),
        translate("number of places") => get_count("place")
    );
}

function get_field_lengths($table_name) {

    $db_fields = mysql_list_fields(DB_NAME, $table_name);
    $columns = mysql_num_fields($db_fields);
    for ($i = 0; $i < $columns; $i++) {
        $field_lengths[mysql_field_name($db_fields, $i)] =
            mysql_field_len($db_fields, $i);
    }

    return $field_lengths;
}

?>
