"""
Unit test package for ZWiki.

As test suites are added, they should be added to the mega-test-suite
below.

NB: ZWiki tests are not necessarily comprehensive, consistent,
well-structured. Maybe I should test at a lower level ? They may be
more like a bunch of random spot checks, that's still darn useful.

The CMF tests seem to support running from the command-line as well as
in the zope context. I can't see that ever working for me so maybe
I'll drop that code for clarity.

simpletestrunner was a learning experience, and still has some
problems. For god's sake get old zunit working again. Aha! a zunit 0.1
testrunner will happily run the test_suite below, and what's more it's
giving a pretty streaming output I have never seen before. I'll TAKE it.

old notes, test ideas:

  how to do authentication/permissions-related testing ?

  test functionality of all the different page types, with no, good &
  bad dtml

  test edit's various cases

  test leading & trailing newline preservation

  test initial http-like-header: preservation

  test whether stx heading on first line works

  test all the various kinds of links - mailto, http, wikiname,
  remotewikilink, stx, combinations..

  test handling of large cookies, empty cookies, missing cookies by
  UserOptions, editform, standard_wiki_header...

  test rendering without dtml methods and with various other versions
  of the methods

  test with other zope versions (at least product startup). Test
  with/without ZWikiWebs; ZUnit; doctest; other ZWiki versions; other
  related products

  test zwiki_base,page_url with & without a SiteRoot

  test permissions

  the prerelease checklist on http://zwiki.org/ZWikiWebs

  check all version nos. are correct (special prerelease test ?)

  what's the best way to handle sometimes-applicable tests - like the
  above, or testing virtual hosting only if SiteAccess is found 

  tests that would catch eg the deepappend bug that broke page
  creation from a top-level page, eg: visit both
  TestPage/editform?page=NewPage and
  TestPage/SubPage/editform?page=NewPage, in a basic wiki (simple
  title) and a zwikidotorg wiki (with show_hierarchy enabled)
  (SubPage should be a child of TestPage, add this to setup)

"""

from Products.ZWiki.tests import simpletestrunner
from Products.ZWiki.tests import testDoctests
from Products.ZWiki.tests import testZWikiPage
from Products.ZWiki.tests import testZWikiWeb
# need these froms ?

def test_suite():
    suite = simpletestrunner.TestSuite()
    suite.addTest(testDoctests.test_suite())
    suite.addTest(testZWikiPage.test_suite())
    suite.addTest(testZWikiWeb.test_suite())
    return suite

#def suite():
#    modules_to_test = ('listtests', 'widgettests') # and so on
#    alltests = unittest.TestSuite()
#    for module in map(__import__, modules_to_test):
#        alltests.addTest(module.suite())
#    return alltests

def run(context=None):
    """
    This is for running tests through the web, via an external
    method that looks like this:

      def run_tests(self):
        from Products.ZWiki import tests; return tests.run(context=self)

    But there are problems. Pointing ZUnit 0.1 at
    Products.ZWiki.tests.test_suite works better.

    """
    return(simpletestrunner.simpleTestRunner(test_suite(), context))
