###################################################################################################
# zmstextarea.py
#
# $Id: zmstextarea.py,v 1.5 2004/02/24 19:57:22 dnordmann Exp $
# $Name:  $
# $Author: dnordmann $
# $Revision: 1.5 $
#
# Implementation of class ZMSTextarea (see below).
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
###################################################################################################

# Imports.
from Globals import HTML, HTMLFile
import string 
import urllib
# Product Imports.
from zmsobject import ZMSObject
import _globals
import _metadata


###################################################################################################
###################################################################################################
###   
###   C o n s t r u c t o r ( s )
###   
###################################################################################################
###################################################################################################

def manage_addZMSTextarea(self, lang, manage_lang, _sort_id, REQUEST):
  """ manage_addZMSTextarea """
    
  ##### Create ####
  id_prefix = _globals.id_prefix(REQUEST.get('id','e'))
  obj = ZMSTextarea(self.getNewId(id_prefix),_sort_id+1)
  self._setObject(obj.id, obj)
  
  obj = getattr(self,obj.id)
  ##### Object State ####
  obj.setObjStateNew(REQUEST)
  ##### Init Coverage ####
  coverage = self.getDCCoverage(REQUEST)
  if coverage.find('local.')==0:
    obj.setObjProperty('attr_dc_coverage',coverage)
  else:
    obj.setObjProperty('attr_dc_coverage','global.'+lang)
  ##### Init Properties ####
  obj.setObjProperty('active',1,lang)
  ##### VersionManager ####
  obj.onChangeObj(REQUEST)
            
  ##### Normalize Sort-IDs ####
  self.normalizeSortIds(id_prefix)
        
  # Return with message.        
  if REQUEST.RESPONSE:
    message = self.getLangStr('MSG_INSERTED',manage_lang)%obj.display_type(REQUEST)
    REQUEST.RESPONSE.redirect('%s/%s/manage_main?lang=%s&manage_lang=%s&manage_tabs_message=%s'%(self.absolute_url(),obj.id,lang,manage_lang,urllib.quote(message)))


###################################################################################################
###################################################################################################
###   
###   C l a s s
###   
###################################################################################################
###################################################################################################

class ZMSTextarea(ZMSObject, _metadata.Metadata):

    # Properties.
    # -----------
    meta_type = "ZMSTextarea"
    icon = "misc_/zms/zmstextarea.gif"
    icon_disabled = "misc_/zms/zmstextarea_disabled.gif"

    # Management Options.
    # -------------------
    manage_options = ( 
	{'label': 'TAB_EDIT',       'action': 'manage_main'},
	{'label': 'TAB_REFERENCES', 'action': 'manage_RefForm'},
	{'label': 'TAB_HISTORY',    'action': 'manage_UndoVersionForm'},
	{'label': 'TAB_PREVIEW',    'action': 'preview_html'}, # empty string defaults to index_html
	)

    # Management Permissions.
    # -----------------------
    __authorPermissions__ = (
		'manage','manage_main','manage_workspace',
		'manage_changeProperties',
		'manage_moveObjUp','manage_moveObjDown',
		'manage_cutObjects','manage_copyObjects','manage_pasteObjs',
		'manage_userForm','manage_user',
		)
    __ac_permissions__=(
		('ZMS Author', __authorPermissions__),
		)

    # Properties.
    # -----------
    __obj_attrs__ = {
        # Changed by
        'change_uid':{'datatype':'string','multilang':1,'xml':0,'lang_inherit':0},
        'change_dt':{'datatype':'datetime','multilang':1,'xml':0,'lang_inherit':0},
        # Properties
        'sort_id':{'datatype':'string','xml':0},
        'active':{'datatype':'boolean','multilang':1},
        'attr_active_start':{'datatype':'datetime','multilang':1},
        'attr_active_end':{'datatype':'datetime','multilang':1},
        'format':{'datatype':'string'},
        'text':{'datatype':'text','multilang':1,'type':'text','size':50},
        # Meta-Data
        'attr_dc_coverage':{'datatype':'string'},
        # Meta-Dictionaries        
        '$metadict':{'datatype':'MetaDict'},
    }


    # Management Interface.
    # ---------------------
    manage_main = HTMLFile('dtml/zmstextarea/manage_main', globals())
    epoz_toolbox = HTMLFile('dtml/zmstextarea/epoz_toolbox', globals())


    """
    ###############################################################################################    
    #
    #   CONSTRUCTOR
    #
    ###############################################################################################    
    """

    # -------------------------------------------------------------------------------------------------
    #  ZMSTextarea.recurse_updateVersion:
    #
    #  Update version.
    # -------------------------------------------------------------------------------------------------
    def recurse_updateVersion(self, REQUEST):
      message = ''

      # Process super-objects.
      message += ZMSObject.recurse_updateVersion(self,REQUEST)
        
      # Process object.
      # [...]

      # Return with message.
      return message


    """
    ###############################################################################################    
    ###
    ###   P r o p e r t i e s
    ###
    ###############################################################################################    
    """

    ###############################################################################################
    #  ZMSTextarea.manage_changeProperties: 
    #
    #  Change Textarea properties.
    ###############################################################################################
    def manage_changeProperties(self, lang, manage_lang, REQUEST, RESPONSE): 
      """ ZMSTextarea.manage_changeProperties """
      
      message = ''
      if REQUEST.get('btn','') != self.getLangStr('BTN_CANCEL',manage_lang):
        
        ##### Object State ####
        self.setObjStateModified(REQUEST)
        
        ##### Properties ####
        # Metadata.
        self.setMetadata(lang,manage_lang,REQUEST)
        # Attributes.
        for key in self.getObjAttrs().keys():
          self.setReqProperty(key,REQUEST)
        
        ##### VersionManager ####
        self.onChangeObj(REQUEST)
        
        ##### Message ####
        message = self.getLangStr('MSG_CHANGED',manage_lang)
      
      # Return with message.
      self.checkIn(REQUEST)
      return RESPONSE.redirect('%s/manage_main?lang=%s&manage_lang=%s&manage_tabs_message=%s#_%s'%(self.getParentNode().absolute_url(),lang,manage_lang,urllib.quote(message),self.id))


    # ---------------------------------------------------------------------------------------------
    #  ZMSTextarea.isPageElement
    # ---------------------------------------------------------------------------------------------
    def isPageElement(self): return 1

    # ---------------------------------------------------------------------------------------------
    #  ZMSTextarea.getTitlealt
    # ---------------------------------------------------------------------------------------------
    def getTitlealt(self,REQUEST): return self.display_type(REQUEST)

    # ---------------------------------------------------------------------------------------------
    #  ZMSTextarea.getText
    # ---------------------------------------------------------------------------------------------
    def getText(self,REQUEST): 
      text = self.getObjProperty('text',REQUEST)
      # Number headlines
      levelnfc = self._getLevelnfc(REQUEST)
      if len(levelnfc) > 0:
        text = levelnfc + ' ' + text
      return text

    # ---------------------------------------------------------------------------------------------
    #  ZMSTextarea.getFormat
    # ---------------------------------------------------------------------------------------------
    def getFormat(self,REQUEST):
      format = self.getObjProperty('format',REQUEST)
      if format is None or len(format) == 0:
        format = self.getTextFormatDefault(REQUEST)
      return format


    """
    ###############################################################################################
    ###
    ###  H T M L - P r e s e n t a t i o n 
    ###
    ###############################################################################################
    """

    # ---------------------------------------------------------------------------------------------
    #  ZMSTextarea.getLevelnfc
    # ---------------------------------------------------------------------------------------------
    def _getLevelnfc(self, REQUEST):
      s = ''
      textformat = self.getFormat(REQUEST)
      if textformat.find('headline')==0:
        parent = self.getParentNode()
        levelnfc = parent.getObjProperty('levelnfc',REQUEST)
        if len(levelnfc) > 0:
          s = parent._getLevelnfc(REQUEST)
          sectionizer = _globals.MySectionizer()
          for sibling in parent.filteredChildNodes(REQUEST,['ZMSTextarea']):
            textformat = sibling.getFormat(REQUEST)
            if textformat.find('headline')==0:
              level = int(textformat[len(_globals.id_prefix(textformat)):])-1
              sectionizer.processLevel(level)
              if self == sibling:
                s += str(sectionizer)
      return s

    # ---------------------------------------------------------------------------------------------
    #	ZMSTextarea._getBodyContent:
    #
    #	HTML presentation of Textarea. 
    # ---------------------------------------------------------------------------------------------
    def _getBodyContent(self, REQUEST, thumbnail=0):
      # Retrieve properties.
      text = self.getText(REQUEST)
      textformat = self.getFormat(REQUEST)
      # Render HTML presentation.
      text = self.renderText(self.id, textformat, text, REQUEST)
      text = self.renderContentEditable('text', text, REQUEST)
      # Return <html>-presentation.
      return text

    # ---------------------------------------------------------------------------------------------
    #	ZMSTextarea.renderShort:
    #
    #	Renders short presentation of Textarea.
    # ---------------------------------------------------------------------------------------------
    def renderShort(self, REQUEST):
      return self._getBodyContent(REQUEST,thumbnail=1)

###################################################################################################
