###################################################################################################
# zmslinkelement.py
#
# $Id: zmslinkelement.py,v 1.6 2004/02/24 19:57:22 dnordmann Exp $
# $Name:  $
# $Author: dnordmann $
# $Revision: 1.6 $
#
# Implementation of class ZMSLinkElement (see below).
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
###################################################################################################

# Imports.
from Globals import HTML, HTMLFile
import urllib
# Product Imports.
from zmscontainerobject import ZMSContainerObject
from zmsobject import ZMSObject
import _globals
import _metadata
import _zreferableitem


# ------------------------------------------------------------------------------------------
#  zmslinkelement.initZMSLinkElement: 
#
#  Inits properties of ZMSLinkElement.
# ------------------------------------------------------------------------------------------
def initZMSLinkElement(oItem, REQUEST):
  lang = REQUEST['lang']
  ref_obj = oItem.getRefObj()
  if ref_obj is None:
    if len(_globals.nvl(oItem.getObjProperty('title',REQUEST),'')) == 0:
      oItem.setObjProperty('title',oItem.getObjProperty('attr_ref',REQUEST),lang)


# ------------------------------------------------------------------------------------------
#  zmslinkelement.setZMSLinkElement: 
#
#  Sets properties of ZMSLinkElement (from ZMSLinkContainer).
# ------------------------------------------------------------------------------------------
def setZMSLinkElement(oItem, title, url, description, REQUEST):
  lang = REQUEST['lang']
  
  if title != oItem.getObjProperty('titleshort',REQUEST) or \
     title != oItem.getObjProperty('title',REQUEST) or \
     url != oItem.getObjProperty('attr_ref',REQUEST) or \
     description != oItem.getObjProperty('attr_dc_description',REQUEST):

    type = 'new'
    if _zreferableitem.isInternalLink(url):
      type = 'replace'

    ##### Object State ####
    oItem.setObjStateModified(REQUEST)

    ##### Set Metadata ####
    oItem.setObjProperty('attr_dc_description',description,lang)

    ##### Set Properties ####
    oItem.setObjProperty('titleshort',title,lang)
    oItem.setObjProperty('title',title,lang)
    oItem.setObjProperty('attr_ref',url,lang)
    oItem.setObjProperty('attr_type',type,lang)
    initZMSLinkElement(oItem,REQUEST)
    
    ##### VersionManager ####
    oItem.onChangeObj(REQUEST)


# ------------------------------------------------------------------------------------------
#  zmslinkelement.addZMSLinkElement: 
#
#  Adds ZMSLinkElement (to ZMSLinkContainer).
# ------------------------------------------------------------------------------------------
def addZMSLinkElement(self, title, url, description, REQUEST):
  lang = REQUEST['lang']
  manage_lang = REQUEST['manage_lang']
  type = 'new'
  if _zreferableitem.isInternalLink(url):
    type = 'replace'

  ##### Create ####
  id_prefix = _globals.id_prefix(REQUEST.get('id','e'))
  obj = ZMSLinkElement(self.getNewId(id_prefix))
  self._setObject(obj.id, obj)

  obj = getattr(self,obj.id)

  ##### Object State ####
  obj.setObjStateNew(REQUEST)

  ##### Init Metadata (Important: DC.Coverage!) ####
  obj.setObjProperty("attr_dc_coverage","local."+lang,lang)
  obj.setObjProperty("attr_dc_description",description,lang)

  ##### Init Properties ####
  obj.setObjProperty("titleshort",title,lang)
  obj.setObjProperty("title",title,lang)
  obj.setObjProperty("active",1,lang)
  obj.setObjProperty("attr_ref",url,lang)
  obj.setObjProperty("attr_type",type,lang)
  initZMSLinkElement(obj,REQUEST)
    
  ##### VersionManager ####
  obj.onChangeObj(REQUEST)

  ##### Normalize Sort-IDs ####
  self.normalizeSortIds(id_prefix)
  
  return obj


###################################################################################################
###################################################################################################
###   
###   C o n s t r u c t o r ( s )
###   
###################################################################################################
###################################################################################################

manage_addZMSLinkElementForm = HTMLFile('manage_addzmslinkelementform', globals()) 
def manage_addZMSLinkElement(self, lang, manage_lang, _sort_id, REQUEST):
  """ manage_addZMSLinkElement """
  
  ##### Create ####
  id_prefix = _globals.id_prefix(REQUEST.get('id','e'))
  obj = ZMSLinkElement(self.getNewId(id_prefix),_sort_id+1)
  self._setObject(obj.id, obj)
  
  obj = getattr(self,obj.id)

  ##### Object State ####
  obj.setObjStateNew(REQUEST)

  ##### Init Metadata (Important: DC.Coverage!) ####
  obj.setMetadata(lang,manage_lang,REQUEST)

  ##### Init Properties ####
  obj.setReqProperty('titleshort',REQUEST)
  obj.setReqProperty('title',REQUEST)
  obj.setReqProperty('active',REQUEST)
  obj.setReqProperty('attr_active_start',REQUEST)
  obj.setReqProperty('attr_active_end',REQUEST)
  obj.setReqProperty('attr_ref',REQUEST)
  obj.setReqProperty('attr_type',REQUEST)
  initZMSLinkElement(obj,REQUEST)
    
  ##### VersionManager ####
  obj.onChangeObj(REQUEST)
            
  ##### Normalize Sort-IDs ####
  self.normalizeSortIds(id_prefix)

  # Return with message.        
  if REQUEST.RESPONSE:
    message = self.getLangStr('MSG_INSERTED',manage_lang)%obj.display_type(REQUEST)
    REQUEST.RESPONSE.redirect('%s/%s/manage_main?lang=%s&manage_lang=%s&manage_tabs_message=%s'%(self.absolute_url(),obj.id,lang,manage_lang,urllib.quote(message)))
        


###################################################################################################
###################################################################################################
###   
###   C l a s s
###   
###################################################################################################
###################################################################################################

class ZMSLinkElement(ZMSContainerObject, _metadata.Metadata):

    # Properties.
    # -----------
    meta_type = "ZMSLinkElement"
    icon = "misc_/zms/zmslinkcontainer.gif"
    icon_disabled = "misc_/zms/zmslinkcontainer_disabled.gif"

    # Management Options.
    # -------------------
    manage_options = ( 
	{'label': 'TAB_EDIT',    'action': 'manage_main'},
	{'label': 'TAB_HISTORY', 'action': 'manage_UndoVersionForm'},
	{'label': 'TAB_PREVIEW', 'action': 'preview_html'}, # empty string defaults to index_html
	)

    # Management Permissions.
    # -----------------------
    __authorPermissions__ = (
		'manage','manage_main','manage_workspace',
		'manage_changeProperties',
		'manage_moveObjUp','manage_moveObjDown',
		'manage_cutObjects','manage_copyObjects','manage_pasteObjs',
		'manage_userForm','manage_user',
		)
    __ac_permissions__=(
		('ZMS Author', __authorPermissions__),
		)

    # Properties.
    # -----------
    __obj_attrs__ = {
        # Changed by
        'change_uid':{'datatype':'string','multilang':1,'xml':0,'lang_inherit':0},
        'change_dt':{'datatype':'datetime','multilang':1,'xml':0,'lang_inherit':0},
        # Versioned by
        'work_uid':{'datatype':'string','multilang':1,'xml':0,'lang_inherit':0},
        'work_dt':{'datatype':'datetime','multilang':1,'xml':0,'lang_inherit':0},
        # Properties
        'sort_id':{'datatype':'string','xml':0},
        'active':{'datatype':'boolean'},
        'attr_active_start':{'datatype':'datetime','multilang':1},
        'attr_active_end':{'datatype':'datetime','multilang':1},
        'titleshort':{'datatype':'string','multilang':1,'size':20},
        'title':{'datatype':'string','multilang':1,'size':40},
        'attr_ref':{'datatype':'url'},
        'attr_type':{'datatype':'string','type':'select','options':['replace','replace','new','new','embed','embed','recursive','recursive']},
        # Meta-Data
        'attr_dc_coverage':{'datatype':'string'},
        # Meta-Dictionaries        
        '$metadict':{'datatype':'MetaDict'},
    }


    # Management Interface.
    # ---------------------
    manage_main = HTMLFile('dtml/zmslinkelement/manage_main', globals())


    """
    ###############################################################################################
    #
    #   Constructor
    #
    ###############################################################################################
    """

    # ------------------------------------------------------------------------------------------
    #  ZMSLinkElement.recurse_updateVersion:
    #
    #  Update version.
    # ------------------------------------------------------------------------------------------
    def recurse_updateVersion(self, REQUEST):
      message = ''
        
      # Process super-objects.
      message += ZMSObject.recurse_updateVersion(self,REQUEST)
        
      # Process object.
      # [...]
      
      # Return with message.
      return message


    # ------------------------------------------------------------------------------------------
    #  ZMSLinkElement.isEmbedded: 
    # ------------------------------------------------------------------------------------------
    def isEmbedded(self, REQUEST):
      return self.getObjProperty('attr_type',REQUEST) in ['embed','recursive']

    # ------------------------------------------------------------------------------------------
    #  ZMSLinkElement.getLinkList: 
    #
    #  Overrides getLinkList of zmscontainerobject.ZMSContainerObject.
    # ------------------------------------------------------------------------------------------
    def getLinkList(self, REQUEST, allow_none=0):
      rtn = []
      append = 1
      append = append and self.isVisible(REQUEST)
      append = append and not self.isResource(REQUEST) # Object is not resource.
      if append:
        if self.isPage() and self.isEmbedded(REQUEST):
          for el in ZMSContainerObject.getLinkList(self,REQUEST,allow_none):
            if not el in rtn:
              rtn.append(el)
          ref_obj = self.getRefObj()
          if ref_obj is not None and issubclass(ref_obj.__class__,ZMSContainerObject):
            for el in ZMSContainerObject.getLinkList(ref_obj,REQUEST,allow_none):
              if not el in rtn:
                rtn.append(el)
        elif not self.isEmbedded(REQUEST):
          ref = self.getObjProperty('attr_ref',REQUEST)
          dct = {}
          dct['internal'] = _zreferableitem.isInternalLink(ref)
          dct['src'] = self
          dct['dst'] = self.getLinkObj(ref,REQUEST)
          dct['url'] = self.getLinkUrl(ref,REQUEST)
          dct['title'] = self.getTitle(REQUEST)
          dct['description'] = _globals.nvl(self.getObjProperty('attr_dc_description',REQUEST),'')
          rtn.extend([dct])
      return rtn


    """
    ###############################################################################################
    ###
    ###   Properties
    ###
    ###############################################################################################
    """

    ###############################################################################################
    #  ZMSLinkElement.manage_changeProperties: 
    #
    #  Change Linkelement properties.
    ###############################################################################################
    def manage_changeProperties(self, lang, manage_lang, REQUEST, RESPONSE): 
      """ ZMSLinkElement.manage_changeProperties """
      
      message = ''
      if REQUEST.get('btn','') != self.getLangStr('BTN_CANCEL',manage_lang):
        
        ##### Object State ####
        self.setObjStateModified(REQUEST)
        
        ##### Properties ####
        for key in self.getObjAttrs().keys():
          obj_attr = self.getObjAttr(key)
          if obj_attr['xml']:
            self.setReqProperty(key,REQUEST)
        
        ##### Metadata ####
        self.setMetadata(lang,manage_lang,REQUEST)
        
        ##### VersionManager ####
        self.onChangeObj(REQUEST)
        
        ##### Message ####
        message = self.getLangStr('MSG_CHANGED',manage_lang)
      
      # Return with message.
      self.checkIn(REQUEST)
      return RESPONSE.redirect('%s/manage_main?lang=%s&manage_lang=%s&manage_tabs_message=%s#_%s'%(self.getParentNode().absolute_url(),lang,manage_lang,urllib.quote(message),self.id))


    # -------------------------------------------------------------------------------------------------
    #  ZMSLinkElement.getRefObj:
    # -------------------------------------------------------------------------------------------------
    def getRefObj(self): 
      coverage = self.getDCCoverage()
      req = {'preview':'preview','lang':coverage[coverage.find('.')+1:]}
      ref = self.getObjProperty('attr_ref',req)
      ref_obj = self.getLinkObj(ref,req)
      if ref_obj == self:
        ref_obj = None
      if ref_obj is not None and ref_obj.meta_type == 'ZMSLinkElement':
        ref_obj = ref_obj.getRefObj()
      return ref_obj


    # -------------------------------------------------------------------------------------------------
    #  ZMSLinkElement.isMetaType:
    # -------------------------------------------------------------------------------------------------
    def isMetaType(self, meta_type, REQUEST={'preview':'preview'}):
      b = 0
      if not (self.NOREF == meta_type or (type(meta_type) is type([]) and self.NOREF in meta_type)):
        b = b or ZMSObject.isMetaType(self,meta_type,REQUEST)
        ref_obj = self.getRefObj()
        if ref_obj is not None and self.isEmbedded(REQUEST):
          if not (self.NORESOLVEREF == meta_type or (type(meta_type) is type([]) and self.NORESOLVEREF in meta_type)):
            b = b or ref_obj.isMetaType(meta_type,REQUEST)
      return b


    # -------------------------------------------------------------------------------------------------
    #  ZMSLinkElement.getSelf:
    # -------------------------------------------------------------------------------------------------
    def getSelf(self, meta_type=None):
      ob = self
      if meta_type is not None and not ob.isMetaType(meta_type):
        ob = self.getRefObj()
        if ob is None or not ob.isMetaType(meta_type):
          ob = ZMSContainerObject.getSelf(self,meta_type)
      return ob


    # -------------------------------------------------------------------------------------------------
    #  ZMSLinkElement.getTitlealt:
    # -------------------------------------------------------------------------------------------------
    def getTitlealt(self, REQUEST):
      titlealt = self.getObjProperty('titleshort',REQUEST)
      if len(titlealt) == 0:
        ref_obj = self.getRefObj()
        if ref_obj is None or not self.isEmbedded(REQUEST):
          titlealt = ZMSContainerObject.getTitlealt(self,REQUEST)
        else:
          titlealt = ref_obj.getTitlealt(REQUEST)
      if len(titlealt) == 0:
        titlealt = self.display_type(REQUEST)
      return titlealt

      
    # ---------------------------------------------------------------------------------------------
    #  ZMSLinkElement.display_icon:
    # ---------------------------------------------------------------------------------------------
    def display_icon(self, REQUEST, meta_type=''): 
      ref_obj = self.getRefObj()
      if ref_obj is None or not self.isEmbedded(REQUEST):
        ref_obj = self
      if len(meta_type) == 0:
        if self.isActive(REQUEST):
          return ref_obj.icon
        else:
          return ref_obj.icon_disabled
      else:
        return ref_obj.display_icon(REQUEST,meta_type)

    
    # -------------------------------------------------------------------------------------------------
    #  ZMSLinkElement.isActive:
    # -------------------------------------------------------------------------------------------------
    def isActive(self, REQUEST):
      active = 1
      active = active and ZMSContainerObject.isActive(self,REQUEST) 
      ref_obj = self.getRefObj()
      if ref_obj is not None:
          active = active and ref_obj.isActive(REQUEST)
      return active

    
    # -------------------------------------------------------------------------------------------------
    #  ZMSLinkElement.isPage
    # -------------------------------------------------------------------------------------------------
    def isPage(self):
      req = {'lang':self.getPrimaryLanguage(),'preview':'preview'}
      page = 0
      embedded = self.isEmbedded(req)
      ref_obj = self.getRefObj()
      page = page or (ref_obj is None and embedded)
      if ref_obj is not None:
        page = page or (ref_obj.isPage() and embedded)
      return page


    # -------------------------------------------------------------------------------------------------
    #  ZMSLinkElement.isPageElement
    # -------------------------------------------------------------------------------------------------
    def isPageElement(self): 
      page_element = 0
      ref_obj = self.getRefObj()
      if ref_obj is not None:
        page_element = page_element or ref_obj.isPageElement()
      return page_element


    # ---------------------------------------------------------------------------------------------
    #  ZMSLinkElement.getType
    #
    #  Overrides getType of zmscustom.ZMSCustom. 
    # ---------------------------------------------------------------------------------------------
    def getType(self): 
      ref_obj = self.getRefObj()
      if ref_obj is not None and ref_obj.meta_type=='ZMSCustom':
         return ref_obj.getType()
      return 'ZMSObject'


    # ---------------------------------------------------------------------------------------------
    #  ZMSLinkElement.getObjProperty
    #
    #  Overrides getObjProperty of _objattrs.ObjAttrs. 
    # ---------------------------------------------------------------------------------------------
    def getObjProperty(self, key, REQUEST={}, default=None): 
      obj_attr = self.getObjAttr(key)
      value = self.getObjAttrValue(obj_attr,REQUEST) 
      if not key in ['attr_ref','attr_dc_coverage'] and (value is None or len(str(value)) == 0):
        ref_obj = self.getRefObj()
        if ref_obj is not None:
          obj_attr = ref_obj.getObjAttr(key)
          value = ref_obj.getObjAttrValue(obj_attr,REQUEST)
      return value


    # ---------------------------------------------------------------------------------------------
    #  ZMSLinkElement.getTeaserElements:
    #
    #  Overrides getTeaserElements of zmscontainerobject.ZMSContainerObject.
    # ---------------------------------------------------------------------------------------------
    def getTeaserElements(self, REQUEST, current=None):
      teaserElmnts = []
      if self.isPage():
        for el in ZMSContainerObject.getTeaserElements(self,REQUEST):
          if not el in teaserElmnts:
            teaserElmnts.append(el)
        ref_obj = self.getRefObj()
        if ref_obj is not None and issubclass(ref_obj.__class__,ZMSContainerObject):
          for el in ZMSContainerObject.getTeaserElements(ref_obj,REQUEST):
            if not el in teaserElmnts:
              teaserElmnts.append(el)
      # Return elements.
      return teaserElmnts


    """
    ###############################################################################################
    ###
    ###  HTML-Presentation
    ###
    ###############################################################################################
    """

    # ---------------------------------------------------------------------------------------------
    #	ZMSLinkElement.getHref2IndexHtml:
    # ---------------------------------------------------------------------------------------------
    def getHref2IndexHtml(self, REQUEST, deep=1): 
      s = ZMSContainerObject.getHref2IndexHtml(self,REQUEST,deep)
      if self.isEmbedded(REQUEST):
        ref_obj = self.getRefObj()
        if ref_obj is None:
          s = self.getObjProperty('attr_ref',REQUEST)
        # Just a quick hack to make it work.
        elif self.getObjProperty('attr_type',REQUEST) == 'recursive':
          s = '%s/index_%s.html'%(self.absolute_url(),REQUEST.get('lang',self.getPrimaryLanguage()))
      return s


    # ---------------------------------------------------------------------------------------------
    #	ZMSLinkElement._getBodyContent:
    #
    #	HTML presentation of Linkelement. 
    # ---------------------------------------------------------------------------------------------
    def _getBodyContent(self, REQUEST, thumbnail=0):
      s = ''
      if self.isEmbedded(REQUEST):
        ref_obj = self.getRefObj()
        if ref_obj is not None:
          s += ref_obj._getBodyContent(REQUEST,thumbnail)
      return s


    # ---------------------------------------------------------------------------------------------
    #	ZMSLinkElement.renderShort:
    #
    #	Renders short presentation of Linkelement.
    # ---------------------------------------------------------------------------------------------
    def renderShort(self, REQUEST):
      s = ''
      ref = self.getObjProperty('attr_ref',REQUEST)
      ref_obj = self.getRefObj()
      target = ''
      img_src = 'external_link.gif'
      if _zreferableitem.isInternalLink(ref):
        if ref_obj is None:
          img_src = 'internal_link_broken.gif'
          ref = 'javascript:alert(\'Broken Link >%s<!\');'%(ref)
        else:
          img_src = 'internal_link.gif'
          if self.isPreviewRequest(REQUEST):
            ref = '%s/manage_main?lang=%s&manage_lang=%s'%(ref_obj.absolute_url(),REQUEST['lang'],REQUEST['manage_lang'])
          else:
            ref = ref_obj.getHref2IndexHtml(REQUEST)
      elif _zreferableitem.isMailLink(ref):
        img_src = 'mail_link.gif'
      
      if self.isEmbedded(REQUEST):
        if not _zreferableitem.isInternalLink(ref):
          target = ' target="_blank"'
        render = ''
        if ref_obj is None or ref_obj.isPage():
          render += ZMSContainerObject.renderShort(self,REQUEST)
        else:
          render += ref_obj.renderShort(REQUEST)
        s += '<table cellspacing="0" cellpadding="2" border="0">\n'
        s += '<tr valign="top">\n'
        s += '<td><a href="%s"%s class="zmi"><img src="%s%s" alt="" border="0" /></a></td>\n'%(ref,target,self.MISC_ZMS,img_src)
        s += '<td style="border: solid 1px #888888;">%s</td>\n'%render
        s += '</tr>\n'
        s += '</table>\n'
      
      else:
        title = self.getTitle(REQUEST)
        medline = title.lower()=='medline'
        if medline:
          title = '<img src="%spubmed_small.gif" alt="Medline" border="0">'%(self.MISC_ZMS)
          ref = _zreferableitem.getMedlineLink(ref)
        if self.getObjProperty('attr_type',REQUEST) == 'new':
          target = ' target="_blank"'
        description = self.getObjProperty('attr_dc_description',REQUEST)
        s += '<table cellspacing="1" cellpadding="0" border="0">\n'
        s += '<tr valign="top">\n'
        s += '<td rowspan="2"><img src="%s%s" alt="" border="0" align="absmiddle" /></td>\n'%(self.MISC_ZMS,img_src)
        s += '<td class="form-small"><a href="%s"%s class="zmi">%s</a></td>\n'%(ref,target,title)
        s += '</tr>\n'
        if description is not None and len(str(description)) > 0:
          s += '<tr valign="top">\n'
          s += '<td class="form-small">%s</td>\n'%description
          s += '</tr>\n'
        s += '</table>\n'
      
      return s


    # ------------------------------------------------------------------------------------------
    #  ZMSLinkElement.catalogText:
    #
    #  Catalog text of Link (overwrite method from ZCatalogItem).
    # ------------------------------------------------------------------------------------------
    def catalogText(self, REQUEST):
      s = ''
      ref_obj = self.getRefObj()
      if ref_obj is not None and self.isEmbedded(REQUEST):
        s = ZMSObject.catalogText(ref_obj,REQUEST)
      else:
        s = ZMSObject.catalogText(self,REQUEST)
      return s


    """
    ###############################################################################################
    ###  
    ###  DOM-Methods
    ### 
    ###############################################################################################
    """

    # ---------------------------------------------------------------------------------------------
    #  ZMSLinkElement.getChildNodes:
    #
    #  Overrides getChildNodes of zmscontainerobject.ZMSContainerObject. 
    # ---------------------------------------------------------------------------------------------
    def getChildNodes(self, REQUEST={}, meta_types=None):
      child_nodes = []
      ref_obj = self.getRefObj()
      if ref_obj is not None and (self.getObjProperty('attr_type',REQUEST) == 'recursive' or (ref_obj.isPage() and meta_types == self.PAGEELEMENTS)):
        child_nodes = ref_obj.getChildNodes(REQUEST,meta_types)
      return child_nodes

###################################################################################################
