# -*- coding: utf-8 -*-
## 
## Copyright (C)2005 Ingeniweb

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.

## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING. If not, write to the
## Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

"""
$Id: ExFileLock.py,v 1.7 2006/03/06 08:42:57 encolpe Exp $
"""
__docformat__ = 'restructuredtext'


# Zope imports
from AccessControl import ClassSecurityInfo

# CMF imports
from Products.CMFCore import CMFCorePermissions
from Products.CMFCore.utils import getToolByName

# ExFile imports
from Products.PloneExFile import Permissions
from Products.PloneExFile.LockMixin import LockMixin

# backwards compatibility, do not remove
from Products.PloneExFile.LockWidget import LockWidget
LockWidget = LockWidget

#                                                                           #
#                           LOCKING SUPPORT                                 #
#                                                                           #

schema = LockMixin.schema.copy()
schema['is_locked'].widget.visible = {'view' : 'hidden', 'edit' : 'hidden'}

class ExFileLock(LockMixin):

    ForceUnlockPermission = Permissions.LockExFile
    ToggleLockPermission = Permissions.EditExFile

    schema = schema
    security = ClassSecurityInfo()

    security.declareProtected(CMFCorePermissions.View, 'hasLockSupport')
    def hasLockSupport(self):
        # Return lock support
        portal_properties = getToolByName(self, "portal_properties")
        props = portal_properties.ploneexfile_properties

        return props.use_lock
