##############################################################################
# 
# Zope Public License (ZPL) Version 1.0
# -------------------------------------
# 
# Copyright (c) Digital Creations.  All rights reserved.
# 
# This license has been certified as Open Source(tm).
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
# 
# 1. Redistributions in source code must retain the above copyright
#    notice, this list of conditions, and the following disclaimer.
# 
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions, and the following disclaimer in
#    the documentation and/or other materials provided with the
#    distribution.
# 
# 3. Digital Creations requests that attribution be given to Zope
#    in any manner possible. Zope includes a "Powered by Zope"
#    button that is installed by default. While it is not a license
#    violation to remove this button, it is requested that the
#    attribution remain. A significant investment has been put
#    into Zope, and this effort will continue if the Zope community
#    continues to grow. This is one way to assure that growth.
# 
# 4. All advertising materials and documentation mentioning
#    features derived from or use of this software must display
#    the following acknowledgement:
# 
#      "This product includes software developed by Digital Creations
#      for use in the Z Object Publishing Environment
#      (http://www.zope.org/)."
# 
#    In the event that the product being advertised includes an
#    intact Zope distribution (with copyright and license included)
#    then this clause is waived.
# 
# 5. Names associated with Zope or Digital Creations must not be used to
#    endorse or promote products derived from this software without
#    prior written permission from Digital Creations.
# 
# 6. Modified redistributions of any form whatsoever must retain
#    the following acknowledgment:
# 
#      "This product includes software developed by Digital Creations
#      for use in the Z Object Publishing Environment
#      (http://www.zope.org/)."
# 
#    Intact (re-)distributions of any official Zope release do not
#    require an external acknowledgement.
# 
# 7. Modifications are encouraged but must be packaged separately as
#    patches to official Zope releases.  Distributions that do not
#    clearly separate the patches from the original work must be clearly
#    labeled as unofficial distributions.  Modifications which do not
#    carry the name Zope may be packaged in any form, as long as they
#    conform to all of the clauses above.
# 
# 
# Disclaimer
# 
#   THIS SOFTWARE IS PROVIDED BY DIGITAL CREATIONS ``AS IS'' AND ANY
#   EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
#   PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL DIGITAL CREATIONS OR ITS
#   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
#   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
#   USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
#   ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
#   OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
#   OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
#   SUCH DAMAGE.
# 
# 
# This software consists of contributions made by Digital Creations and
# many individuals on behalf of Digital Creations.  Specific
# attributions are listed in the accompanying credits file.
# 
##############################################################################
"test that the ParsedXML DOM object acquire implicitly"

# this suite isn't done that well.  We could probably just mount a db.

# We currently have to have a Zope instance
# to mount; we need a persistent container & Zope traversal to acquire
# properly, because we don't want to acquire through the transient
# proxy objects.

import unittest
import ZODB # for Persistent
from Products.ParsedXML import ParsedXML

def checkAcquire(aqer, aqee, name):
    "check that acquisition of name from aqee to aqer happens"
    assert hasattr(aqer, name)
    assert getattr(aqer, name) == getattr(aqee, name)
    assert getattr(aqer, name) is getattr(aqee, name)

def checkAcquireNot(aqer, aqee, name):
    "check that acquisition of name from aqee to aqer doesn't happen"
    assert getattr(aqer, name) != getattr(aqee, name)
    assert getattr(aqer, name) is not getattr(aqee, name)

class WrappedAcquisitionTestCase(unittest.TestCase):

    def setUp(self):
        # we need a persistent doc in a container that supports
        # restrictedTraverse and getPhysicalPath to have a proper
        # acquisition chain.
        import Zope
        self.app = Zope.app()                
        self.tmpId = 'TempParsedXMLUnitTestInstance'
        self.app.manage_addProduct['ParsedXML'].manage_addParsedXML(
            self.tmpId)
        self.doc = getattr(self.app, self.tmpId)
        
        self.app.string = 'a string'
        self.app.firstChild = "a string that shouldn't be acquired"

        elt1 = self.doc.createElement('eggs')
        elt2 = self.doc.createElement('ham')
        self.doc.documentElement.appendChild(elt1)
        self.doc.documentElement.appendChild(elt2)
        self.doc.documentElement.setAttribute('color', 'green')

    def _acquisitionTest(self, DOMObj):
        checkAcquire(DOMObj, self.app, 'string')
        checkAcquireNot(DOMObj, self.app, 'firstChild')

    def checkTraversalAcquisition(self):
        "make sure we can acquire through DOM traversal"
        self._acquisitionTest(self.doc)
        self._acquisitionTest(self.doc.documentElement)
        self._acquisitionTest(self.doc.documentElement.firstChild)
        self._acquisitionTest(self.doc.documentElement.firstChild.nextSibling)
        self._acquisitionTest(self.doc.documentElement.ownerDocument)
        self._acquisitionTest(self.doc.documentElement.getAttributeNode(
            'color'))

    def checkMethodAcquisition(self):
        "make sure we acquire through proxied DOM methods"
        elt = self.doc.createElement('foo')
        self._acquisitionTest(self.doc.documentElement.appendChild(elt))

    def checkNodeListAcquisition(self):
        "make sure we can acquire through a NodeList"
        self._acquisitionTest(self.doc.documentElement.childNodes.item(0))

    def checkNamedNodeMapAcquisition(self):
        "make sure we can acquire through a NamedNodeMap"
        self._acquisitionTest(
            self.doc.documentElement.attributes.getNamedItem('color'))

                
def test_suite():
    """Return a test suite for the Zope testing framework."""

    suite = unittest.TestSuite()
    suite.addTest(unittest.makeSuite(WrappedAcquisitionTestCase, 'check'))
    return suite

def main():
    unittest.TextTestRunner().run(test_suite())

if __name__ == "__main__":
    main()
