from OFS.PropertySheets import PropertySheet
from Providers import Provider
from Globals import HTMLFile, default__class_init__
from Products.PlugIns import defaultConstructors

psKey = 'ZPatterns.SheetProviders', 'PropertySheets'



































class SheetProvider(Provider):
    """
    Sheet provider example class.  This sheet provider uses the 'slot'
    facility of Racks/Rackmountables to provide arbitrary propertysheets
    stored persistently.  All of its methods would need to be redefined
    for SheetProviders that implement fixed-schema and/or non-slot-based
    property sheets.
    """

    __plugin_kind__ = 'Property Sheet Provider'


    def namesForRegistration(self,container):
        """
Return a tuple (names,namespaces) where names is a sequence of
sheet names, and namespaces a sequence of XML namespaces, which this sheet
provider supports.  '*' may be included in either or both sequences, which
means the provider will be called if a more specific provider could not
be found for a given sheet.  This is mainly so that sheet providers can
potentially create propertysheets dynamically based on the requested name
or namespace.
        """
        return {
            'provides': ('sheets',),
            'sheet_names': self.Sheet_Names,
            'sheet_xmlns': self.Sheet_Namespaces
        }


    def _PropertySheetFor(self,client,name='',xmlns=''):
        """
        Return client's propertysheet matching name or xmlns, if available.
        Otherwise return None.
        """
        pslist = client._v_readableSlot.get(psKey,())
        for ps in pslist:
            if (name and ps.id==name) or (xmlns and ps.xml_namespace()==xmlns):
                return ps



    def _addPropertySheetFor(self,client,name='',xmlns=''):
        """
        Return client's new propertysheet matching name or xmlns, if possible.
        Otherwise return None.
        """
        ps=PropertySheet(name, {'xmlns':xmlns})
        pslist = client._v_readableSlot.get(psKey,())+(ps,)
        client._v_writeableSlot[psKey] = pslist
        return ps


    def _delPropertySheetFor(self,client,name='',xmlns=''):
        """
        Delete client's propertysheet matching name or xmlns, if present.
        Always returns None (unless an unexpected error occurs, of course)
        """
        pslist = client._v_readableSlot.get(psKey,())
        newlist = tuple(filter(
            lambda ps,name=name,xmlns=xmlns: 
                (not name or ps.id!=name) and 
                (not xmlns or ps.xml_namespace()!=xmlns),
            pslist
        ))
        if newlist!=pslist:
            client._v_writeableSlot[psKey] = newlist


    def _PropertySheetsFor(self, client):
        """Return a (possibly empty) list of PropertySheet objects for client"""
        # Note: this could include duplicate sheets if persistent sheets
        # are defined by more than one provider!
        return client._v_readableSlot.get(psKey,())









    # Class Metadata
    
    meta_type='Persistent Sheet Provider'
    
    Sheet_Names = ('*',)
    Sheet_Namespaces = ('*',)

    _properties=(
        {'id':'title', 'type': 'string', 'mode': 'w'},
        {'id':'Sheet_Names', 'type': 'tokens', 'mode': 'w'},
        {'id':'Sheet_Namespaces', 'type': 'lines', 'mode': 'w'},
    )





























def initialize(context):

    context.registerPlugInClass(
        SheetProvider,
        permission = 'Add Sheet Providers',
        constructors = defaultConstructors(SheetProvider,globals()),
        icon = 'www/sheetprov.gif'
    )









