from Globals import InitializeClass
from AccessControl import ClassSecurityInfo
from AccessControl.User import nobody
from ZODB.POSException import ConflictError

from Products.CMFCore.utils import getToolByName
from Products.CMFCore.CMFCorePermissions import SetOwnPassword, ManagePortal
from Products.CMFCore.utils import getToolByName, _checkPermission
from Products.CMFDefault.DublinCore import DefaultDublinCoreImpl
from Products.CMFPlone.MembershipTool import MembershipTool as BaseTool

from Products.Archetypes.utils import OrderedDict
from Products.CMFMember.permission import VIEW_PUBLIC_PERMISSION


class MembershipTool( BaseTool ):
    meta_type='CMFMember Membership Tool'
    security = ClassSecurityInfo()
    plone_tool = 1

    security.declarePublic('getMemberInfo')
    def getMemberInfo(self, memberId=None):
        """
        Return 'harmless' Memberinfo of any member, such as Full name,
        Location, etc
        """
        if not memberId:
            member = self.getAuthenticatedMember()
        else:
            member = self.getMemberById(memberId)

        if member is None:
            return None

        memberinfo = {'fullname': '',
                      'description': '',
                      'location': '',
                      'language': '',
                      'home_page': '',
                      }

        for fieldname in memberinfo.keys():
            memberinfo[fieldname] = member.getField(fieldname).getAccessor(member)()

        return memberinfo
    
    def getPersonalPortrait(self, member_id=None, verifyPermission=0):
        """Returns the Portait for a member_id"""
        portal = getToolByName(self, 'portal_url').getPortalObject()
        default_portrait = getattr(portal, self.default_portrait)
        if not member_id:
            return default_portrait

        member = None
        try:
            member = self._getMemberDataContainer().get(member_id)
            if verifyPermission and not _checkPermission(VIEW_PUBLIC_PERMISSION, member):
                return default_portrait
            portrait = member.getPortrait()
            if portrait:
                return portrait
        except AttributeError:
            pass
        return default_portrait

    def changeMemberPortrait(self, portrait, member_id=None):
        """Override Plone's changeMemberPortrait method to use
        CMFMember's portrait management"""
        if not member_id:
            return
        
        member = self._getMemberDataContainer().get(member_id, None)
        if member:
            member.setPortrait(portrait)

    def searchForMembers( self, REQUEST=None, **kw ):
        """
        here for backwards compatibility; member searching is better
        accomplished using the member_catalog, which this ultimately
        delegates to
        """
        if type(REQUEST) == type({}):
            param = REQUEST # folder_localroles_form passes a dict here as REQUEST
            REQUEST = None
        elif REQUEST:
            param = REQUEST.form
        else:
            param = kw

        # mapping from older lookup names to the indexes that exist
        # in the member_catalog
        key_map = {'name': 'getId',
                   'email': 'getEmail',
                   'roles': 'getFilteredRoles',
                   'groupname': 'getGroups', # XXX this is a case sensitive search, but is case insensitive in standard plone 2.1
                   'last_login_time': 'getLastLoginTime',
                   }
        for key in key_map.keys():
            if param.has_key(key):
                # swap old parameter for what the catalog expects
                param[key_map[key]] = param.pop(key)
                
        return self._getMemberDataContainer().searchForMembers(REQUEST, **param)

    def createMemberarea(self, member_id=None, minimal=1):
        """ created hook for 'preCreateMemberArea' and 'postCreateMemberArea'
            if you provide methods or PythonScripts with these names, they will 
            be called at the begin and end of createMemberData
            
            if preCreateMemberArea returns 1 the normal createMemberArea will be
            called. otherwise it is skipped.
        """
        if not self.getMemberareaCreationFlag():
            return None
        members = self.getMembersFolder()
        if members is None:
            return None
        if self.isAnonymousUser():
            return None

        if not member_id:
            # member_id is optional (see CMFCore.interfaces.portal_membership:
            #     Create a member area for 'member_id' or authenticated user.)
            member = self.getAuthenticatedMember()
            member_id = member.getId()

        if members._getOb(member_id, None) is not None:
            # has already this member
            # XXX exception
            return None

        # do not create member_area for groups
        if hasattr(self, 'portal_groups') and \
               member_id in self.portal_groups.listGroupIds():
            return None

        # if preCreateMemberArea returns false,
        # no further creation of the member area takes place
        createarea = 1
        pre = getattr(self, 'preCreateMemberArea', None)
        if pre:
            createarea = pre(member_id=member_id)
        if createarea:
            BaseTool.createMemberarea(self, member_id)
        post = getattr(self, 'postCreateMemberArea', None)
        if post:
            post(member_id=member_id)

    security.declarePublic('createMemberArea')
    createMemberArea = createMemberarea

    security.declarePrivate('addMember')
    def addMember(self, id, password, roles, domains, properties=None):
        '''Adds a new member to the user folder.  Security checks will have
        already been performed.  Called by portal_registration.
        '''

        member_type = 'Member'
        typeName = str(self._getMemberDataContainer().getTypeName())
        if typeName:
            member_type = typeName
        self._getMemberDataContainer().invokeFactory(member_type,id)
        member=getattr(self._getMemberDataContainer().aq_explicit,id)
        member.edit(password=password,roles=roles,domains=domains,**(properties or {}))


    def getMemberById(self, id):
        ''' overload of CMFCore.MembershipTool.getMemberById, returns None if member doesnt exist '''
        member=getattr(self._getMemberDataContainer().aq_explicit,id,None)
        
        if member is not None:
            return member

        # if no member found, use the default method
        return BaseTool.getMemberById(self, id)

    def _getMemberDataContainer(self):
        md_path = getattr(self, 'memberdata_container_path', None)
        if md_path is None:
            mdc = getToolByName(self, 'portal_memberdata')
            md_path = mdc.getPhysicalPath()
        return self.unrestrictedTraverse(md_path)

    security.declarePrivate('wrapUser')
    def wrapUser(self, u, wrap_anon=0):
        """ Set up the correct acquisition wrappers for a user object.

        Provides an opportunity for a portal_memberdata tool to retrieve and
        store member data independently of the user object.

        this is a retardly stupid fix for CMF1.5 since empty folder evaluate
        as false when iffed
        """
        b = getattr(u, 'aq_base', None)
        if b is None:
            # u isn't wrapped at all.  Wrap it in self.acl_users.
            b = u
            u = u.__of__(self.acl_users)
        if (b is nobody and not wrap_anon) or hasattr(b, 'getMemberId'):
            # This user is either not recognized by acl_users or it is
            # already registered with something that implements the
            # member data tool at least partially.
            return u

        # Apply any role mapping if we have it
        if hasattr(self, 'role_map'):
            for portal_role in self.role_map.keys():
                if (self.role_map.get(portal_role) in u.roles and
                        portal_role not in u.roles):
                    u.roles.append(portal_role)

        mdtool = getToolByName(self, 'portal_memberdata', None)
        if mdtool != None:
            try:
                portal_user = mdtool.wrapUser(u)
                # if the underlying CMF is in the 1.4 series, we need to
                # (possibly) create member area here; in 1.5, this happens
                # in the logged_in.py script
                app = self.getPhysicalRoot()
                cmf_version = app.Control_Panel.Products.CMFCore.version
                if cmf_version.startswith('CMF-1.4'):
                    if getattr(self, 'memberareaCreationFlag', 0) != 0:
                        if self.getHomeUrl(portal_user.getId()) is None:
                            self.createMemberarea(portal_user.getId())

                return portal_user
            except ConflictError:
                raise
            except:
                from zLOG import LOG, ERROR
                import sys
                LOG('CMFCore.membership',
                    ERROR,
                    'Error during wrapUser',
                    error=sys.exc_info(),
                    )
                print sys.exc_info()
        return u

InitializeClass(MembershipTool)
