# Customizes the Plone site so CMFMember is installed and ready to use
from Products.CMFCore.utils import getToolByName
from Products.CMFPlone.Portal import addPolicy
from Products.CMFPlone.interfaces.CustomizationPolicy import ICustomizationPolicy
from Products.CMFPlone.CustomizationPolicy import DefaultCustomizationPolicy
from Products.CMFMember.config import USE_SCHEMA_EDITOR

def register(context, app_state):
    addPolicy('CMFMember Site', CMFMemberSitePolicy())
    addPolicy('CMFMember & LDAP Site', CMFMemberLDAPSitePolicy())

class CMFMemberSitePolicy(DefaultCustomizationPolicy):
    """ Customizes the Plone site so CMFMember is installed and ready to use """
    __implements__ = ICustomizationPolicy

    availableAtConstruction = True
    
    def customize(self, portal):
        DefaultCustomizationPolicy().customize(portal)
        self.setupCMFMember(portal)
        if USE_SCHEMA_EDITOR:
            self.setupATSE(portal)
    
    def setupCMFMember(self, portal):
        portal.portal_quickinstaller.installProduct("CMFMember")
        portal.cmfmember_control.upgrade(swallow_errors=0) 
    
    def setupATSE(self, portal):
        portal.portal_quickinstaller.installProduct("ATSchemaEditorNG")
        
        
class CMFMemberLDAPSitePolicy(CMFMemberSitePolicy):
    """ Customizes the Plone site so CMFMember is installed and ready to use """
    __implements__ = ICustomizationPolicy

    availableAtConstruction = True
    
    def customize(self, portal):
        DefaultCustomizationPolicy().customize(portal)
        self.setupCMFMember(portal)
        if USE_SCHEMA_EDITOR:
            self.setupATSE(portal)        
        self.setupLDAPStuff(portal)
        
    def setupLDAPStuff(self, portal):
        """ Basic LDAP initialization inside gruf's user source. 
            Code from GRUF3/tests. """
            
        try:
            from ldap_config import settings
        except:
            from tests.config import defaults as settings    
        
        dg = settings.get
        # User source replacement
        portal.acl_users.replaceUserSource("Users",
            "manage_addProduct/LDAPUserFolder/manage_addLDAPUserFolder",
            title = dg('title'),
            LDAP_server = dg('server'),
            login_attr = dg('login_attr'),
            uid_attr = dg('uid_attr'),
            users_base = dg('users_base'),
            users_scope = dg('users_scope'),
            roles= dg('roles'),
            groups_base = dg('groups_base'),
            groups_scope = dg('groups_scope'),
            binduid = dg('binduid'),
            bindpwd = dg('bindpwd'),
            binduid_usage = dg('binduid_usage'),
            rdn_attr = dg('rdn_attr'),
            local_groups = dg('local_groups'),
            encryption = dg('encryption'),
            use_ssl = dg('use_ssl'),
            read_only=dg('read_only'),
            )
        # Edit LDAPUF 'cause objectClass cannot be set otherwise :(
        portal.acl_users.Users.acl_users.manage_edit(
            title = dg('title'),
            login_attr = dg('login_attr'),
            uid_attr = dg('uid_attr'),
            users_base = dg('users_base'),
            users_scope = dg('users_scope'),
            roles= dg('roles'),
            obj_classes = 'top,inetOrgPerson',
            groups_base = dg('groups_base'),
            groups_scope = dg('groups_scope'),
            binduid = dg('binduid'),
            bindpwd = dg('bindpwd'),
            binduid_usage = dg('binduid_usage'),
            rdn_attr = dg('rdn_attr'),
            local_groups = dg('local_groups'),
            encryption = dg('encryption'),
            read_only=dg('read_only'),
            )

        md = getToolByName(portal, 'portal_memberdata')
        md.atse_addField('Member', 'default', '' , 'externalStorage')
        md.atse_getSchemaById('Member').get('externalStorage').default = 'LDAPUserFolder'
        md.atse_updateManagedSchema('Member', '')            
