from Products.CMFCore.utils import getToolByName
from Products.Archetypes import public as atapi
from Products.CMFMember.config import USE_SCHEMA_EDITOR
from Products.CMFMember.content.member_schema import *
from Products.CMFMember.content.member import BaseMember

def registerIdWidget(portal):
    """
    Register IdWidget w/ the schema editor, if it's not already
    registered
    """
    out = []
    if USE_SCHEMA_EDITOR:
        mdc = getToolByName(portal, 'portal_memberdata')
        widget_map = mdc.atse_getWidgetMap()
        if not widget_map.has_key('Id'):
            out.append('Registering IdWidget w/ portal_memberdata SchemaEditor')
            mdc.atse_registerWidget('Id', atapi.IdWidget(),
                                    visible=True, useVocab=False)
        field_map = mdc.atse_getFieldMap()
        if not field_map['ComputedField'].has_key('post_method'):
            out.append('Setting ComputedField post_macro and post_method')
            from Products.ATSchemaEditorNG.SchemaEditor import field_registry
            computed_info = field_registry['ComputedField']
            mdc.atse_registerFieldType('ComputedField',
                                       computed_info['field'],
                                       **computed_info)
                                       
    return out

def one1b1_one1b2(portal):
    """
    Upgrade from CMFMember 1.1b1 to CMFMember 1.1b2.
    """
    out = []
    
    out += registerIdWidget(portal)
    
    return out
