# -*- coding: utf-8 -*-
## AttchmentField
## Copyright (C)2006 Ingeniweb

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.

## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING. If not, write to the
## Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
"""
AttchmentField
"""
__version__ = "$Revision: 23006 $"
# $Source: /cvsroot/ingeniweb/PloneSubscription/SubscriptionTool.py,v $
# $Id: ArcheSiteTestCase.py 23006 2006-05-02 20:25:43Z encolpe $
__docformat__ = 'restructuredtext'

import time

from AccessControl.SecurityManagement import newSecurityManager
from AccessControl.SecurityManagement import noSecurityManager
from Acquisition import aq_base
from Testing import ZopeTestCase

from Products.Archetypes.Extensions.Install import install as installArchetypes

from Products.CMFPlone.tests import PloneTestCase

class ArcheSiteTestCase(PloneTestCase.PloneTestCase):
    """ archetypes test case with plone site """

    def getManagerUser(self):
        uf = self.portal.acl_users
        return uf.getUserById('PloneManager').__of__(uf)

    def getMemberUser(self):
        uf = self.portal.acl_users
        return uf.getUserById('PloneMember').__of__(uf)

def setupArchetypes(app, quiet=0):
    if not hasattr(app.portal, 'archetype_tool'):
        get_transaction().begin()
        _start = time.time()
        if not quiet: ZopeTestCase._print('Adding Archetypes ... ')

        uf = app.portal.acl_users
        # setup
        uf._doAddUser('PloneMember', '', ['Members'], [])
        uf._doAddUser('PloneManager', '', ['Manager'], [])
        # login as manager
        user = uf.getUserById('PloneManager').__of__(uf)
        newSecurityManager(None, user)
        # add Archetypes
        installArchetypes(app.portal, include_demo=1)
        # Log out
        noSecurityManager()
        get_transaction().commit()
        if not quiet: ZopeTestCase._print('done (%.3fs)\n' % (time.time()-_start,))

app = ZopeTestCase.app()
setupArchetypes(app)
ZopeTestCase.close(app)
