package WSNotification::Types::FilterType;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(0);

sub get_xmlns { 'http://docs.oasis-open.org/wsn/b-2' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %TopicExpression_of :ATTR(:get<TopicExpression>);
my %MessageContent_of :ATTR(:get<MessageContent>);

__PACKAGE__->_factory(
    [ qw(        TopicExpression
        MessageContent

    ) ],
    {
        'TopicExpression' => \%TopicExpression_of,
        'MessageContent' => \%MessageContent_of,
    },
    {
        'TopicExpression' => 'WSNotification::Elements::TopicExpression',

        'MessageContent' => 'WSNotification::Elements::MessageContent',

    },
    {

        'TopicExpression' => '',
        'MessageContent' => '',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

WSNotification::Types::FilterType

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
FilterType from the namespace http://docs.oasis-open.org/wsn/b-2.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * TopicExpression

Note: The name of this property has been altered, because it didn't match
perl's notion of variable/subroutine names. The altered name is used in
perl code only, XML output uses the original name:

 


=item * MessageContent

Note: The name of this property has been altered, because it didn't match
perl's notion of variable/subroutine names. The altered name is used in
perl code only, XML output uses the original name:

 




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # WSNotification::Types::FilterType
   TopicExpression =>  { # WSNotification::Types::TopicExpressionType
   },
   MessageContent =>  { # WSNotification::Types::QueryExpressionType
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

