{
(***********************************************************************)
(*                               Zoggy                                 *)
(*                                                                     *)
(*            Maxence Guesdon, projet Cristal, INRIA Rocquencourt      *)
(*                                                                     *)
(*  Copyright 2001 Institut National de Recherche en Informatique et   *)
(*  en Automatique.  All rights reserved.  This file is distributed    *)
(*  under the terms of the Q Public License version 1.0.               *)
(*                                                                     *)
(***********************************************************************)

open StdLabels
open Zog_parser

let print_DEBUG s = print_string s ; print_newline ()

let string_buffer = Buffer.create 32

let reset_string_buffer () = Buffer.reset string_buffer
let ajout_char_string = Buffer.add_char string_buffer
let ajout_string = Buffer.add_string string_buffer
let lecture_string () = Buffer.contents string_buffer


} 

rule token = parse
  [ ' ' '\t']+     { token lexbuf }
| '\n'             { incr Zog_misc.line_number ; token lexbuf }
| "<entity"        { ENTITY_START }
| "</entity>"      { ENTITY_END }
| "name="          { NAME }
|  "=\""           { value_string lexbuf }
|  '>'             { SUP }

| "<" ['A'-'Z' 'a'-'z' '0'-'9' '_']+
  {
    let l = Lexing.lexeme lexbuf in
    let s = String.sub l ~pos:1 ~len:(String.length l - 1) in
    print_DEBUG ("WIDGET_START "^s) ;
    WIDGET_START s
  }

| "</" ['A'-'Z' 'a'-'z' '0'-'9' '_']+ '>'
  {
    let l = Lexing.lexeme lexbuf in
    let s = String.sub l ~pos:2 ~len:(String.length l - 3) in
    print_DEBUG ("WIDGET_END "^s) ;
    WIDGET_END s
  }

| '"' [^ '"']* '"'
  {
    let l = Lexing.lexeme lexbuf in
    let s = String.sub l ~pos:1 ~len:(String.length l - 2) in
    IDENT s
  }

| '\'' [^ '\'']* '\''
  {
    let l = Lexing.lexeme lexbuf in
    let s = String.sub l ~pos:1 ~len:(String.length l - 2) in
    IDENT s
  }

| ['A'-'Z' 'a'-'z' '0'-'9' '_' '.']+
  {
    let s = Lexing.lexeme lexbuf in IDENT s
  }

| eof               { EOF }

and value_string = parse
    [' ' '\013' '\009' '\012'] +
    { 
(*      Odoc_comments_global.nb_chars := !Odoc_comments_global.nb_chars + (String.length (Lexing.lexeme lexbuf));*)
      value_string lexbuf
    }
    
| [ '\010' ]
    { 
      incr Zog_misc.line_number ; value_string lexbuf 
    }

  | "\""
      {
(*	let len = String.length (Lexing.lexeme lexbuf) in
	lexbuf.Lexing.lex_abs_pos <- lexbuf.Lexing.lex_abs_pos - len;
        lexbuf.Lexing.lex_curr_pos <- lexbuf.Lexing.lex_curr_pos - len;
        lexbuf.Lexing.lex_last_pos <- lexbuf.Lexing.lex_last_pos - len;
*)
	let s = lecture_string () in
	reset_string_buffer ();
	VALUE s
      }	

  | _
      {
(*        incr Odoc_comments_global.nb_chars;*)
	let c = (Lexing.lexeme_char lexbuf 0) in
        ajout_char_string c;
        value_string lexbuf
      }

