/*      Copyright (C) 2001, 2002, 2003, 2004 Stijn van Dongen
 *
 * This file is part of Zoem. You can redistribute and/or modify Zoem under the
 * terms of the GNU General Public License;  either version 2 of the License or
 * (at your option) any later  version.  You should have received a copy of the
 * GPL along with Zoem, in the file COPYING.
*/

#ifndef zoem_ref_h__
#define zoem_ref_h__

#include "util/ting.h"
#include "util/types.h"


typedef struct refNode_t* refNode_p;

/*
 * Returns whether the ref was *not* already present.
*/
mcxbool yamRefNew
(  const char* anchor
,  const char* level
,  const char* type
,  const char* counter
,  const char* caption
,  const char* misc
)  ;


refNode_p yamRefGet
(  mcxTing*  key
)  ;

/*
 * If key is not found as ref, returns replacement string if second arg
 * is ok. (one of nltcm).
 * It returns NULL if and only if second arg is not [nltcm].
*/
const char*  yamRefMember
(  mcxTing*  key
,  char c
)  ;

int yamRefDangles
(  void
)  ;

void mod_ref_init
(  int n
)  ;

void mod_ref_exit
(  void
)  ;

#endif

