#ifdef linux
#define DIRENT_ILLEGAL_ACCESS /* for dirent */
#endif

#define _LARGEFILE64_SOURCE
#define _GNU_SOURCE


/*
 * readdir.c
 *
 * Copyright (C) 1993 Alain Knaff
 */
#define _LARGEFILE64_SOURCE
#define _GNU_SOURCE

#include "sysincludes.h"


struct dirent *__libc_readdir(DIR * dir);


#ifdef oldlinux
/* old version of readdir */

/*
 * readdir fills up the buffer with the readdir system call. it also
 * gives a third parameter (currently ignored, but should be 1) that
 * can with a future kernel be enhanced to be the number of entries
 * to be gotten.
 *
 * Right now the readdir system call return the number of characters
 * in the name - in the future it will probably return the number of
 * entries gotten. No matter - right now we just check for positive:
 * that will always work (as we know that it cannot be bigger than 1
 * in the future: we just asked for one entry).
 */
struct dirent *__libc_readdir(DIR * dir)
{
  int result;
  int count = NUMENT;

  if (dir->dd_size <= dir->dd_nextloc) {
    /* read count of directory entries. For now it should be one. */
#if defined(__PIC__) || defined (__pic__)
	__asm__ volatile ("pushl %%ebx\n\t"
			  "movl %%esi,%%ebx\n\t"
			  "int $0x80\n\t"
			  "popl %%ebx"
	:"=a" (result)
	:"0" (SYS_readdir),"S" (dir->dd_fd),
	"c" ((long) dir->dd_buf),"d" (count));
#else
    __asm__("int $0x80"
	:"=a" (result)
	:"0" (SYS_readdir),"b" (dir->dd_fd),
	"c" ((long) dir->dd_buf),"d" (count));
#endif
    if (result <= 0) {
      if (result < 0)
	errno = -result;
      return NULL;
    }

    /*
     * Right now the readdir system call return the number of
     * characters in the name - in the future it will probably return
     * the number of entries gotten. No matter - right now we just
     * check for positive:
     */
    dir->dd_size = 1;

    dir->dd_nextloc = 0;
  }

  return &(dir->dd_buf [(dir->dd_nextloc)++]);
}
#endif




#define READDIR readdir
#define real_READDIR zlib_real_readdir
#define DIRENT dirent
#define ADJUST_NAME adjust_name

#include "readdir_tmpl.c"

#undef READDIR
#undef real_READDIR
#undef DIRENT
#undef ADJUST_NAME

extern struct dirent64 *__readdir64 (DIR *dirp);

#define READDIR readdir64
#define real_READDIR zlib_real_readdir64
#define DIRENT dirent64
#define ADJUST_NAME adjust_name64

#include "readdir_tmpl.c"

#ifdef SYS_getdents
int getdents(int fd, struct dirent *dirp, unsigned int count)
{
  int left;

  count=zlib_real_getdents(fd, dirp, count);
  if(count<=0)
    return count;

  zlib_initialise();

  if(zlib_mode & ( CM_DISAB | CM_READDIR_COMPR))
    return count;

  if (zlib_mode & CM_VERBOSE)
    fprintf(stderr,"getdents\n");
  
  for(left = count;
      left;
      left -= dirp->d_reclen,
      dirp = (struct dirent *) ((char *)dirp + dirp->d_reclen))
    adjust_name(fd, dirp);
  return count;
}
#endif



#if 0
/* SunOS */

struct dirent *readdir(DIR *dirp)
{
  struct dirent *ptr;
  char *extension;
  int l;

  if (!dirp) {
    errno = EBADF;
    return NULL; 
  }

  if ( dirp->dd_size){
    ptr = (struct dirent *) ( dirp->dd_buf + dirp->dd_loc);
    dirp->dd_loc += ptr->d_reclen;
  }
    
  if ( dirp->dd_size <= dirp->dd_loc ){
    dirp->dd_size=getdents( dirp->dd_fd, dirp->dd_buf, dirp->dd_bsize);
    if ( dirp->dd_size == 0 )
      return 0;
    dirp->dd_loc = 0;
  }

  ptr = (struct dirent *) ( dirp->dd_buf + dirp->dd_loc);
  dirp->dd_off = ptr->d_off;

  zlib_initialise();
  adjust_name(dirp->dd_fd,ptr);  
  return ptr;
}
#endif

