/*____________________________________________________________________________

   Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)

   Copyright (C) 1999-2000 EMusic

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   $Id: Theme.h,v 1.5 2003/09/16 17:35:32 kgk Exp $
____________________________________________________________________________*/ 

#ifndef INCLUDED_THEME_H__
#define INCLUDED_THEME_H__

// The debugger can't handle symbols more than 255 characters long.
// STL often creates symbols longer than that.
// When symbols are longer than 255 characters, the warning is disabled.
#include "config.h"
#ifdef WIN32
#pragma warning(disable:4786)
#endif

#include <string>
#include <vector>
#include <map>

#include "facontext.h"
#include "Parse.h"
#include "Window.h"
#include "Bitmap.h"
#include "Font.h"
#include "ThemeManager.h"
#include "Headlines.h"
#include "ForeignTheme.h"

typedef std::map<std::string, std::string, std::less<std::string> > AttrMap;

enum ControlTypeEnum
{
    eButtonControl,
    eTextControl,
    eSliderControl,
    eVSliderControl,
    eDialControl,
    eMultiStateControl,
    ePixFontControl,
    ePixTimeControl,
    ePixSliderControl,
    
    eUndefinedControl
};

class Theme : public Parse
{
    public:

               Theme(FAContext *context);
      virtual ~Theme(void);

      virtual Error SwitchWindow(const std::string &oWindowName); 
      virtual Error Run(Pos &oWindowPos); 
      virtual Error Close(void);
      virtual Error LoadTheme(std::string &oFile, std::string &oWindowName);
      virtual Error HandleControlMessage(std::string &oControlName, 
                                         ControlMessageEnum eMesg) = 0;
      virtual void  HandleKeystroke(unsigned char cKey) = 0;
      virtual bool  HandleMenuCommand(uint32_t uCommand) = 0;
      virtual void  HandleMouseWheelChange(int iSteps) = 0;
      virtual void  HandleMouseWheelClick(void) = 0;
      virtual void  VolumeChanged(void) = 0;
      virtual void  InitControls(void) = 0;
      virtual void  InitWindow(void) = 0;
      virtual void  PostWindowCreate(void);
      virtual void  DropFiles(std::vector<std::string> *pFileList) = 0;
      virtual void  SetDefaultFont(const std::string &oFont);

    protected:
     
      virtual void  SetThemePath(std::string &oPath);
      virtual Error BeginElement(std::string &oElement, AttrMap &oAttrMap);  
      virtual Error PCData(std::string &oData);
      virtual Error EndElement(std::string &oElement);
      void    ShowThemeCredits(void);
	  
      ThemeManager *m_pThemeMan;
      std::string        m_oThemePath;
      Window       *m_pWindow;
      FAContext    *m_pContext;
      Headlines    *m_pHeadlineGrabber;
      HeadlineInfo *m_pHeadlines, *m_pParsedHeadlines;

    private:

      Bitmap *FindBitmap(std::string &oName);
      Font   *FindFont(std::string &oName);
      Panel  *FindPanel(std::string &oName);
      Error   ParseState(std::string &oStateString, ControlStateEnum &eState);
      Error   ParseRect(std::string &oRectString, Rect &oRect);
      Error   ParseColor(std::string &oColorString, Color &oColor);
      Error   ParsePos(std::string &oPosString, Pos &oPos);
      void    ClearWindows(void);
      void    ClearBitmaps(void);
      void    ClearFonts(void);

      void    ConvertForeignFormat(std::string &oDir);
      ForeignTheme    *m_pForeignThemes;

      Window          *m_pCurrentWindow;
      Control         *m_pCurrentControl;
      Panel           *m_pCurrentPanel;

      std::vector<Window *> *m_pWindows, *m_pParsedWindows;
      std::vector<Bitmap *> *m_pBitmaps, *m_pParsedBitmaps;
      std::vector<Font *>   *m_pFonts, *m_pParsedFonts;
      std::vector<Panel *>   m_oPanels;
      bool              m_bReloadTheme, m_bReloadWindow, m_bThemeLoaded;
      bool              m_bPosDefined, m_bBitmapDefined;
      bool              m_bInfoDefined;
      std::string            m_oReloadWindow, m_oReloadFile;
      ControlTypeEnum   m_eCurrentControl;
      std::string            m_oDefaultFont;
      std::string            m_oThemeName, m_oThemeAuthor;
      std::string            m_oAuthorEMail, m_oAuthorWebPage;
      std::string            m_oSavedText, m_oMiscInfo;
      bool              m_bCreditsShown;
};

#endif

/* arch-tag: 02adb3cf-caa5-4634-b904-1c829d3ce4fc
   (do not change this comment) */
