#include <vector>

#include <time.h>

using namespace std;

#include "gtklibrarylist.h"
#include "gtkmusicbrowser.h"
#include "facontext.h"
#include "preferences.h"
#include "error.h"
#include "cataloginfo.h"

GTKLibrary::GTKLibraryList::GTKLibraryList(GTKLibrary *library)
{
	m_context = library->m_context;
	m_library = library;
	m_parent = NULL;
}

GTKLibrary::GTKLibraryList::~GTKLibraryList()
{
	//Delete Parent
	if(m_parent)
		delete m_parent;
}
void GTKLibrary::GTKLibraryList::SetParent(CatalogInfo *parent)
{
	//Delete Old Parent
	if(m_parent)
		delete m_parent;
	
	//Store New Parent And Refresh
	m_parent = parent;
	last_parent_change = time(NULL);
	Refresh();
}

void GTKLibrary::GTKLibraryList::Refresh()
{
	//Make Sure Parent Is Refreshed And Still In Library
	if(m_parent && m_parent->refresh_item_data()) {
		//Check We Have The Correct Amount Of Items
		while(m_listmodelMusic->children().size() < m_parent->child_count()) {
			//Add New Rows Until We Have Enoungh
			Gtk::TreeModel::Row new_row;
			new_row = *(m_listmodelMusic->append());
			init_row(new_row);
		}
		while(m_listmodelMusic->children().size() > m_parent->child_count()) {
			//Remove Rows Until We Don't Have Extra Ones
			m_listmodelMusic->erase(m_listmodelMusic->children()[m_listmodelMusic->children().size() - 1]);
		}
		
		//Refresh Visible
		scrolledwindow_changed_visible();
	} else
		Clear();
}

void GTKLibrary::GTKLibraryList::Clear()
{
	m_listmodelMusic->clear();
	
	//Delete Existing Parent
	if(m_parent)
		delete m_parent;
	m_parent = NULL;
}

void GTKLibrary::GTKLibraryList::selection_changed(Glib::RefPtr<Gtk::TreeView::Selection> selection)
{
	//Get Selected Rows And Put Information In Vectors For GTKLibrary
	std::vector<CatalogInfo *> catalog_infos;
	std::vector<Gtk::TreeModel::Path> selected_paths;
	std::vector<Gtk::TreeModel::Path>::iterator selected_path;
	
	//Go Through All Selected Rows
	selected_paths = selection->get_selected_rows();
	for(selected_path = selected_paths.begin(); selected_path != selected_paths.end(); selected_path++) {
		//Get Row Info
		CatalogInfo *TempInfo = m_parent->child_item((*selected_path).back());
		catalog_infos.push_back(TempInfo);
	}
	
	//Tell GTKLibrary Selected Rows
	m_library->set_selection(catalog_infos);
}

void GTKLibrary::GTKLibraryList::show_menu(guint button, guint32 time)
{
	if(m_listMusic.get_selection()->count_selected_rows() > 0) {
		//Refresh Library Selection
		selection_changed(m_listMusic.get_selection());
		
		//Items In List Can Always Be Removed - I Hope
		Gtk::Menu_Helpers::MenuList MenuItems = m_library->m_catalogPopupMenu.items();
		//Enable Remove Edit
		MenuItems[m_library->menu_loc_remove].set_sensitive(true);
		MenuItems[m_library->menu_loc_edit].set_sensitive(true);
		
		//Show Menu
		m_library->m_catalogPopupMenu.popup(button, time);
	}
}


void GTKLibrary::GTKLibraryList::row_activated(Gtk::TreeModel::Path RowPath)
{
	//Get Selected Row Data
	CatalogInfo *TempInfo = m_parent->child_item(RowPath.back());
	
	//Activate Row
	m_library->row_activated(TempInfo);
	
	delete TempInfo;
}
/* arch-tag: ba710967-0a37-4f0e-97a9-e93f775fdc22 */
