#ifndef _ZINFVOLUME_H
#define _ZINFVOLUME_H

#include <stdlib.h>
#include "utility.h"


/** Returns the volume for the internal soft mixer.
 *  This function returns the volume of the soft mixer.
 *  If not set before the default value 85 is delivered.
 *  Valid values for <var>left</var> and <var>right</var> are 0 till 100.
 */
ZINF_EXPORT void ZinfGetVolume(int32_t* left, int32_t* right);

/** Sets the value for the internal mixer.
 */
ZINF_EXPORT void ZinfSetVolume(int32_t left, int32_t right);

/** Modifies the buffer values.
 *  This function modifies the buffer values with the set volume.
 *  Note: The volume is logarithmic (sort of)
 */
ZINF_EXPORT void ZinfVolumize(short* buffer, int count);

#endif

/* arch-tag: af29eebc-d1c4-400b-a97e-fc13552d9807
   (do not change this comment) */
