/* mainview.cc
 * (c) 2002 Christian Tpp <c.toepp@gmx.de>
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <qapplication.h>
//#include "icons/icon.xpm"
#include "icons/logo.xpm"
#include "icons/ok.xpm"
#include "mainview.hh"
#include "about.hh"

#ifndef ZEIBERBUDE_RC
#define ZEIBERBUDE_RC "/home/toepp/Projects/zeiberbude2/config.xml"
#endif

int
main (int argc, char *argv[])
{
  QApplication a (argc, argv);
  QTranslator zb (0);
  zb.load (QString ("zb.") + QTextCodec::locale (),
	   "/usr/local/share/zeiberbude");
  a.installTranslator (&zb);
  a.setFont(QFont("Helvetica",10));
  mainview *view = new mainview ();
  a.setMainWidget (view);
  view->show ();
  view->update ();
  view->status->message ("Ready");
  return (a.exec ());
}

mainview::mainview ()
{
  QString version=VERSION;
  setCaption (QString("zeiberbude V%1") .arg(version));
  QPixmap icon (icon_xpm);
  setIcon (icon);
  initHead ();
  initStatus ();
  initConfig ();
  initTab ();
  initConfiguration ();
  initPark ();
  initHelp ();
  connect(zbCfg,SIGNAL(parkUser(zbuser *)),SLOT(slotNewParkUser(zbuser *)));
  connect(zbCfg,SIGNAL(compUser(zbuser *,QString,QString)),SLOT(slotNewCompUser(zbuser *,QString,QString)));
  if(zbCfg->readDb(&tarife,&prod,&prints) < 0)
      QMessageBox::information(this,"Zeiberbude",QString("Can not find your database file at %1") .arg(ZEIBERBUDE_DB));
  setMinimumSize (640, 400);
}

mainview::~mainview ()
{

}

void
mainview::initHead ()
{
  logo = QPixmap (logo_xpm);
  mainBar = new QToolBar (this);
  mainBar->setHorizontalStretchable (true);
  mainBar->setBackgroundColor (QColor (0, 0, 102));
  selectView = new QComboBox (mainBar);
  selectView->setMaximumWidth (130);
  selectView->insertItem (tr ("Select View"));
  selectView->insertItem (tr ("Standard View"));
  selectView->insertItem (tr ("Configuration"));
  selectView->insertItem (tr ("Show Help"));
  connect (selectView, SIGNAL (activated (int)), this,
	   SLOT (slotSelect (int)));
  selectView->setFixedHeight (20);
  icoOk = QPixmap (ok_xpm);
  selectOk = new QPushButton (mainBar);
  selectOk->setPixmap (icoOk);
  selectOk->setFixedSize (20, 20);
  selectOk->setEnabled (false);
  connect (selectOk, SIGNAL (clicked ()), this, SLOT (slotSelectOk ()));
  QLabel *space = new QLabel (mainBar);
  space->setBackgroundColor (QColor (0, 0, 102));
  pixLabel = new ZLabel (mainBar);
  pixLabel->setFixedSize (150, 30);
  pixLabel->setPixmap (logo);
  connect (pixLabel, SIGNAL (pressed ()), SLOT (slotAbout ()));
  setToolBarsMovable (false);
}

void
mainview::initPark ()
{
  parkBar =
    new QToolBar ("parkbar", this, QMainWindow::Right, true, "parkbar");
  parkBar->setVerticalStretchable (true);
  parkGroup = new QGroupBox (100, Vertical, parkBar, "parkgroup");
  parkGroup->setTitle (tr ("Parking"));
  parkGroup->addSpace (30);
  for (int i = 0; i < parkCount; i++)
    {
      parkView.
	append (new
		userparkview (parkGroup, tr ("Free"), &tarife, &groups,
			      &prod, &prints));
    }
  for(parkList::iterator pi = parkView.begin();pi != parkView.end(); ++pi)
    connect((*pi),SIGNAL(updateUser()),SLOT(updUser()));
  setMinimumHeight (90 + parkCount * 95);
}

void
mainview::initStatus ()
{
  status = new QStatusBar (this);
  status->message (tr ("loading..."));
}

void
mainview::initTab ()
{
  groupList::iterator gi;
  tabView =
    new QTabWidget (this, "tabview", WStyle_Customize | WStyle_NoBorder);
  setCentralWidget (tabView);
  maxItems = 0;
  // maximale anzahl der rechner pro gruppe
  for (gi = groups.begin (); gi != groups.end (); ++gi)
    if ((*gi).comp.count () > maxItems)
      maxItems = (*gi).comp.count ();
  // 150 ist die breite eines rechners
  // 450 ist die angenommene breite des widgets
  tabWidth = 450 / 150;
  tabHeight = maxItems / tabWidth;
  if ((maxItems % tabWidth) > 0)
    tabHeight++;
  // tab erzeugen
  compList::iterator ci;
  for (gi = groups.begin (); gi != groups.end (); ++gi)
    {
      (*gi).priv = new zbtabwidget (this);
      (*gi).grid = new QGrid (tabWidth, (*gi).priv);
//              //90 ist die hhe eines rechners
      (*gi).grid->setFixedSize ((tabWidth * 150) + (tabWidth - 1) * 5,
																tabHeight * 90);
      for (ci = (*gi).comp.begin (); ci != (*gi).comp.end (); ++ci)
				{
					(*ci).view = new computerview ((*gi).grid, (*ci).name);
					(*ci).view->setTarif (&tarife);
					(*ci).view->setProducts (&prod, &prints);
					(*ci).view->setCurency (curency);
					(*ci).view->setClientIp ((*ci).address);
					connect ((*ci).view,
									 SIGNAL (userDropped (QString, QString, QString)), this,
									 SLOT (slotUserDropped (QString, QString, QString)));
				}
      connect ((*gi).priv, SIGNAL (resized ()), this, SLOT (slotResize ()));
      tabView->addTab ((*gi).priv, (*gi).name);
    }
}

void
mainview::slotResize ()
{
  //qDebug("Resize");
  groupList::iterator gi;
  compList::iterator ci;
  QGrid *grd;
  int tabWidthOld = tabWidth;
  tabWidth = tabView->width () / 150;
  for (gi = groups.begin (); gi != groups.end (); ++gi)
    if ((*gi).comp.count () > maxItems)
      maxItems = (*gi).comp.count ();
  tabHeight = maxItems / tabWidth;
  if ((maxItems % tabWidth) > 0)
    tabHeight++;
  if (tabWidth != tabWidthOld)
    {
      tabHeight = maxItems / tabWidth;
      if ((maxItems % tabWidth) > 0)
	tabHeight++;

      for (gi = groups.begin (); gi != groups.end (); ++gi)
	{
	  tabHeight = (*gi).comp.count () / tabWidth;
	  if (((*gi).comp.count () % tabWidth) > 0)
	    tabHeight++;
	  grd = new QGrid (tabWidth, (*gi).priv);
	  grd->setFixedSize ((tabWidth * 150) + (tabWidth - 1) * 5,
			     tabHeight * 90);
	  for (ci = (*gi).comp.begin (); ci != (*gi).comp.end (); ++ci)
	    {
	      (*ci).view->reparent (grd, QPoint (0, 0), true);
	      (*ci).view->updateView ((*ci).name);
	      connect((*ci).view,SIGNAL(updateUser()),SLOT(updUser()));
	      connect((*ci).view,SIGNAL(userDropped(QString,QString,QString)),SLOT(slotUserDropped(QString,QString,QString)));
	    }
	  (*gi).grid->~QGrid ();
	  (*gi).grid = grd;
	  (*gi).grid->show ();
	  tabView->setTabLabel ((*gi).priv, (*gi).name);
	}
    }
}

void
mainview::initHelp ()
{
  cfgHelpBar =
    new QToolBar ("helpbar", this, QMainWindow::Left, true, "helpbar");
  cfgHelpBar->setVerticalStretchable (true);
  cfgHelpBox = new QGroupBox (100, Vertical, cfgHelpBar, "helpgroup");
  cfgHelpBox->setTitle (tr ("Help"));
  cfgHelp = new QTextBrowser (cfgHelpBox);
  cfgHelp->setMinimumWidth (150);
  cfgHelpBar->hide ();
}

void
mainview::initConfig ()
{
  zbCfg = new zbconfig (ZEIBERBUDE_RC);
  zbCfg->readConfig (&tarife, &prod, &groups, &company, &curency, &parkCount,
		     &prints);
}

void
mainview::initConfiguration ()
{
  if (access (ZEIBERBUDE_RC, W_OK) == 0)
    CfgWrite = true;
  else
    CfgWrite = false;

  cfgTab = new QTabWidget (this);
  /* company info */
  cmpWidget = new cfg_cmp (this, &company, CfgWrite);
  cfgTab->addTab (cmpWidget, tr ("Company"));
  /* tarife */
  tfWidget = new cfg_tf (this, &tarife, &groups, CfgWrite, &curency);
  cfgTab->addTab (tfWidget, tr ("Tarife"));
  // additional items
  adiWidget = new cfg_prod (this, &prod, &prints, CfgWrite, &curency);
  cfgTab->addTab (adiWidget, tr ("Products"));
  // clients
  cliWidget = new cfg_cli (this, &groups, CfgWrite, tabView);
  cliWidget->setData(&tarife,&prod,&prints,curency);
  connect (tfWidget, SIGNAL (curencyChanged (QString)), adiWidget,
	   SLOT (setCurency (QString)));
  connect (tfWidget, SIGNAL (curencyChanged (QString)), this,
	   SLOT (slotCurencyChanged (QString)));
  connect (cliWidget, SIGNAL (configChanged ()), this,
	   SLOT (slotConfigChanged ()));
  connect (adiWidget, SIGNAL (configChanged ()), this,
	   SLOT (slotConfigChanged ()));
  connect (tfWidget, SIGNAL (configChanged ()), this,
	   SLOT (slotConfigChanged ()));
  connect (cmpWidget, SIGNAL (configChanged ()), this,
	   SLOT (slotConfigChanged ()));
  cfgTab->addTab (cliWidget, tr ("Clients"));
  //end
  cfgTab->hide ();
}

void
mainview::viewConfiguration ()
{
  if (access (ZEIBERBUDE_RC, W_OK) == 0)
    CfgWrite = true;
  else
    CfgWrite = false;

  if (!CfgWrite)
    QMessageBox::information (this, tr ("Attention"),
			      tr
			      ("The configuration file is <b>read-only</b>!\nYou can only <b>view</b> the current configuration"));

  cmpWidget->setEnabled (CfgWrite);
  tfWidget->setEnabled (CfgWrite);
  adiWidget->setEnabled (CfgWrite);
  cliWidget->setEnabled (CfgWrite);
  parkBar->hide ();
  tabView->hide ();
  cfgTab->show ();
  setCentralWidget (cfgTab);
}

void
mainview::viewStandard ()
{
  cfgTab->hide ();
  parkBar->show ();
  tabView->show ();
  setCentralWidget (tabView);
}

void
mainview::slotSelect (int i)
{
  if (i > 0)
    selectOk->setEnabled (true);
  else
    selectOk->setEnabled (false);
}

void
mainview::slotSelectOk ()
{
  int i;
  if ((i = selectView->currentItem ()) > 0)
    {
      switch (i)
	{
	case 1:		// Standard View
	  viewStandard ();
	  break;
	case 2:		// Configuration View
	  viewConfiguration ();
	  break;
	case 3:		// show Help
	  if (selectView->text (i) == tr ("Show Help"))
	    {
	      cfgHelpBar->show ();
	      selectView->changeItem (tr ("Hide Help"), i);
	    }
	  else
	    {
	      cfgHelpBar->hide ();
	      selectView->changeItem (tr ("Show Help"), i);
	    }
	  break;
	}
    }
  selectView->setCurrentItem (0);
  selectOk->setEnabled (false);
}

void
mainview::slotConfigChanged ()
{
  compList::iterator ci;
  for (groupList::iterator gi = groups.begin (); gi != groups.end (); ++gi)
    {
      for (ci = (*gi).comp.begin (); ci != (*gi).comp.end (); ++ci)
	{
	  (*ci).view->setTarif (&tarife);
	  (*ci).view->setProducts (&prod, &prints);
	  (*ci).view->setCurency (curency);
	}
    }
  zbCfg->writeConfig (&tarife, &prod, &groups, &company, &curency,
		      &parkCount, &prints);
}

void
mainview::slotCurencyChanged (QString s)
{
  curency = s;
  slotConfigChanged ();
}

void
mainview::slotUserDropped (QString oldView, QString newView, QString type)
{
  if (type == "computerview")
    {
      compList::iterator oldCI;
      compList::iterator newCI;
      for (groupList::iterator oldGI = groups.begin ();
	   oldGI != groups.end (); ++oldGI)
	{
	  for (oldCI = (*oldGI).comp.begin (); oldCI != (*oldGI).comp.end ();
	       ++oldCI)
	    {
	      if ((*oldCI).name == oldView)
		{
		  for (groupList::iterator newGI = groups.begin ();
		       newGI != groups.end (); ++newGI)
		    {
		      for (newCI = (*newGI).comp.begin ();
			   newCI != (*newGI).comp.end (); ++newCI)
			{
			  if ((*newCI).name == newView)
			    {
			      (*newCI).view->zbUser = (*oldCI).view->zbUser;
			      (*newCI).view->setCurrentTarif ((*oldCI).view->
							      tarif ());
			      (*oldCI).view->setOff ();
			      (*newCI).view->setOn ((*oldCI).view->zbUser->
						    isOn ());
			      (*newCI).view->updateView ((*newCI).name +
							 " - " +
							 (*newCI).view->
							 zbUser->name ());
			      return;
			    }
			}
		    }
		}
	    }
	}
    }
  else if (type == "userparkview")
    {
      compList::iterator ci;
      groupList::iterator gi;
      for (parkList::iterator pi = parkView.begin (); pi != parkView.end ();
	   ++pi)
	{
	  if ((*pi)->zbUser->name () == oldView)
	    {
	      for (gi = groups.begin (); gi != groups.end (); ++gi)
		{
		  for (ci = (*gi).comp.begin (); ci != (*gi).comp.end ();
		       ++ci)
		    {
		      if ((*ci).name == newView)
			{
			  (*ci).view->zbUser = (*pi)->zbUser;
			  (*ci).view->setOn (false);
			  (*ci).view->updateView ((*ci).name + " - " +
						  (*ci).view->zbUser->
						  name ());
			  (*pi)->setOff ();
			  return;
			}
		    }
		}
	    }
	}
    }
}

void
mainview::slotAbout ()
{
  about *abt = new about(this,"about box",true);
  abt->exec();
  //  QString msg =
  //tr
  //("zeiberbude V%1\nLicensed under GNU General Public License\n(c) 2002 Christian Toepp <c.toepp@gmx.de>\n\nGerman Translation Christian Toepp") .arg(VERSION);
  //QMessageBox::about (this, "About zeiberbude", msg);
}

void
mainview::slotNewCompUser(zbuser *usr,QString group, QString client)
{
  compList::iterator ci;
  groupList::iterator gi;
  for(gi = groups.begin(); gi != groups.end(); ++gi)
    if((*gi).name == group)
      for(ci = (*gi).comp.begin(); ci != (*gi).comp.end(); ++ci)
	if((*ci).name == client)
	  {
	    (*ci).view->zbUser = usr;
	    (*ci).view->setName(usr->name());
	    (*ci).view->setOn(false);
	    return;
	  }
}

void
mainview::slotNewParkUser(zbuser *usr)
{
  for(parkList::iterator pi = parkView.begin(); pi != parkView.end(); ++pi)
    if(!(*pi)->isOn())
      {
	(*pi)->zbUser = usr;
	(*pi)->setOn();
	return;
      }
}

void
mainview::updUser(){
  //zbCfg->writeDb(&parkView,&groups);
}
