#ifndef	SLIC_H
#define	SLIC_H
/*
 * Written by Oron Peled <oron@actcom.co.il>
 * Copyright (C) 2004-2006, Xorcom
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "xdefs.h"

/*------------------------------ SLIC Data Structures ----------------------*/

struct slic_reg_d {		/* SLIC Register Direct Read/Write */
	byte	reg_num:7;
	byte	read:1;
	byte	reg_data;
} __attribute__((packed));

struct slic_reg_iw {		/* SLIC Register Indirect-Write */
	struct slic_reg_d	iw_data_low;
	struct slic_reg_d	iw_data_high;
	struct slic_reg_d	iw_reg;
} __attribute__((packed));

struct slic_reg_ir {		/* SLIC Register Indirect-Read */
	struct slic_reg_d	ir_reg;
} __attribute__((packed));

typedef struct slic_cmd {
	xpp_line_t	lines;
	byte		bytes;
	union {
		struct slic_reg_d	direct;
		struct slic_reg_iw	indirect_write;
		struct slic_reg_ir	indirect_read;
	} content;
} __attribute__((packed)) slic_cmd_t;

typedef	struct slic_reply {
	byte	size;
	byte	reg_num:7;
	byte	indirect:1;
	byte	data_low;
	byte	data_high;
} __attribute__((packed)) slic_reply_t;

#define	SLIC_REG_INIT(slic_reg, reading, num, data)	\
				do {	\
					(slic_reg)->read = reading;	\
					(slic_reg)->reg_num = num;	\
					(slic_reg)->reg_data = data;	\
				} while(0);


/*------------------------------ SLIC Initializers -------------------------*/

int slic_cmd_direct_write(slic_cmd_t *sc, xpp_line_t lines, byte reg, byte data);
int slic_cmd_direct_read(slic_cmd_t *sc, xpp_line_t lines, byte reg);
int slic_cmd_indirect_write(slic_cmd_t *sc, xpp_line_t lines, byte reg, byte data_low, byte data_high);
int slic_cmd_indirect_read(slic_cmd_t *sc, xpp_line_t lines, byte reg);
void dump_slic_cmd(const char msg[], slic_cmd_t *sc);
int run_initialize_registers(xpd_t *xpd);


#endif	/* SLIC_H */
