/** 
 *  Yudit Unicode Editor Source File
 *
 *  GNU Copyright (C) 2002  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2001  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2000  Gaspar Sinai <gsinai@yudit.org>  
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdlib.h>
#include "stoolkit/SBMap.h"
#include "stoolkit/SUtil.h"
#include "stoolkit/SString.h"
#include "stoolkit/SIO.h"
#include "windows.h"

int
main (int argc, char* argv[])
{
  SString str(getPrefix());
  fprintf (stderr, "Prefix %u [%*.*s]\n", str.size(), SSARGS(str));
  //SPipe pipe ("winhelp.exe c:\\doc\\winapi\\win32.hlp");
  //SString gv = "c:\\Program Files\\gv\\gv.exe";

  SString gv = "C:\\Ghostgum\\gsview\\gsview32.exe";
  SString mt = "D:\\Yudit\\yudit-2.5.beta14\\mytool\\mytool.exe";

  SFile f (mt);
  if (mt.size() < 0) 
  {
     fprintf (stderr, "Can not open: [%*.*s]\n", SSARGS(mt));
     return (1);
  }

  ///gv = "cat > c:\\tmp\\aa.tmp";
  //fprintf (stderr, "opening: [%*.*s]\n", SSARGS(gv));
  gv.insert (0, "\"");
  gv.append ("\"");
  mt.insert (0, "\"");
  mt.append ("\"");
  mt.append (" -pipecmd ");
  mt.append (gv);
  fprintf (stderr, "opening: [%*.*s]\n", SSARGS(mt));

  SString is = "D:\\aa.ps";
  SFile in (is);
  if (in.size() <=0)
  {
     fprintf (stderr, "Can not open: [%*.*s]\n", SSARGS(is));
     return (1);
  }
  fprintf (stderr, "pipeing: [%*.*s]\n", SSARGS(gv));
  SFileImage im = in.getFileImage ();
  SPipe pipe (mt);
  {
    SOutputStream os = pipe.getOutputStream ();
    SWriter writer (os);
    SString ss (im.array(), im.size());
    writer.write (ss);
    writer.close ();
  }
  return pipe.wait ();
   
#if TEST_DIR
  SDir dir;
  SString  str = dir.getUnixName ();
  fprintf (stderr, "Dir=[%*.*s] exists=%d readabe=%d\n",  
    SSARGS(str), (int)dir.exists() , (int) dir.readable());
  dir.cd ("../../..");
  str = dir.getUnixName ();
  fprintf (stderr, "Dir=[%*.*s] exists=%d readabe=%d\n",  
    SSARGS(str), (int)dir.exists() , (int) dir.readable());
  SStringVector list =  dir.list(SDir::SE_DIR);
  SString l = list.join(" ");
  fprintf (stderr, "List=[%*.*s]\n",  SSARGS(l));
  dir.cd (list[0]);
  str = dir.getUnixName ();
  fprintf (stderr, "Dir=[%*.*s] exists=%d readabe=%d\n",  
    SSARGS(str), (int)dir.exists() , (int) dir.readable());
#endif //TEST_DIR
  
  return 0;
  //SBMap map;
  //SFile file ("/home/gsinai/a.my");
  //SFileImage im = file.getFileImage();
  //map.setFileImage (im);
  //return 0;
}
