/** 
 *  Yudit Unicode Editor Source File
 *
 *  GNU Copyright (C) 2002  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2001  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2000  Gaspar Sinai <gsinai@yudit.org>  
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 


#include "stoolkit/SEvent.h"
#include "stoolkit/SExcept.h"
#include "stoolkit/SIOStream.h"
#include <stdio.h>

class STimerTarget: public SEventTarget
{
public:
  STimerTarget (){}
  ~STimerTarget (){}
  virtual bool timeout (const SEventSource* s);
};

class SIOTarget: public SEventTarget
{
public:
  SIOTarget () {}
  ~SIOTarget (){}
  virtual bool read (const SEventSource* s, const SString& m);
};

class SIOSource : public SEventSource
{
public:
  SIOSource (int fd) : SEventSource (FILE, fd){}
  ~SIOSource () {}
};

bool
STimerTarget::timeout (const SEventSource* s)
{
  static int c=1;
  fprintf (stderr, "Timeout [%d]\n", c++);
  //if  (c==11) return false;
  return true;
}

bool
SIOTarget::read (const SEventSource* s, const SString& m)
{
  static int c=1;
  fprintf (stderr, "IO [%*.*s]\n", SSARGS(m));
  if (c++==4)
  {
    //SEventHandler::remove (this);
    fprintf (stderr, "Bye [%d]\n", c);
    return false;
  }
  return true;
}

bool readDebug(SReader *r, SString* nd, const SStringVector& sep, const SStringVector& accept, const SStringVector& reject);

int test_tcp();

/**
 * @author: Gaspar Sinai <gsinai@yudit.org>
 * @version: 2000-04-23
 */
main ()
{
 try 
 {
   STimerTarget* target = new STimerTarget();
   STimer* timer = STimer::newTimer(500, target);
   SIOSource* iosrc = new SIOSource (0);
   SIOTarget* iotar = new SIOTarget ();
   SEventHandler::addInput(iosrc, iotar);
test_tcp();
   SEventHandler::start ();

   fprintf (stderr, "Loop exited..\n");
   delete target;
   delete timer;
 }
 catch (const SExcept& e)
 {
   fprintf (stderr, "Error:%s\n", e.toString());
 }
 return 0;
}

int 
test_tcp()
{
   //SSocket s("metalab.unc.edu", 21);
   SSocket s("localhost", 21);
   SString user("anonymous");
   SString pass("a@b.com");
   SInputStream i = s.getInputStream();
   if (!i.isOK())
   {
     fprintf (stderr, "can not open socket..\n");
     return -1;
   }
   SOutputStream o = s.getOutputStream();
   if (!o.isOK())
   {
     fprintf (stderr, "can not open socket..\n");
     return -1;
   }
   SStringVector sep("\r\n,\n", ",");
   SReader r(i, sep);
   SWriter w(o);
   SString nd;
   fprintf (stderr, "SOCKET R%ld W%ld\n", i.getId(), o.getId());
   if (!readDebug(&r, &nd, sep, "220", "502,500")) return -1;
   w.write((SString)"USER " << user << "\r\n");
   if (!readDebug(&r, &nd, sep, "331", "502,500")) return -1;
    
   w.write ((SString)"PASS " <<pass <<"\r\n");
   if (!readDebug(&r, &nd, sep, "230", "530,502,500")) return -1;
   w.write ((SString)"HELP\r\n");
   if (!readDebug(&r, &nd, sep, "214", "530,502,500")) return -1;
   //w.write ((SString)"MAKKA\r\n");
   //if (!readDebug(&r, &nd, sep, "214", "530,502")) return -1;
   w.write ((SString)"QUIT\r\n");
   if (!readDebug(&r, &nd, sep, "221", "530,502,500")) return -1;
   if (!readDebug(&r, &nd, sep, "221", "530,502,500")) return -1;
   //for (int i=0; i<100; i++) w.write ((SString)"QUIT\r\n");
   if (!r.isOK()) return -1;
   if (!w.isOK()) return -1;
   if (!o.close()) return -1;
   return 1;
}

bool
readDebug(SReader *r, SString* nd, const SStringVector& sep, const SStringVector& accept, const SStringVector& reject)
{
  while (true)
  {
    bool status = r->read (nd);
    // EOF
    if (nd->size()==0) return true;
    if (status ==false)
    {
      fprintf (stderr, "Error Reading Socket\n");
      return false;
    }
    sep.trim (nd);
    fprintf (stderr, "Read: '%*.*s' \n", SSARGS(nd[0]));
    for (unsigned int i=0; i<accept.size(); i++)
    {
      if (nd->find(accept[i])==0) return true;
    }
    for (unsigned int j=0; j<reject.size(); j++)
    {
      if (nd->find(reject[j])==0) return false;
    }
  }
  return false;
}
