/*
 * Program:     $RCSfile: log.c,v $  $Revision: 4.5 $
 *
 * Purpose:     Log facility of internet "youbin" service.
 *
 * Author:      K.Agusa     agusa@nuie.nagoya-u.ac.jp
 *              S.Yamamoto  yamamoto@nuie.nagoya-u.ac.jp
 *
 * Date:        1993/12/27
 * Modified:    $Date: 1996/05/07 07:22:48 $
 *
 * Copyright:   K.Agusa and S.Yamamoto  1993 - 1996
 *
 * The X Consortium, and any party obtaining a copy of these files from
 * the X Consortium, directly or indirectly, is granted, free of charge,
 * a full and unrestricted irrevocable, world-wide, paid up, royalty-free,
 * nonexclusive right and license to deal in this software and documentation
 * files (the "Software"), including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons who receive copies from any such
 * party to do so. This license includes without limitation a license to do
 * the foregoing actions under any patents of the party supplying this
 * software to the X Consortium.
 */

#ifndef lint
static char rcsid[] =
    "$Id: log.c,v 4.5 1996/05/07 07:22:48 yamamoto Exp yamamoto $";
#endif

#include <sys/types.h>
#include <netinet/in.h>
#include <stdio.h>

#include "youbin.h"
#include "server.h"

/*
 * Variable argument list.
 *
 * USE_STDARG:  Use ANSI routines.
 * USE_VARARGS  Use UNIX's native routines.
 */

#ifdef USE_STDARG 

#include <stdarg.h>
#define VARARGS_PROTO(func, firstArg, type)     func(type firstArg, ...)
#define VA_START(argsPtr, firstArg)             va_start(argsPtr, firstArg)
#define VA_1ST_ARG(argsPtr, firstArg, type)     firstArg

#else /* USE_VARARGS */

#include <varargs.h>
#define VARARGS_PROTO(func, firstArg, type)     func(va_alist) va_dcl
#define VA_START(argsPtr, firstArg)             va_start(argsPtr)
#define VA_1ST_ARG(argsPtr, firstArg, type)     va_arg(argsPtr, type)

#endif /* USE_VARARGS */

/*
 * Logging system messages.
 */

#ifdef SYSLOG
#include <syslog.h>
#endif

#ifndef SYSLOG_FACILITY
#define SYSLOG_FACILITY     LOG_DAEMON
#endif

#ifndef LOG_DEBUG
#define LOG_DEBUG           (-1)    /* Dummy. */
#endif

#ifndef LOG_WARNING
#define LOG_WARNING         (-1)    /* Dummy. */
#endif

#ifndef LOG_INFO
#define LOG_INFO            (-1)    /* Dummy. */
#endif

#ifndef LOG_ERR
#define LOG_ERR             (-1)    /* Dummy. */
#endif

static int  flag_syslog = ON;       /* Always true. */
static int  flag_console = ON;      /* Always true. */

extern int          errno;

/* 
 * Dirty quick hack on JCC JPower JCC_BSD+ 1.0 1996/05/07.
 */

#if !(defined(bsd4_4) && defined(powerpc))
#ifndef linux
#ifndef __FreeBSD__
extern char         *sys_errlist[];
#endif
#endif
#endif

/*
 * Initialize.
 */ 

void
init_log()
{
#ifdef SYSLOG
    openlog(prog_name, (LOG_CONS | LOG_PID), SYSLOG_FACILITY);
#endif
}

/*
 * Top level functions.
 */ 

void
VARARGS_PROTO(debug_log, va_args, char *)
{
    char        buff_log[LOG_LEN + 1];
    va_list     args;
    
    if (debug_mode) {
        VA_START(args, va_args);
        vsprintf(buff_log, VA_1ST_ARG(args, va_args, char *), args);
        va_end(args);
        output_log(LOG_DEBUG, buff_log);
    }
}

void
VARARGS_PROTO(warn_log, va_args, char *)
{
    char        buff_log[LOG_LEN + 1];
    va_list     args;
    
    VA_START(args, va_args);
    vsprintf(buff_log, VA_1ST_ARG(args, va_args, char *), args);
    va_end(args);
    output_log(LOG_WARNING, buff_log);
}

void
VARARGS_PROTO(info_log, va_args, char *)
{
    char        buff_log[LOG_LEN + 1];
    va_list     args;
    
    VA_START(args, va_args);
    vsprintf(buff_log, VA_1ST_ARG(args, va_args, char *), args);
    va_end(args);
    output_log(LOG_INFO, buff_log);
}

void
VARARGS_PROTO(error_log, va_args, char *)
{
    char        buff_log[LOG_LEN + 1];
    va_list     args;
    
    VA_START(args, va_args);
    vsprintf(buff_log, VA_1ST_ARG(args, va_args, char *), args);
    va_end(args);
    output_log(LOG_ERR, buff_log);
}

void
VARARGS_PROTO(trace, va_args, char *)
{
    /* Output trace message to syslog with LOG_INFO level. */
    char        buff_log[LOG_LEN + 1];
    va_list     args;
    
    if (trace_mode) {
        VA_START(args, va_args);
        vsprintf(buff_log, VA_1ST_ARG(args, va_args, char *), args);
        va_end(args);
        output_log(LOG_INFO, buff_log);
    }
}

void
sys_error_log(mess)
char    *mess;
{
    /* Output system error messages to syslog. */
    char        buff_log[LOG_LEN + 1];

    sprintf(buff_log, "%s: %s\n", mess, sys_errlist[errno]);
    output_log(LOG_ERR, buff_log);
}

/*
 * Subroutines.
 */

void
output_log(syslog_level, mess) 
int         syslog_level; 
char        *mess;
{
#ifdef SYSLOG
    if (flag_syslog) {
        syslog(syslog_level, mess);
    }
#endif /* SYSLOG */

    if (flag_console) {
        fprintf(stderr, "%s: %s", prog_name, mess); 
    }
}
