/*
 *  ys_caller.c
 */

#include <errno.h>
#include <stdio.h>

#include <windows.h>
#include <time.h>
#include <Winsock.h>
#include "youbin.h"
#include "w_youbin.h"
#include "userdata.h"

/*
 * Global variables.
 */

char	user_name[USER_NAME_LEN + 1];	    /* User name.   */
char	*prog_name;					    /* This program name.
*/
char	print_flag;					/* Print mode.	*/
char	server_name[MAXHOSTNAMELEN + 1];    /* Server name. */

char	*cr;
FILE	*input, *output;			    /* Pipe, stdin or stdout. */

/*
 * NONE:	Nothing is printed. ( Can't happen )
 * SIZE_DATE:	size+' '+date
 * FOR_SHELL:	Mail_First, Mail_Appended, Cleared
 * NOTIFY:	"New mail has arrived" is printed.
 * MESS_REQ:	Print some header fields and top of body are printed.
 */
enum	{NONE, SIZE_DATE, FOR_SHELL, NOTIFY, MESS_REQ} print_mode = NOTIFY;

/* Mode flag. */
int	debug_mode = OFF;

int	ppid;				    /* Parent process id */
int	exitcode = EXIT_SUCCESS;

/*
 * External variables.
 */

extern int	errno;

/*
 * Local functions.
 */

char		*ctime();

int		youbin_sub();
void		init();
void		callback();
/*
char	*head_list = "";
char	*password = "";
char	*auth = "";
*/
char auth[8] = "";
char password[16] = "";
char head_list[64] = "";

void set_w_message(char *mess);
HWND this_hwnd;

void ys_caller(HWND *hwnd)
{
    int     result;
    int     pwlen;

	this_hwnd = *hwnd;
	get_server_name(server_name);
	get_auth(auth);
	if( check_auth() == AUTH_ROK ){
		get_head_list(head_list);
	}else if( check_auth() == AUTH_PLAIN ){
		get_password(password);
		get_head_list(head_list);
	}

    init();

    if( pwlen = strlen( password )) pwlen++;

    result = youbin_sub(server_name,auth,password,pwlen,head_list,0,callback,-1);
    debug("%s: Exit code: %d\n", prog_name, result);
	MessageBox(this_hwnd, "ФȤ³˼Ԥޤ\nǧƺƵưƲ", "³顼", MB_OK);
}

void
init(argc, argv)
int	argc;
char	**argv;
{
    /* For future extention, set streams. */
	input = stdin;
	output = stdout;

    /* Get local host name. */
    if (server_name[0] == '\0') {
	gethostname(server_name, sizeof(server_name));
    }

    cr = "\r";
}

/*
 * Callback Function
 */

void
callback(size, date, mess)
int	    size;
time_t	    date;
/* check ctime() */
/* int	       date; */
char	    *mess;
{
    static int	    saved_size = 0;
    static time_t   saved_date = 0;
    int 	    prev_size;

    if ( size == saved_size && date == saved_date ) {
						/*  Spool has not changed. */
	    return;
    }

    prev_size = saved_size;
    saved_date = date;				/* Remember the values. */
    saved_size = size;

	if(size == 0){
			SendMessage(this_hwnd, W_YOUBIN_NONE_MAIL,
				(WPARAM) 0, (LPARAM) 0);
	}

    switch( print_mode ){			/* print out messages	*/
    case FOR_SHELL:
    case NOTIFY:
    case MESS_REQ:  /* Do not need to distinguish NOTIFY and MESS_REQ. */
		if( size != 0 ){
			set_w_message(mess);
			SendMessage(this_hwnd, W_YOUBIN_HAVE_MAIL,
				(WPARAM) 0, (LPARAM) 0);
		}
	break;
    }

}
