#include <windows.h>
#include <mmsystem.h>
#include "resource.h"
#include "w_youbin.h"

#define TIMER_ID	100

void w_youbin_init_option(HINSTANCE hInstance);
void reg_write_win_disp(int disp, int disp_top);
void reg_write_option();
BOOL reg_read_win_disp(int *disp, int *disp_top);
int get_sound_state();
void get_sound_filename(char *filename);

HBITMAP hbit_none;
HBITMAP hbit_have;
HICON hIcon_none;
HICON hIcon_have1;
HICON hIcon_have2;
NOTIFYICONDATA g_nid;

enum	{NONE, HAVE} mail_state = NONE;
enum	{WINDOW, TRAY} show_state = WINDOW;
enum	{NORMAL, TOP} win_disp = NORMAL;

void w_youbin_init(HWND hwnd, HINSTANCE hInstance)
{
	int ss, wd;
	hbit_none = LoadBitmap(hInstance, "YOUBIN_EMPTY");
	hbit_have = LoadBitmap(hInstance, "YOUBIN_FULL");

	hIcon_none = (HICON)LoadImage( hInstance,
						MAKEINTRESOURCE(WYOU_SICON_N),
						IMAGE_ICON, 16, 16, 0);
	hIcon_have1 = (HICON)LoadImage( hInstance,
						MAKEINTRESOURCE(WYOU_SICON_M1),
						IMAGE_ICON, 16, 16, 0);
	hIcon_have2 = (HICON)LoadImage( hInstance,
						MAKEINTRESOURCE(WYOU_SICON_M2),
						IMAGE_ICON, 16, 16, 0);

	/* ƥȥ쥤˥ɲ */
	ZeroMemory( &g_nid, sizeof( NOTIFYICONDATA ));
	g_nid.cbSize			= sizeof( NOTIFYICONDATA);
	g_nid.hWnd				= hwnd;
	g_nid.uID				= TRAY_ID;
	g_nid.uFlags			= NIF_ICON | NIF_MESSAGE;
	g_nid.uCallbackMessage	= NOTIFY_TRAYICON;
	g_nid.hIcon				= hIcon_none;

	w_youbin_init_option(hInstance);
	if( reg_read_win_disp(&ss, &wd) ){
		if(wd == NORMAL){
			win_disp = NORMAL;
			SetWindowPos(hwnd,HWND_NOTOPMOST,0,0,0,0,SWP_NOMOVE | SWP_NOSIZE);
		}else{
			win_disp = TOP;
			SetWindowPos(hwnd,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE | SWP_NOSIZE);
		}
		if(ss == TRAY){
			show_state = TRAY;
			g_nid.hIcon = hIcon_none;
			Shell_NotifyIcon( NIM_ADD, &g_nid );
			ShowWindow(hwnd, SW_HIDE);
		}else{
			show_state = WINDOW;
			Shell_NotifyIcon( NIM_DELETE, &g_nid );
			ShowWindow(hwnd, SW_SHOWNORMAL);
		}
	}else{
		show_state = WINDOW;
		Shell_NotifyIcon( NIM_DELETE, &g_nid );
		win_disp = NORMAL;
		SetWindowPos(hwnd,HWND_NOTOPMOST,0,0,0,0,SWP_NOMOVE | SWP_NOSIZE);
		ShowWindow(hwnd, SW_SHOWNORMAL);
	}
	return;
}

void w_youbin_exit(HWND hwnd)
{
	reg_write_option();
	reg_write_win_disp(show_state, win_disp);
	if(show_state == TRAY){
		if(mail_state == HAVE){
			KillTimer( hwnd, TIMER_ID );
		}
		Shell_NotifyIcon( NIM_DELETE, &g_nid );
	}
	return;
}

void w_repaint(HWND hwnd)
{
	HDC DC, memDC;
	PAINTSTRUCT paintstruct;
	int px;

	px = 60 - 36 - GetSystemMetrics(SM_CXEDGE)
		- GetSystemMetrics(SM_CXBORDER);
	DC = BeginPaint(hwnd, &paintstruct);
	memDC = CreateCompatibleDC(DC);
	if(mail_state == NONE){
		SelectObject(memDC, hbit_none);
	}else{
		SelectObject(memDC, hbit_have);
	}
	BitBlt(DC, px, 0, 72, 72,
			memDC, 0, 0, SRCCOPY);
	EndPaint(hwnd, &paintstruct);
	DeleteDC(memDC);

	return;
}

void set_mailarrive(HWND hwnd)
{
	char sound_filename[256]="";
	get_sound_filename(sound_filename);
	if(mail_state == NONE){
		mail_state = HAVE;
		if(get_sound_state()){
		    sndPlaySound(sound_filename,SND_ASYNC);
		}
		if(show_state == WINDOW){
			InvalidateRect(hwnd, NULL, TRUE);
		}else{
			SetTimer( hwnd, TIMER_ID, 500, NULL);
		}
	}else{
		if(get_sound_state()){
		    sndPlaySound(sound_filename,SND_ASYNC);
		}
	}
}

void reset_mailarrive(HWND hwnd)
{
	if(mail_state != NONE){
		mail_state = NONE;
		if(show_state == WINDOW){
			InvalidateRect(hwnd, NULL, TRUE);
		}else{
			KillTimer( hwnd, TIMER_ID );
			g_nid.hIcon = hIcon_none;
			Shell_NotifyIcon( NIM_MODIFY , &g_nid );
		}
	}
}

void w_disp_win(HWND hwnd)
{
	if(show_state == WINDOW) return;

	show_state = WINDOW;
	if(mail_state == HAVE){
		KillTimer( hwnd, TIMER_ID );
	}
	Shell_NotifyIcon( NIM_DELETE, &g_nid );
	ShowWindow(hwnd, SW_SHOWNORMAL);
	return;
}

void w_disp_tsk(HWND hwnd)
{
	if(show_state == TRAY) return;

	show_state = TRAY;
	g_nid.hIcon = hIcon_none;
	Shell_NotifyIcon( NIM_ADD, &g_nid );
	if(mail_state == HAVE){
		SetTimer( hwnd, TIMER_ID, 500, NULL);
	}
	ShowWindow(hwnd, SW_HIDE);
	return;
}

void w_flash_icon()
{
	if( g_nid.hIcon == hIcon_have1 ){
		g_nid.hIcon = hIcon_have2;
	}else{
		g_nid.hIcon = hIcon_have1;
	}
	Shell_NotifyIcon( NIM_MODIFY , &g_nid );
	return;
}

void change_disp_win_top(HWND hwnd)
{
	if(win_disp == TOP){
		win_disp = NORMAL;
		SetWindowPos(hwnd,HWND_NOTOPMOST,0,0,0,0,SWP_NOMOVE | SWP_NOSIZE);
	}else{
		win_disp = TOP;
		SetWindowPos(hwnd,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE | SWP_NOSIZE);
	}
}

int check_disp_win_top()
{
	if(win_disp == TOP)
		return 1;
	return 0;
}
