/*
 * ugetc.c -- $Id$
 * play interface for non-event-driven programs
 * -- incompatible with stdinit.c functions
 *
 * Copyright (c) 1998.  See accompanying LEGAL file for details.
 */
#ifndef _POSIX_SOURCE
/* to get fileno declared */
#define _POSIX_SOURCE 1
#endif

#include "config.h"

#include "playu.h"
#include <stdio.h>
#include "ugetc.h"

static void u_fd0_ready(void *c);
static int u_get(char *s, int size, FILE *stream);

static FILE *u_stream = 0;
static int u_fd0_init = 0;
/* ARGSUSED */
static
void u_fd0_ready(void *c)
{
  u_stream = c;
}

int
u_getc(FILE *stream)
{
  return u_get((char *)0, 0, stream);
}

char *
u_fgets(char *s, int size, FILE *stream)
{
  return u_get(s, size, stream)? s : 0;
}

static int
u_get(char *s, int size, FILE *stream)
{
  if (!u_fd0_init) {
    u_event_src(fileno(stream), &u_fd0_ready, stream);
    u_fd0_init = 1;
  }

  while (!u_stream) u_waiter(1);

  stream = u_stream;
  u_stream = 0;
  if (!s) return getc(stream);

  return fgets(s, size, stream)!=0;
}

void
u_pending_events(void)
{
  if (u_fd0_init) {
    /* do not handle events on stdin -- just everything else */
    u_event_src(0, (void (*)(void *c))0, stdin);
    u_fd0_init = 0;
  }
  while (u_waiter(0));
}
