/*
			   Confirmation Dialog
 */

#ifndef CDIALOG_H
#define CDIALOG_H

#include <gtk/gtk.h>

/*
 *	Response codes:
 */
#define CDIALOG_RESPONSE_NOT_AVAILABLE	-1
#define CDIALOG_RESPONSE_NO		0
#define CDIALOG_RESPONSE_YES		1
#define CDIALOG_RESPONSE_YES_TO_ALL	2
#define CDIALOG_RESPONSE_CANCEL		3
#define CDIALOG_RESPONSE_OK		4
#define CDIALOG_RESPONSE_HELP		5


/*
 *	Message icon codes, specifies the icon displayed next to
 *	the message:
 */
#define CDIALOG_ICON_USER_DEFINED       -4
#define CDIALOG_ICON_INFO	0
#define CDIALOG_ICON_WARNING	1
#define CDIALOG_ICON_ERROR	2
#define CDIALOG_ICON_QUESTION	3
#define CDIALOG_ICON_HELP	4
#define CDIALOG_ICON_WIZARD	5	/* Wand. */
#define CDIALOG_ICON_SEARCH	6	/* Magnifying glass. */
#define CDIALOG_ICON_SECURITY	7	/* Padlock with key. */
#define CDIALOG_ICON_PRINTER	8
#define CDIALOG_ICON_SPEAKER	9
#define CDIALOG_ICON_BULB	10
#define CDIALOG_ICON_POWER	11	/* Battery and A/C plug. */
#define CDIALOG_ICON_LINUX	12	/* Tux the Linux penguin. */
#define CDIALOG_ICON_TERMINAL	13
#define CDIALOG_ICON_SETTINGS	14	/* Gears. */
#define CDIALOG_ICON_TOOLS	15
#define CDIALOG_ICON_MONITOR	16
#define CDIALOG_ICON_CLIPBOARD_EMPTY	17
#define CDIALOG_ICON_CLIPBOARD_FULL	18

/* 50 - 69 are object type icons */
#define CDIALOG_ICON_FILE	50
#define CDIALOG_ICON_FOLDER_CLOSER	51
#define CDIALOG_ICON_FOLDER_OPENED	52
#define CDIALOG_ICON_LINK	53
#define CDIALOG_ICON_PIPE	54
#define CDIALOG_ICON_DEVICE	55
#define CDIALOG_ICON_DEVICE_BLOCK	56
#define CDIALOG_ICON_DEVICE_CHARACTER	57
#define CDIALOG_ICON_SOCKET	58
/* 70 - 89 are file op icons */
#define CDIALOG_ICON_FILE_MOVE	71
#define CDIALOG_ICON_FILE_COPY	72
/* 90 to 99 are reserved */
/* 100 - 129 are net icons */
#define CDIALOG_ICON_PLANET	100
#define CDIALOG_ICON_FTP	101
#define CDIALOG_ICON_CHAT	102
#define CDIALOG_ICON_FILE_WWW	103


/*
 *	Button flags:
 */
#define CDIALOG_BTNFLAG_OK		(1 << 0)
#define CDIALOG_BTNFLAG_YES		(1 << 1)
#define CDIALOG_BTNFLAG_YES_TO_ALL	(1 << 2)
#define CDIALOG_BTNFLAG_NO		(1 << 3)
#define CDIALOG_BTNFLAG_CANCEL		(1 << 4)
#define CDIALOG_BTNFLAG_IGNORE		(1 << 5)
#define CDIALOG_BTNFLAG_RETRY		(1 << 6)
#define CDIALOG_BTNFLAG_ABORT		(1 << 7)
#define CDIALOG_BTNFLAG_HELP		(1 << 8)


extern gint CDialogInit(void);
extern void CDialogSetTransientFor(GtkWidget *w);
extern gboolean CDialogIsQuery(void);
extern void CDialogBreakQuery(void);
extern gint CDialogGetResponse(
	const gchar *title,
	const gchar *message,
	const gchar *explaination,
	gint icon_code,
	guint show_buttons,		/* Any of CDIALOG_BTNFLAG_*. */
	guint default_button		/* One of CDIALOG_BTNFLAG_*. */
);
extern gint CDialogGetResponseIconData(
	const gchar *title,
	const gchar *message,
	const gchar *explaination,
	guint8 **icon_data,
	guint show_buttons,             /* Any of CDIALOG_BTNFLAG_*. */
	guint default_button            /* One of CDIALOG_BTNFLAG_*. */
);
extern gint CDialogGetResponseFile(
	const gchar *title,
	const gchar *message_path,	/* File. */
	const gchar *explaination,
	gint icon_code,
	guint show_buttons,             /* Any of CDIALOG_BTNFLAG_*. */
	guint default_button            /* One of CDIALOG_BTNFLAG_*. */
);
extern void CDialogMap(void);
extern void CDialogUnmap(void);
extern void CDialogShutdown(void);

#endif	/* CDIALOG_H */
