/*
                          Page Stepper Widget
 */

#ifndef PSTEPPER_H
#define PSTEPPER_H

#include <sys/types.h>
#include <gtk/gtk.h>

#ifndef gbool
# define gbool	guchar
#endif


/*
 *	Page stepper structure:
 */
typedef struct {

	gbool initialized;
	gbool map_state;

	GtkWidget	*toplevel,
			*pages_toplevel, *nariatives_toplevel,
			*buttons_toplevel;

	/* Current page and total pages. Note that total pages will
	 * be used to indicate all array members here.
	 */
	gint current_page;
	gint total_pages;

	/* Array of page and nariative client set toplevel widgets.
	 * Allocation size of array indicated by total_pages.
	 */
	GtkWidget **page;
	GtkWidget **nariative_strip;

	/* Array if client data pointers for each page. Allocation size
	 * indicated by total_pages.
	 */
	gpointer *client_data;

	/* Array of callback function pointers which correspond to
	 * each page. Callback inputs are; page stepper pointer,
	 * prev page, new page, client data.
	 * void (*page_cb)(gpointer, gint, gint, gpointer)
	 */
	void **page_cb;

	/* Exit client data and callback. */
	gpointer exit_client_data;
	void (*exit_cb)(gpointer, gint, gpointer);

	/* Finish client data and callback. */
	gpointer finish_client_data;
        void (*finish_cb)(gpointer, gint, gpointer);

	/* Label text used for back/exit button. */
	gchar *back_text, *exit_text;

	/* Label text used for next/finish button. */
	gchar *next_text, *finish_text;

	/* Back/exit and next/finish buttons. */
	GtkWidget *back_btn, *back_btn_label;
	GtkWidget *next_btn, *next_btn_label;

} pstepper_struct;


extern pstepper_struct *PStepperCreate(
	gchar *title,
	const gchar *back_text, const gchar *exit_text,
	const gchar *next_text, const gchar *finish_text,
	gint width, gint height,		/* Can be 0. */
	gpointer exit_client_data,
	void (*exit_cb)(gpointer, gint, gpointer),
	gpointer finish_client_data,
	void (*finish_cb)(gpointer, gint, gpointer)
);
extern gint PStepperAppend(
	pstepper_struct *ps,
	GtkWidget *page, GtkWidget *nariative,
	gpointer client_data,
	void (*page_cb)(gpointer, gint, gint, gpointer)
);
extern void PStepperChangePage(
	pstepper_struct *ps, gint page_num,
        gbool report_change
);
extern gint PStepperGetPage(pstepper_struct *ps);
extern void PStepperMap(pstepper_struct *ps);
extern void PStepperUnmap(pstepper_struct *ps);
extern void PStepperDestroy(pstepper_struct *ps);



#endif	/* PSTEPPER_H */
