#include <stdio.h>
#include <errno.h>
extern int errno;

#include "ytiming.h"


void GetCurrentTime(YTime *t);
time_t MilliTime(void);
time_t UTime(void);


#define MIN(a,b)	(((a) < (b)) ? (a) : (b))
#define MAX(a,b)	(((a) > (b)) ? (a) : (b))


void GetCurrentTime(YTime *t)
{
        static struct timeval tv[1];


        if((gettimeofday(tv, NULL) < 0) ||
           (t == NULL)
	)
            return;

	t->ms = (tv->tv_sec % 86400) * 1000 + tv->tv_usec / 1000;
	t->us = MAX(tv->tv_usec % 1000, 0);


	return;
}

time_t MilliTime(void)
{
	struct timeval tv[1];

	if(gettimeofday(tv, NULL) < 0)
	{
	    perror("gettimeofday");
            return(-1);
        }
 
        return((tv->tv_sec % 86400) * 1000 + tv->tv_usec / 1000);
}

time_t UTime(void)
{
        struct timeval tv[1];

        if(gettimeofday(tv, NULL) < 0)
        {
            perror("gettimeofday");
            return(-1);
        }

	return(tv->tv_usec);
}
