/*  
  Copyright 2002, Andreas Rottmann

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/
#include <sigc++/class_slot.h>

#include "yehia/script/helper.h"
#include "yehia/script/slot-convert.h"

namespace Yehia
{

namespace Script
{

typedef SigC::Slot1<Object *, const std::list<Object *>&> ObjSlot;


namespace
{

Any do_call(Language& lang, 
            Namespace *ns, 
            const std::string& name, 
            const std::list<Any>& args)
{
  using namespace SigC;
  Object *func_obj = ns->member(name);
  Function *func = func_obj ? func_obj->function_interface() : 0;
  
  if (!func)
    // TODO: give better error msg
    throw Exception("cannot call method '" + name + "', no such method");
  
  Slot slot_ = lang_convert(slot_class(*func, &Function::call), lang);
  return slot_(args);
}

} // namespace <anonymous>

Any call_script_function(Language *lang,
                         Namespace *ns, 
                         const std::string& name,
                         const std::list<Any>& args)
{
  return 
    SigCX::pack<Any, Language&, Namespace *, const std::string&, const std::list<Any>&>(
            SigC::slot(&do_call), *lang, ns, name, args)->tunnel(lang->tunnel(), 
                                                          true);
}


}

}
