/* This is for emacs: -*-Mode: C++;-*- */
/*  
  Copyright 2002, Andreas Rottmann

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/
#if !defined(__LIBUCXX_ERROR_HANDLER_H)
#define __LIBUCXX_ERROR_HANDLER_H

#include <string>

#include <sigc++/slot.h>
#include <sigc++/signal.h>
#include <sigc++/object.h>
#include <sigcx/tunnel.h>

namespace Yehia
{

/** ErrorHandler class.
 */
class ErrorHandler : public SigC::Object
{
  public:
    enum
    {
      LOG_ERROR,
      LOG_CRITICAL,
      LOG_WARNING,
      LOG_MESSAGE,
      LOG_INFO,
      LOG_DEBUG
    };
    
    /// Constructor
    ErrorHandler(ErrorHandler *parent = 0, bool tunnel = true);

    /// The parent object, or NULL
    ErrorHandler *parent() { return(parent_); }

    /// see parent() 
    const ErrorHandler *parent() const { return(parent_); }

    /// Set the parent object
    void set_parent(ErrorHandler *parent) { parent_ = parent; }
    
    /** Emit an error */
    void emit_error(const std::string& message) {
      emit_log(LOG_ERROR, message);
    }
    /// Emit a log message
    void emit_log(int level, const std::string& message);
    
    /** Emitted when a message is logged.
     * \return boolean; if false, pass the error up to the parent object.
     */
    SigC::Signal2<bool, int, const std::string&> log;
  private:
    ErrorHandler *parent_;
    bool tunnel_;
};

}

#endif
