dnl 
dnl  uC++ Convert SigC::Slot Templates
dnl 
dnl  Copyright (C) 2000 Andreas Rottmann <rottmann@users.sourceforge.net>
dnl 
dnl  This library is free software; you can redistribute it and/or
dnl  modify it under the terms of the GNU Library General Public
dnl  License as published by the Free Software Foundation; either
dnl  version 2 of the License, or (at your option) any later version.
dnl 
dnl  This library is distributed in the hope that it will be useful,
dnl  but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
dnl  Library General Public License for more details.
dnl 
dnl  You should have received a copy of the GNU Library General Public
dnl  License along with this library; if not, write to the Free
dnl  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
dnl 
// -*- c++ -*-
dnl Ignore the next line
/* This is a generated file, do not edit.  Generated from __file__ */
include(template.macros.m4)
#ifndef __header__
#define __header__

#include <sigc++/adaptor.h>
#include <sigc++/convert.h>

#include <uc++/sigslot.h>

namespace uC
{

define([MARSHAL_VAL],[[params]BRACE(decr(regexp([$1], [\([0-9]+\)], [\1]))) <<= LOWER($1);])
define([MARSHAL],[dnl
ifelse(NUM($*), 0, , NUM($*), 1, [MARSHAL_VAL($1)], 
       [MARSHAL_VAL($1, $2) MARSHAL(shift($*))])])

define([UNMARSHAL_VAL],[[$1]BRACE(decr(regexp([$2], [\([0-9]+\)], [\1]))) >>= $2;])
define([UNMARSHAL],[dnl
ifelse(NUM($*), 0, , NUM($*), 1, [UNMARSHAL_VAL([params], $1)], 
       [UNMARSHAL_VAL([params], $1) UNMARSHAL(shift($*))])])

dnl
dnl ADAPTOR_FUNCTION(R,[P1..PN])
dnl
define([ADAPTOR_FUNCTION],[dnl
/****************************************************************
***** Adaptor Convert SigC::Slot NUM($2)
****************************************************************/

template <class $1, LIST(ARG_CLASS($2),[$2])>
class [UnMarshalWrapper]NUM($2)
{
  public:
    static Any wrap([SigC::Callback]NUM($2)PROT(<LIST($1,1,ARG_TYPE($2), [$2])>)* d, const ParamList& params)
    {
      ARG_CBDECL($2)
 
      if (params.size() < NUM($2))
        throw BadParam();
      UNMARSHAL(ARG_CBNAME($2))
      Any any_retval;
      d->call(ARG_CBNAME($2));
      [$1] retval = d->call(ARG_CBNAME($2));
      any_retval <<= retval;
      return(any_retval);
    }
};

template <class $1, LIST(ARG_CLASS($2),[$2])>
class [MarshalWrapper]NUM($2)
{
  public:
    static $1 wrap(LIST(PROT(SigC::Callback1<Any,const ParamList&>* d),1, ARG_BOTH($2), [$2]))
    {
      ParamList params(NUM($2));
      MARSHAL($2)
      Any any_retval = d->call(params);
      [$1] retval;
      if (any_retval)
        any_retval >>= retval;
      return(retval);
    }
};

#ifdef SIGC_CXX_PARTIAL_SPEC
template <LIST(ARG_CLASS($2),[$2])>
class [UnMarshalWrapper]NUM($2)<LIST(void,1,ARG_TYPE($2),[$2])>
{
  public:
    static Any wrap([SigC::Callback]NUM($2)PROT(<LIST(void,1,ARG_TYPE($2), [$2])>)* d, const ParamList& params)
  {
    ARG_CBDECL($2)

    if (params.size() < NUM($2))
      throw BadParam();
    UNMARSHAL(ARG_CBNAME($2))
    d->call(ARG_CBNAME($2));
    Any any_retval;
    return(any_retval);
  }
};

template <LIST(ARG_CLASS($2),[$2])>
class [MarshalWrapper]NUM($2)<LIST(void,1,ARG_TYPE($2), [$2])>
{
  public:
    static void wrap(LIST(PROT(SigC::Callback1<Any,const ParamList&>* d),1, ARG_BOTH($2), [$2]))
    {
      ParamList params(NUM($2));
      MARSHAL($2)
      d->call(params);
   }
};
#endif

template <LIST(class $1,1,ARG_CLASS($2),[$2])>
SigC::Slot1<Any, const ParamList&>
convert(const __SLOT__($1,[$2])& s)
  { return(convert(s, &[UnMarshalWrapper]NUM($2)<$1, [$2]>::wrap)); }

template <LIST(class $1,1,ARG_CLASS($2),[$2])>
__SLOT__($1,[$2])
convert(const SigC::Slot1<Any, const ParamList&>& s)
  { return(convert(s, &[MarshalWrapper]NUM($2)<$1, [$2]>::wrap)); }

template <LIST(class $1,1,ARG_CLASS($2),[$2])>
__SIGNAL__($1, [$2])
  [wrap]NUM($2)(__SIGNAL__(Any,const ParamList&) &s)
  {return SigC::convert(s.slot(), &[MarshalWrapper]NUM($2)<$1, [$2]>::wrap);
  }

template <LIST(class $1,1,ARG_CLASS($2),[$2])>
Signal *wrap( __SIGNAL__($1, [$2]) &s)
  {Signal *sig = new Signal(convert(s.slot()));
   s.connect(convert<LIST($1,1,ARG_TYPE($2), [$2])>(slot(sig, &Signal::real_emit)));
   return(sig);
  }
])dnl

ADAPTOR_FUNCTION(R,ARGS(P,1))
ADAPTOR_FUNCTION(R,ARGS(P,2))
ADAPTOR_FUNCTION(R,ARGS(P,3))
ADAPTOR_FUNCTION(R,ARGS(P,4))
ADAPTOR_FUNCTION(R,ARGS(P,5))
ADAPTOR_FUNCTION(R,ARGS(P,6))
ADAPTOR_FUNCTION(R,ARGS(P,7))

#ifdef SIGC_CXX_NAMESPACES
} // namespace
#endif

#endif
