dnl 
dnl  SigC++ Cross-Thread Signal Templates
dnl 
dnl  Copyright (C) 2000 Andreas Rottmann <rottmann@users.sourceforge.net>
dnl 
dnl  This library is free software; you can redistribute it and/or
dnl  modify it under the terms of the GNU Library General Public
dnl  License as published by the Free Software Foundation; either
dnl  version 2 of the License, or (at your option) any later version.
dnl 
dnl  This library is distributed in the hope that it will be useful,
dnl  but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
dnl  Library General Public License for more details.
dnl 
dnl  You should have received a copy of the GNU Library General Public
dnl  License along with this library; if not, write to the Free
dnl  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
dnl 
// -*- c++ -*-
dnl Ignore the next line
/* This is a generated file, do not edit.  Generated from __file__ */
include(template.macros.m4)
#ifndef __header__
#define __header__

#include <sigc++/slot.h>
#include <sigc++/object_slot.h>
#include <sigc++/bind.h>

#ifdef SIGC_CXX_NAMESPACES
namespace SigC
{
#endif

class Tunnel
{
  public:
    class Callback
    {
      public:
        virtual ~Callback() { }
        virtual void invoke() = 0;
    };

    virtual ~Tunnel() { }
    
    virtual void send(Callback *cb, bool sync = false) = 0;
};


dnl
dnl TUNNEL([P1, P2, ...])
dnl
define([TUNNEL],
[/****************************************************************
*****  Tunnel NUM($1)
****************************************************************/
LINE(]__line__[)dnl

template <LIST(class R, 1, ARG_CLASS($1),[$1])>
class [TunnelCallback]NUM($1) : public Tunnel::Callback
{
  public:
    [TunnelCallback]NUM($1)(LIST(PROT(__SLOT__(R, [$1]) slot), 1, ARG_BOTH($1), [$1]))
: LIST(slot_(slot), 1, ARG_CBINIT($1), [$1]) {}
    virtual void invoke() { rv_ = slot_.call(ARG_CBNAME($1)); }
    R tunnel(Tunnel *tunnel, bool sync = false) {
      if (tunnel) {
        tunnel->send(this, sync);
        R tmp;
        if (sync) {
          tmp = rv_;
	  delete this;
        }
        return(tmp);
      }
      else
        return(slot_.call(ARG_CBNAME($1)));
    }
    static R tunnel(LIST(ARG_BOTH($1), [$1], PROT(__SLOT__(R, [$1]) s), 1, Tunnel *tunnel, 1, bool sync, 1)) {
      [TunnelCallback]NUM($1)<LIST(R, 1, ARG_TYPE($1), [$1])> *cb = pack(LIST(s, 1, ARG_NAME($1), [$1]));
      return(cb->tunnel(tunnel, sync));
    }
  protected:
    __SLOT__(R, [$1]) slot_;
    R rv_;
    ARG_CBDECL($1)
};

template <LIST(class R, 1, ARG_CLASS($1), [$1])>
   [TunnelCallback]NUM($1)<LIST(R, 1, ARG_TYPE($1), [$1])> *pack(LIST(PROT(__SLOT__(R,[$1]) s), 1, ARG_BOTH($1), [$1]))
  {       return(new [TunnelCallback]NUM($1)<LIST(R, 1, ARG_TYPE($1), [$1])>(LIST(s, 1, ARG_NAME($1), [$1])));
  }

#ifdef SIGC_CXX_PARTIAL_SPEC
template <ARG_CLASS($1)>
class [TunnelCallback]NUM($1)<LIST(void, 1, ARG_TYPE($1), [$1])> : public Tunnel::Callback
{
  public:
    [TunnelCallback]NUM($1)(LIST(PROT(__SLOT__(void, [$1]) slot), 1, ARG_BOTH($1), [$1]))
: LIST(slot_(slot), 1, ARG_CBINIT($1), [$1]) { }
    virtual void invoke() { slot_.call(ARG_CBNAME($1)); }
    void tunnel(Tunnel *tunnel, bool sync = false) {
      if (tunnel) {
        tunnel->send(this, sync);
        if (sync)
          delete this;
      }
      else
        slot_.call(ARG_CBNAME($1));
    }
    static void tunnel(LIST(ARG_BOTH($1), [$1], PROT(__SLOT__(void, [$1]) s), 1, Tunnel *tunnel, 1, bool sync, 1)) {
      [TunnelCallback]NUM($1)<LIST(void, 1, ARG_TYPE($1), [$1])> *cb = pack(LIST(s, 1, ARG_NAME($1), [$1]));
      cb->tunnel(tunnel, sync);
   }
  protected:
    __SLOT__(void, [$1]) slot_;
    ARG_CBDECL($1)
};
#endif

template <LIST(class R, 1, ARG_CLASS($1), [$1])>
[Slot]NUM($1)<LIST(R, 1, ARG_TYPE($1), [$1])>
  open_tunnel(Tunnel *tunnel, [Slot]NUM($1)<LIST(R, 1, ARG_TYPE($1), [$1])> s, bool sync)
  { return(bind(slot(&[TunnelCallback]NUM($1)<LIST(R, 1, ARG_TYPE($1), [$1])>::tunnel), s, tunnel, sync));
  }


])dnl

TUNNEL(ARGS(P,0))
TUNNEL(ARGS(P,1))
TUNNEL(ARGS(P,2))
TUNNEL(ARGS(P,3))
TUNNEL(ARGS(P,4))
TUNNEL(ARGS(P,5))
TUNNEL(ARGS(P,6))
TUNNEL(ARGS(P,7))

#ifdef SIGC_CXX_NAMESPACES
} // namespace
#endif
 
#endif
