/***************************************************************************
 *            private_messages_list.c
 *
 *  Sat Jul 15 20:01:02 2006
 *  Copyright  2006  Emanuele Madeo IZ0ETE
 *  Email <iz0ete@fabaris.it>
 ****************************************************************************/


#include <gtk/gtk.h>
#include <glib.h>
#include <string.h>

#include "support.h"
#include "private_messages.h"
#include "global.h"


GtkWidget *create_private_messages_list() {

	GtkWidget *private_messages_list;
	GtkTreeStore *store_message;
	GtkCellRenderer *renderer,*boldrenderer;
	GtkTreeViewColumn *column;
	GObject *msg_selection;
	
	
	
store_message = gtk_tree_store_new(4,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_STRING);
private_messages_list = gtk_tree_view_new_with_model (GTK_TREE_MODEL(store_message));
 
	g_object_unref (G_OBJECT (store_message));
 
 
  renderer = gtk_cell_renderer_text_new ();
  boldrenderer = gtk_cell_renderer_text_new ();
   g_object_set (G_OBJECT (boldrenderer), "weight", "bold", NULL);
// date - time
  column = gtk_tree_view_column_new_with_attributes ("Date/Time", renderer,
                                                      "text", DATETIME_MSG_COLUMN,
                                                      NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (private_messages_list), column);
	
	column = gtk_tree_view_column_new_with_attributes ("From", boldrenderer,
                                                      "text", MSG_FROM_COLUMN,
                                                      NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (private_messages_list), column);
  
  column = gtk_tree_view_column_new_with_attributes ("To", boldrenderer,
                                                      "text", MSG_TO_COLUMN,
                                                      NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (private_messages_list), column);
  
  column = gtk_tree_view_column_new_with_attributes ("Message", renderer,
                                                      "text", MESSAGE_TEXT_COLUMN,
                                                      NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (private_messages_list), column);
	
	msg_selection = gtk_tree_view_get_selection(private_messages_list);
	g_signal_connect (msg_selection, "changed", G_CALLBACK (message_selected), NULL);

return private_messages_list;	
}


void message_selected (GtkTreeSelection *msg_selection, gpointer user_data) {
GtkTreeIter iter;
GtkTreeStore *store_message;
gchar *get_sent_from, *get_sent_to;
	
	//printf("Message selected\n");
	
	
	 if (gtk_tree_selection_get_selected (msg_selection, &store_message, &iter))
        {
                gtk_tree_model_get (store_message, &iter, MSG_FROM_COLUMN, &get_sent_from, -1);
				gtk_tree_model_get (store_message, &iter, MSG_TO_COLUMN, &get_sent_to, -1);
			
		
			GtkWidget *private_messages_list = lookup_widget(GTK_WIDGET(private_messages_window),"private_messages_list");
			gtk_tree_selection_unselect_all (gtk_tree_view_get_selection(GTK_TREE_VIEW (private_messages_list)));
	
			GtkWidget *send_to = lookup_widget(GTK_WIDGET(private_messages_window),"send_to");
			
			//get_sent_from = uppercase
			//printf("From: %s - To: %s\n",get_sent_from, get_sent_to);
			
			if(strcmp(xwota_settings.call,get_sent_from) == 0) {
				gtk_entry_set_text(GTK_ENTRY(send_to),get_sent_to);
			}
			
			else {
			gtk_entry_set_text(GTK_ENTRY(send_to),get_sent_from);
			}
		}
		
	
}
