/*
 * 				XWOTA 0.4
 *		Copyright Emanuele Madeo IZ0ETE
 *			Email <iz0ete@fabaris.it>
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <string.h>
#include "xwota_main.h"
#include "private_messages.h"
#include "support.h"
#include "global.h"




int
main (int argc, char *argv[])
{
  GtkWidget *xwota;
	

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  add_pixmap_directory (PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps");	
	

connection_status = 0; // Xwota is disconnected
old_freq = g_strdup("0000"); // Inizializing old frequency	(needed for upload policy)
tmp_old_freq = g_strdup("0000"); //Inizializing old tmp frequency (needed for upload policy)
	
freq_change_count =0;
	
// Load preferences	
load_preferences();


// Create main xwota window	
 xwota = create_xwota_main ();
 gtk_widget_show (xwota);
 
 private_messages_window = create_private_messages_window();
 
// Disabling Disconnect Menu
GtkWidget * disconnect = lookup_widget(GTK_WIDGET(xwota),"disconnect");
gtk_widget_set_sensitive(disconnect,FALSE);

// Disabling unimplemented menu
gtk_widget_set_sensitive(check_updates,FALSE);
gtk_widget_set_sensitive(group_messages_settings,FALSE);
gtk_widget_set_sensitive(rig_control,FALSE);
gtk_widget_set_sensitive(search,FALSE);
gtk_widget_set_sensitive(group_messages,FALSE);
gtk_widget_set_sensitive(statistics,FALSE);

// Setting default preferences
gtk_entry_set_text (GTK_ENTRY (frequency), xwota_settings.freq);
gtk_entry_set_text (GTK_ENTRY (comment), xwota_settings.comments);

	
if(strcmp(xwota_settings.participate,"0") == 0) {
gtk_combo_box_set_active(GTK_COMBO_BOX (participate_combo),0);
}
else {
gtk_combo_box_set_active(GTK_COMBO_BOX (participate_combo),1);
}	


if(strcmp(xwota_settings.read_from_rig,"1")== 0) {
	gtk_combo_box_set_active(GTK_COMBO_BOX (read_rig_combo),1);
}
else {
gtk_combo_box_set_active(GTK_COMBO_BOX (read_rig_combo),0);
}

if(strcmp(xwota_settings.autoanswer,"1") == 0) {
	gtk_combo_box_set_active(GTK_COMBO_BOX (autoanswer_combo),1);	
}	
else {
	gtk_combo_box_set_active(GTK_COMBO_BOX (autoanswer_combo),0);	
}	


	
 
write_main_statusbar("Xwota not connected to the server");

  gtk_main ();
  return 0;
}
