// $Id: TideContext.hh,v 1.6 2001/03/23 01:15:56 dave Exp $
/*  TideContext  In lieu of global variables and functions.

    Copyright (C) 1998  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

class TideContext {
public:
  TideContext (int in_argc, char **in_argv, Colors *in_colors,
    Settings *in_settings);
  virtual ~TideContext();

  Settings *settings;
  CommandLineSettings *cls;
  Colors *colors;
  HarmonicsPath *harmonicsPath;
  Dstr homedir, disabledisclaimerfile;

  // If there is no index yet, this function will build one.
  // This is overridden in xxTideContext but it's NOT VIRTUAL.
  // (Different signatures.)
  // It only matters on the first invocation, since that is the
  // only one where there might be a title screen popped up.
  StationIndex *stationIndex();
  // Avoid building an index.
  StationRef *fastload (const Dstr &name);

  // Generate one line of text mode output, applying global formatting
  // rules and so on.
  //    station -- (in)
  //    dir -- (in) search direction
  //    tm -- (inout) internal timestamp
  //    line -- (out) output
  //    etype -- (out) event type
  //    t_out -- (out, optional) external timestamp
  // This does not eliminate duplicates caused by switching direction.
  void predictText (Station *station, Station::Direction dir,
    Timestamp &tm, Dstr &line, Station::EventType &etype,
    Timestamp *t_out = NULL);

  // Generate text mode output.  The timestamps here are "internal"
  // timestamps!
  void textMode (Station *station, Timestamp start_tm, Timestamp end_tm,
    Dstr &text_out);
  void textMode (Station *station, Timestamp start_tm, Dstr &text_out);

  // Other modes.
  void calendarMode (Station *station, Timestamp start_tm, Timestamp end_tm,
    Dstr &text_out, int html_form, int oldcal);
  void rawMode (Station *station, Timestamp start_tm, Timestamp end_tm,
    Interval step, Dstr &text_out);
  void listModePlain (Dstr &text_out);
  void listModeHTML (Dstr &text_out);
  void bannerMode (Station *station, Timestamp start_tm, Timestamp end_tm,
    Dstr &text_out);
  void statsMode (Station *station, Timestamp start_tm, Timestamp end_tm,
    Dstr &text_out);

  void startLocListHTML (Dstr &d);
  void listLocationHTML (Dstr &d, StationRef *sr);
  void endLocListHTML (Dstr &d);

  struct tideline {
    Timestamp t_out;
    Dstr text;
    struct tideline *next;
  };

protected:
  StationIndex *myStationIndex;
  void text_boilerplate (Station *station, Dstr &text_out, int html_form = 0);
  // This is overridden in xxTideContext but it's NOT VIRTUAL.
  // (Different signatures.)
  void doHarmonicsFile (Dstr &fname);
  StationRef *doFastloadHarmonicsFile (Dstr &fname, const Dstr &stationname);
};

void version_string (Dstr &text_out);
