// $Id: Settings.hh,v 1.1 2000/08/30 22:56:46 dave Exp $
/*  Settings  XTide global settings

    Copyright (C) 1998  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

class Settings {
public:
  Settings();
  virtual ~Settings();
  virtual char *settingsid();

  // This causes all non-null settings in the parameter to overwrite
  // the matching settings in the chosen instance.
  void supersedeBy (const Settings &sup);

  // The short variable names correspond to the command-line arguments.
  // See README, Resources.

  // Colors.
  // Dstr bg, fg, bc, dc, ec, fc, mc, nc, Dc, Mc;
  Dstr colors[numcolors];

  // Graphs and clocks.
  unsigned gw, gh, cw;
  double ga, lw;
  int gw_isnull, gh_isnull, ga_isnull, cw_isnull, lw_isnull;

  // Default globe longitude
  // Valid values: -180 -150 -120 -90 -60 -30 0 30 60 90 120 150 360
  // 360 will pick the longitude with the most tide stations.
  int gl_isnull;
  double gl;

  // TTY mode.
  unsigned tw, th;
  int tw_isnull, th_isnull;

  // Etc.
  Dstr u, z, df, hf, tf, el, tl, nf, ns;

  // Write to ~/.xtide.xml
  void save();

protected:
  double getdouble (char *val);
  int getint (char *val);
  double getposdouble (char *val);
  double getgldouble (char *val);
  unsigned getposint (char *val);
  double getposdouble (const Dstr &val);
  double getgldouble (const Dstr &val);
  unsigned getposint (const Dstr &val);
};
