#include <errno.h>
#include <sys/types.h>
#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "config.h"
#include <pwd.h>
#include "xtelld.h"
#include <readline/readline.h>
#include <readline/history.h>

unsigned short int verbose = 0;
char *prompt = "xtell> ";

void
verbose_message (char *s)
{
  if (verbose == 1) {
	printf ("%s", s);
	fflush (NULL);
  }
}


/*
 * write_to_log - write log if you can
 */
int
write_to_log (fromluser, toluser, message)
	 char *fromluser, *toluser, *message;

{
  FILE *file;
  char path[200];
  struct passwd *passs;

  time_t tim = time (NULL);
  char bleah[20];
  strftime (bleah, sizeof (bleah), "%R %m-%b-%y", localtime (&tim));

  if ((passs = getpwnam (fromluser)) != NULL) {
	(void) sprintf (path, "%s/%s", passs->pw_dir, ".xtell-log");
	if ((file = fopen (path, "a")) != NULL) {
	  fprintf (file, "[%s] -> %s: %s\n", bleah, toluser, message);
	  fclose (file);
	}
  }
  return (0);
}


int
read_from_socket (int sock, char *message)
{
  int retval, i;
  char msg[3];
  int koniec;

  koniec = 0;
  verbose_message ("*** Reading from socket...");

  i = 0;
  msg[0] = 1;
  msg[1] = 1;
  while (!(msg[0] == '\n' || (msg[0] == '\0') || (i >= MAX_MSG_LENGTH))) {
	retval = recv (sock, msg, 1, 0);
	if (retval == -1) {
	  perror ("Error reading reply");
	  return (-1);
	}
	if (msg[0] >= 32)
	  message[i] = msg[0];
	else if (!(msg[0] == 26 || (msg[0] == 13)))
	  i--;
	i++;
  }
  message[i - 1] = '\0';
  if (msg[0] == 26)
	return (1);

  verbose_message ("done.\n");

  return (0);
}



int
write_in_socket (int sock, char *odpoved)
{
  int retval;

  verbose_message ("*** Writing to socket...");

  retval = send (sock, odpoved, strlen (odpoved), 0);
  if (retval == -1) {
	perror ("Error sending data");
	return (-1);
  }

  verbose_message ("done.\n");


  return (0);
}




void
cleanup (int how_many, int sock1, int sock2)
{
  int retval;

  verbose_message ("*** Closing socket...");


  /*
     ** Shutdown and close sock1 completely.
   */
  retval = shutdown (sock1, 2);
  if (retval == -1)
	perror ("Error shutting down socket");

  retval = close (sock1);
  if (retval)
	perror ("Error closing socket");

  /*
     ** If given, shutdown and close sock2.
   */

  if (how_many == 2) {
	retval = shutdown (sock2, 2);
	if (retval == -1)
	  perror ("Error shutting down socket");

	retval = close (sock2);
	if (retval)
	  perror ("Error closing socket");
  }

  if (verbose > 0)
	verbose_message ("done.\n");



}


int
readmessage (char *message, unsigned int maxlength)
{
  int c;
  unsigned int count = 0;
  char *p;

  p = message;
  verbose_message ("*** Waiting for you:\n");

#ifdef READLINE
  p = readline (prompt);
  if (!p)
	return (-1);
  add_history (p);
  strncpy (message, p, maxlength);
  free (p);
#else
  do {
	*p = c = getchar ();
	p++;
	count++;
  }
  while (!((c == EOF) || (c == '\n') || (count >= maxlength - 1)));
  *p = '\0';
  if (c == EOF)
	return (-1);
#endif
  return (0);
}


void
usage (void)
{
  printf ("Usage: xtell [-v] user[:tty][@hostname[:port]] [message]\n");
  printf ("or: write user [tty]\n");

}


int
main (int argc, char **argv)
{
  int sock_2;					/* socket */
  static struct sockaddr_in sock2_name;	/* Address str. for socket2 */
  struct hostent hostentstruct;	/* Storage for hostent data. */
  struct hostent *hostentptr;	/* Pointer to hostent data.  */
  char *p;
  int retval;					/* helpful for debugging */
  struct passwd *passs;


  char fromluser[MAX_LUSERNAME_LENGTH], toluser[MAX_LUSERNAME_LENGTH] =
	"", totty[MAX_TTY_LENGTH] = "";
  char buffer[MAX_SOCK_LENGTH];
  char inbuffer[MAX_MSG_LENGTH];
  unsigned int toport = XTELL_DEFAULT_PORT;
  char bufftoluser[MAX_LUSERNAME_LENGTH + MAX_TTY_LENGTH + 2] = "";
  char buffhost[MAX_HOSTNAME + 10] = "", tohost[MAX_HOSTNAME] = "";

  char *name;
  unsigned short int write_mode;
  unsigned int i = 1;

  if (argc == 1) {
	usage ();
	exit (1);
  }

  if ((name = strrchr (argv[0], '/')))
	name++;
  else
	name = argv[0];

  if ((p = getenv ("XTELLPROMPT")) != NULL) {
	prompt = p;
  }

  write_mode = (!strcmp (name, "write"));
  if (write_mode) {
	if (!((argc == 2) || (argc == 3))) {
	  usage ();
	  exit (1);
	}

	strncpy (toluser, argv[1], MAX_LUSERNAME_LENGTH);
	if (argc == 3) {
	  strncpy (totty, argv[2], MAX_TTY_LENGTH);
	}
	if (gethostname (tohost, MAX_HOSTNAME) < 0) {
	  perror ("Error in getting hostname");
	  strcpy (tohost, "localhost");
/*              exit(1);*/
	}
	prompt = "";

  }

  else {



	if (!strcmp (argv[1], "--help")) {
	  usage ();
	  exit (1);
	}

	if (!strcmp (argv[1], "--version")) {
	  printf ("xtell %s\n", VERSION);
	  exit (1);
	}

//        i = 1;

	if (!strcmp (argv[i], "-v")) {
	  verbose = 1;
	  printf ("*** Verbose mode is on\n");
	  i++;
	  if (argc == 2) {			/* bad number of parameters */
		usage ();
		exit (1);
	  }
	}

	if ((p = strchr (argv[i], '@')) == NULL) {
	  strncat (bufftoluser, argv[i], sizeof (bufftoluser));
	  if (gethostname (buffhost, MAX_HOSTNAME) < 0) {
		perror ("Error in getting hostname");
		strcpy (buffhost, "localhost");
/*    	        exit(1);*/
	  }
	}
	else {
	  strncat (bufftoluser, argv[i], p - argv[i]);
	  strncat (buffhost, p + 1, strlen (argv[i]) - (p - argv[i]));
	}

	if ((p = strchr (bufftoluser, ':')) != NULL) {
	  strncat (toluser, bufftoluser, p - bufftoluser);
	  strncat (totty, p + 1, MAX_TTY_LENGTH);
	}
	else {
	  strncpy (toluser, bufftoluser, sizeof (toluser));
	}

	if ((p = strchr (buffhost, ':')) != NULL) {
	  strncat (tohost, buffhost, p - buffhost);
	  toport = atoi (p + 1);
	}
	else {
	  strncpy (tohost, buffhost, sizeof (tohost));
	}
  }

  passs = getpwuid (geteuid ());
  strncpy (fromluser, passs->pw_name, MAX_LUSERNAME_LENGTH);
/*    cuserid(fromluser); */

  verbose_message ("*** Getting host address...");

  if ((hostentptr = gethostbyname (tohost)) == NULL) {
	printf ("%s\n", tohost);
	perror ("Host not found");
	return (-1);
  }

  verbose_message ("done.\n");

  hostentstruct = *hostentptr;

  sock2_name.sin_family = hostentstruct.h_addrtype;
  sock2_name.sin_port = htons (toport);
  sock2_name.sin_addr = *((struct in_addr *) hostentstruct.h_addr);

  if ((sock_2 = socket (AF_INET, SOCK_STREAM, 0)) == -1) {
	perror ("socket");
	return (-1);
  }

  verbose_message ("*** Connecting...");

  retval = connect (sock_2, &sock2_name, sizeof (sock2_name));
  if (retval) {
	perror ("connect");
	cleanup (1, sock_2, 0);
	return (-1);
  }


  verbose_message ("done.\n");


  if (argc > i + 1) {
	for (i++; i < argc; i++) {
	  snprintf (buffer, sizeof (buffer), "%s:%s:%s:%s\r\n", fromluser,
				toluser, totty, argv[i]);
	  write_in_socket (sock_2, buffer);
	  write_to_log (fromluser, toluser, argv[i]);
	  read_from_socket (sock_2, buffer);
	  if (buffer[0] == '4')
		printf ("%s\n", buffer);
	}

  }
  else {

	while (readmessage (inbuffer, MAX_MSG_LENGTH) == 0) {
	  snprintf (buffer, sizeof (buffer), "%s:%s:%s:%s\r\n", fromluser,
				toluser, totty, inbuffer);
	  write_in_socket (sock_2, buffer);
	  write_to_log (fromluser, toluser, inbuffer);
	  if (read_from_socket (sock_2, buffer) == -1)
		break;
	  if (buffer[0] == '4')
		printf ("%s\n", buffer);
	}
	if (!write_mode)
	  printf ("Thank you for using xtell.\n");
  }

  sprintf (buffer, "QUIT\n");

  verbose_message ("*** Telling the other side we are through: ");

  write_in_socket (sock_2, buffer);

  cleanup (1, sock_2, 0);
  return (0);

}								/* end main */
